/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef HAND_HPP
#define HAND_HPP

#include "Common.hpp"
#include "Card.hpp"
#include <string>
using namespace std;

class Hand {
public:
  enum {
    NUM_CARDS = Common::CARDS_PER_HAND
  };

  Hand();
  Hand(const Card& c1, const Card& c2,
       const Card& c3, const Card& c4,
       const Card& c5);

  ~Hand();
  
  const Card& getCard(int index) const;
  Card        removeCard(int index);
  void        removeCard(const Card& card);
  void        setCard(int index, const Card& card);
  void        replaceCard(const Card& oldCard, const Card& newCard);

  int         contains(Card::Suit suit,
		       Card::Suit trump = Card::NoSuit) const;
  int         count(Card::Suit suit,
		    Card::Suit trump = Card::NoSuit) const;
  int         getValue(const Card::Suit aTrump) const;
  int         cardsLeft() const;

  /* get the best or worst card regardless of suit */
  Card        getBestCard() const;
  Card        getWorstCard() const;

  /* get the index of the best or worst card regardless of suit */
  int         getBestCardIndex() const;
  int         getWorstCardIndex() const;

  /* get the best or worst card of a suit */
  Card        getBestCard(const Card::Suit suit) const;
  Card        getWorstCard(const Card::Suit suit) const;

  /* get the index of the best or worst card of a suit */
  int         getBestCardIndex(const Card::Suit suit) const;
  int         getWorstCardIndex(const Card::Suit suit) const;

  /* get the best or worst card non trump card */
  Card        getBestNonTrump() const;
  Card        getWorstNonTrump() const;

  /* get a card as little better than the one passed in as possible */
  Card        getJustBetterCard(const Card& card) const;
  
  /* get hand's "name" */
  const char* getName() const;

protected:
  Card itsCards[NUM_CARDS];
  string str;
};

#endif /* HAND_HPP */
