/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef GAME_HPP
#define GAME_HPP

#include "Common.hpp"
#include "Deck.hpp"
#include "Player.hpp"

#include "glib.h"

class Game {
public:
  Game();
  virtual ~Game();

  enum Event {
    INVALID = -1,
    START = 0,
    AUCTION_START,
    AUCTION_CONT,
    AUCTION_END,
    DISCARD_START,
    ROUND_START,
    ROUND_CONT,
    ROUND_END,
    DEAL_END,
    ALL_PASS,
    GAME_END,
    PAUSE_END,
    MAX_EVENT
  };

  virtual void run();
  virtual void addEvent(Event ev);

  virtual int  isPaused();
  virtual void setOptions();

  Common::PlayerPosition getDealer();
  Player*                getPlayer(Common::PlayerPosition pos);

  const char* EVtoString(Event e);

protected:
  virtual void processEvent(Event ev);
  virtual void resetForGame();
  virtual void resetForDeal();
  virtual void start();

  virtual void setTopCard();

  virtual void auctionStart();
  virtual void auctionCont();
  virtual void auctionEnd();
  virtual void bidMade(Common::PlayerPosition who, Common::Bid theBid);
  virtual void setBid();
  
  virtual void discardStart();

  virtual void roundStart();
  virtual void roundCont();
  virtual void roundEnd();
  virtual void cardPlayed(Common::PlayerPosition who, const Card& theCard);
  virtual void updateTrickCounts(Common::PlayerPosition theWinner);

  virtual int  isDealOver();
  virtual void dealEnd();
  virtual void updateLonerPoints();
  virtual void updateTakeAllPoints();
  virtual void updateTakeEnufPoints();
  virtual void updateSetPoints();
  virtual void updatePoints(Common::PlayerPosition whosePoints, int howMuch);

  virtual void allPass();
  
  virtual void gameEnd();
  virtual void gameEndForReal();

  virtual void getPlayers();
  virtual void deal();

  virtual void delayBetweenPlays();
  virtual void pause();
  virtual void unpause();

  GSList* itsEventList;
  
  Deck    itsDeck;
  Player* itsPlayers[Common::PLAYERS_PER_GAME];
  Card    itsTopCard;
  Card    itsOldTopCard;

  Common::PlayerPosition itsDealer;
  Common::PlayerPosition itsCaller;
  Common::PlayerPosition itsLeader;
  Common::PlayerPosition itsTurnToPlay;
  Common::PlayerPosition itsLonerSkipped;
  Common::Bid            itsBid;
  Round                  itsRounds[Common::ROUNDS_PER_GAME];
  Common::PlayerPosition itsRoundLeader[Common::ROUNDS_PER_GAME];
  Common::PlayerPosition itsRoundWinner[Common::ROUNDS_PER_GAME];
  int                    itsRoundCount;

  int     itsNSTricks;
  int     itsEWTricks;

  int     itsNSPoints;
  int     itsEWPoints;

  enum State {
    INIT = 0,
    INAUCTION1,
    AFTERAUCTION1,
    INAUCTION2,
    AFTERAUCTION2,
    INDISCARD,
    INROUND,
    AFTERROUND,
    AFTERDEAL,
    AFTERGAME
  };

  State itsState;
  int   itsPaused;
  string s;
};

#endif
