/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef COMPUTER_PLAYER_HARD_HPP
#define COMPUTER_PLAYER_HARD_HPP

#include "ComputerPlayer.hpp"

class ComputerPlayerHard : public ComputerPlayer {
public:
  ComputerPlayerHard(Common::PlayerPosition myPos);
  virtual ~ComputerPlayerHard();

  virtual Common::Bid  auction1(const Card& upCard,
				Common::PlayerPosition dealer);
  virtual void auction1End(const Card& upCard);
  virtual Common::Bid  auction2(Card& yourTrump,
				const Card& upCard,
				bool stuck);
  virtual Card discard(Card& newCard);
  virtual void setBid(Common::PlayerPosition who,
		      Common::Bid bid);
  virtual Card getCard(const Round& theRound, 
		       Common::PlayerPosition whoStarted);
  virtual void finishRound(const Round& theRound,
			   Common::PlayerPosition whoStarted);
  virtual void finishDeal(int NSPoints, int EWPoints);

protected:
  void rateHand(Card::Suit trump);
  
  Card getCard1(const Round& theRound, Common::PlayerPosition whoStarted);
  Card getCard2(const Round& theRound, Common::PlayerPosition whoStarted);
  Card getCard3(const Round& theRound, Common::PlayerPosition whoStarted);
  Card getCard4(const Round& theRound, Common::PlayerPosition whoStarted);

  void       resetDealVariables();
  int        isBestInSuit(const Card& card);
  Card::Suit getPartnerHintSuit();
  Card       getProbableNonTrumpWinner();
  int        isProbableWinner(Card& card,
			      Common::PlayerPosition excludePos1,
			      Common::PlayerPosition excludePos2);
  Card       getDuckCard();
  
  enum HandRating {
    UTTER_CRAP    = 0x01,
    DECENT_POINTS = 0x02,
    GOOD_POINTS   = 0x04,
    OFFSUIT_POWER = 0x08,
    TRUMP_POWER   = 0x10,
    VOID_POWER    = 0x20
  };

  enum PlayStyle {
    OFFENSIVE = 0x01,
    LONEROFF  = 0x02,
    CATALYST  = 0x04,
    DEFENSIVE = 0x08
  };
  
  Common::PlayerPosition itsOpponentPos[(Common::PLAYERS_PER_GAME / 2)];
  Card                   itsOutOfPlay;
  Common::PlayerPosition itsWhoBid;
  Common::Bid            itsWhatBid;
  PlayStyle              itsPlayStyle;
  Round                  itsRounds[Common::ROUNDS_PER_GAME];
  int                    itsRoundNum;
  unsigned int           itsHandRating;
  unsigned int           itsBaseHandValue;
  unsigned int           itsTrumpCount;
  unsigned int           itsTrumpValue;
  unsigned int           itsNumLosers;
  Card::Suit             itsPartnerHintSuit;
  int                    itsOthersVoids[Common::PLAYERS_PER_GAME][Card::Spades+1];
  int                    itsCardsPlayed[Card::Spades+1];
};

#endif /* COMPUTER_PLAYER_HARD_HPP */
