/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef COMPUTER_PLAYER_EASY_HPP
#define COMPUTER_PLAYER_EASY_HPP

#include "ComputerPlayer.hpp"

class ComputerPlayerEasy : public ComputerPlayer {
public:
  ComputerPlayerEasy(Common::PlayerPosition myPos);
  virtual ~ComputerPlayerEasy();

  virtual Common::Bid  auction1(const Card& upCard,
				Common::PlayerPosition dealer);
  virtual Common::Bid  auction2(Card& yourTrump,
				const Card& upCard,
				bool stuck);
  virtual Card discard(Card& newCard);
  virtual Card getCard(const Round& theRound, 
		       Common::PlayerPosition whoStarted);

protected:
  Card getLeadCard();
  Card getNonLeadCard(const Round& theRound, 
		      Common::PlayerPosition whoStarted);
};

#endif /* COMPUTER_PLAYER_EASY_HPP */
