/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef GLOBALS_H
#define GLOBALS_H

#include <gtk/gtk.h>

#include <Common.hpp>
#include <pixmaps.hpp>
#include <Card.hpp>
#include <GuiGame.hpp>
#include <GuiOptions.hpp>

extern GtkWidget*  mainwin;
extern GtkWidget*  prefdiag;
extern GtkWidget*  prevdiag;
extern GtkWidget*  cardPixmaps[(Card::Ace+1)][(Card::Spades+1)];
extern GtkWidget*  origPlayerPixmaps[(Common::CARDS_PER_HAND+1)];

extern GtkWidget*  bidSuitPixmaps[(Card::Spades+1)];
extern GtkWidget*  bidCallPixmaps[2];

extern GtkWidget*  bidEmptyPixmaps[(Common::PLAYERS_PER_GAME)];
extern GtkWidget*  bidSuitEmptyPixmaps[(Common::PLAYERS_PER_GAME)];

#define NUM_CARD_BACK_MAPS 14
extern GdkPixmap*  cardbackPixmaps[NUM_CARD_BACK_MAPS][NUM_CARD_BACKS];
extern GdkBitmap*  cardbackBitmaps[NUM_CARD_BACK_MAPS][NUM_CARD_BACKS];

extern GdkPixmap*  cardbackSelectPixmaps[NUM_CARD_BACKS];
extern GdkBitmap*  cardbackSelectBitmaps[NUM_CARD_BACKS];

extern GtkWidget*  passMarkers[(Common::PLAYERS_PER_GAME)];
extern GtkWidget*  emptyMarkers[(Common::PLAYERS_PER_GAME)];

extern GuiGame*    theGame;

#endif
