/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <Debug.hpp>

#include "callbacks.hpp"
extern "C" {
#include "interface.h"
}
#include "support.hpp"
#include "globals.hpp"
#include "HumanGuiPlayer.hpp"
#include "GuiOptions.hpp"

void
on_new1_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  theGame->addEvent(Game::START);
  theGame->run();
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_main_quit();
}


void
on_properties1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_show(GTK_WIDGET(prefdiag));
}


void
on_passbutton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  Player* p = theGame->getPlayer(Common::SOUTH);
  if (p != NULL) {
    p->assignBid(Common::PASS);

    theGame->addEvent(Game::AUCTION_CONT);
    theGame->run();
  }
}


void
on_pickitupbutton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  Player* p = theGame->getPlayer(Common::SOUTH);
  p->assignBid(Common::PICKITUP);
  
  theGame->addEvent(Game::AUCTION_CONT);
  theGame->run();
}


void
on_lonerbutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  Player* p = theGame->getPlayer(Common::SOUTH);
  p->assignBid(Common::LONER);
  
  theGame->addEvent(Game::AUCTION_CONT);
  theGame->run();
}

void
on_pcard_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
  LOG("enter on_pcard_clicked with %d\n", (int) user_data);
  HumanGuiPlayer* p = (HumanGuiPlayer*) theGame->getPlayer(Common::SOUTH);
  if (p == NULL) {
    return;
  }

  p->setSelectedCard((int) user_data);
  theGame->addEvent(Game::PAUSE_END);
  theGame->run();
}

void
on_bad_pcard_clicked                       (GtkButton       *button,
					    gpointer         user_data)
{
  LOG("### enter on_bad_pcard_clicked ###\n");
  theGame->updateStatus("You must follow suit");
}

gboolean
on_root_button_press_event             (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  if (event->type == GDK_BUTTON_PRESS && theGame->isPaused()) {
    theGame->addEvent(Game::PAUSE_END);
    theGame->run();
    return TRUE;
  }

  return FALSE;
}

void
on_auction2_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  Player* p = theGame->getPlayer(Common::SOUTH);
  p->assignBid((Common::Bid) ((int) user_data));

  theGame->addEvent(Game::AUCTION_CONT);
  theGame->run();
}

void
on_pref_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(GTK_WIDGET(prefdiag));

  GuiOptions::get()->configure();
  theGame->setOptions();
}


void
on_pref_apply_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GuiOptions::get()->configure();
  theGame->setOptions();
}


void
on_pref_cancel_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(GTK_WIDGET(prefdiag));
}


gboolean
on_cardback_select_up_button_press_event (GtkWidget       *widget,
					  GdkEventButton  *event,
					  gpointer         user_data)
{
  return TRUE;
}


gboolean
on_cardback_select_down_button_press_event (GtkWidget       *widget,
					    GdkEventButton  *event,
					    gpointer         user_data)
{

  return TRUE;
}

void
on_bid_clicked                         (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget* t = lookup_widget(mainwin, "bid_loner");
  Player* p = theGame->getPlayer(Common::SOUTH);

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(t))) {
    p->assignBid(Common::LONER, (Card::Suit) (int) user_data);
  } else {
    p->assignBid(Common::PICKITUP, (Card::Suit) (int) user_data);
  }
  
  theGame->addEvent(Game::AUCTION_CONT);
  theGame->run();
}

void
on_bid_pass_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  Player* p = theGame->getPlayer(Common::SOUTH);
  if (p != NULL) {
    p->assignBid(Common::PASS);

    theGame->addEvent(Game::AUCTION_CONT);
    theGame->run();
  }
}

void
on_previous_tricks_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  theGame->showPrevTrickDiag();
}


void
on_next_prev_trick_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  theGame->incrPrevTrickDiag(1);
}


void
on_prev_prev_trick_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  theGame->incrPrevTrickDiag(-1);
}
void
on_prev_trick_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  theGame->hidePrevTrickDiag();
}
