/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef HUMANGUIPLAYER_HPP
#define HUMANGUIPLAYER_HPP

#include "Game.hpp"
#include "Player.hpp"
#include "GuiPlayer.hpp"

class HumanGuiPlayer : public Player, GuiPlayer {
public:
  HumanGuiPlayer(Common::PlayerPosition myPos);
  virtual ~HumanGuiPlayer();

  virtual void setHand(const Hand& theHand);
  virtual void assignBid(Common::Bid bid, Card::Suit trump = Card::NoSuit);

  virtual int isInteractive() const;
  virtual void setTopCard(const Card& upCard);
  virtual void unsetTopCard();
  virtual Common::Bid auction1(const Card& upCard,
			       Common::PlayerPosition dealer);
  virtual void auction1End(const Card& upCard);
  virtual Common::Bid auction2(Card& yourTrump,
			       const Card& upCard,
			       bool stuck);
  virtual Card discard(Card& newCard);
  virtual void setBid(Common::PlayerPosition who,
		      Common::Bid bid);
  virtual void setTrump(Card::Suit trump);
  virtual Card getCard(const Round& theRound, 
		       Common::PlayerPosition whoStarted);
  virtual void finishRound(const Round& theRound,
			   Common::PlayerPosition whoStarted);
  virtual void finishDeal(int NSPoints, int EWPoints);
  virtual void allPass();

  int setSelectedCard(int index);

protected:
  void resortAndShowHand();
  void showBidWindow(GtkWidget* window);
  int  getAutoPlayCard(const Round& theRound, 
		       Common::PlayerPosition whoStarted);

  enum State {
    INIT = 0,
    INAUCTION1,
    INAUCTION2,
    DISCARD1,
    DISCARD2,
    INROUND,
    GETCARD1,
    GETCARD2,
    ENDROUND
  };

  enum CardButtonState {
    NO_CARD_STATE = -1,
    VALID_CARD = 0,
    INVALID_CARD
  };

  State           itsState;
  int             itsSelectedCard;
  int             itsPartnerLoner;
  GtkWidget*      itsCards[(Common::CARDS_PER_HAND+1)];
  CardButtonState itsCardStates[(Common::CARDS_PER_HAND+1)];
  GtkWidget*      itsCardBacks[(Common::CARDS_PER_HAND+1)];

  GtkWidget*      itsBidButtons[(Card::Spades+1)];
  GtkWidget*      itsLonerBidButton;
  GtkWidget*      itsPassBidButton;
};

#endif

