/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-folder-common.h,v 1.9 2004/11/14 18:22:13 hoa Exp $
 */

#ifndef ETPAN_FOLDER_COMMON_APP_H

#define ETPAN_FOLDER_COMMON_APP_H

#include <libetpan/libetpan.h>
#include "etpan-app-types.h"
#include "etpan-subapp-types.h"
#include "etpan-folder-common-types.h"

void etpan_folder_common_handle_key(struct etpan_subapp * app,
    struct etpan_folder_common_app_state * state, int key);

void etpan_folder_common_set_color(struct etpan_subapp * app,
    struct etpan_folder_common_app_state * state);

int etpan_folder_common_init(struct etpan_folder_common_app_state * state);

void etpan_folder_common_done(struct etpan_folder_common_app_state * state);

int
etpan_folder_common_set_root_folder(struct etpan_folder_common_app_state *
    state, struct mailfolder * root,
    int flags);

void etpan_folder_common_flush(struct etpan_subapp * app,
    struct etpan_folder_common_app_state * state);

int etpan_folder_common_display(struct etpan_subapp * app,
    struct etpan_folder_common_app_state * state, WINDOW * w,
    char * help_str);

struct mailfolder *
etpan_folder_common_get_selected_folder(struct
    etpan_folder_common_app_state * state);

void etpan_folder_common_set_node_visible(struct
    etpan_folder_common_app_state * state,
    struct mailfolder * folder);

void etpan_folder_common_set_stat(struct
    etpan_folder_common_app_state * state,
    struct mailfolder * folder,
    int enabled, uint32_t number, uint32_t recent, uint32_t unseen);

int etpan_folder_common_get_stat(struct
    etpan_folder_common_app_state * state,
    struct mailfolder * folder,
    uint32_t * number, uint32_t * recent, uint32_t * unseen);

int
etpan_folder_common_update(struct etpan_folder_common_app_state * state);

int
etpan_folder_common_next_unread_folder(struct
    etpan_folder_common_app_state * state);

#endif
