vcpkg_from_github(
  OUT_SOURCE_PATH ZTD_CMAKE_PATH
  REPO soasis/cmake
  REF 4277edaf7bf237de07c4a9833f6546872ab9f151
  SHA512 f05143068a1f22bd46aa0d8c250afb04b29ffbc0f32d746093bfb61f274d0e212ff9786a5163608097ed989b5b212d73811179f311a37d2b2eedce89cc75ee94
  HEAD_REF main
)

vcpkg_from_github(
  OUT_SOURCE_PATH ZTD_IDK_PATH
  REPO soasis/idk
  REF 6173bb3d433a3dab65e8c356ef69441aa5a86275
  SHA512 083711e9fc9b03aac34c5a7e182691a9bc9ee2d7c2d9ed2f55093423e2655f7a3829bd3e3db82bc42a78721795ca2d21a7b64c71f05e3c03ea3198f6228eb6f2
  HEAD_REF main
)

vcpkg_from_github(
  OUT_SOURCE_PATH SOURCE_PATH
  REPO soasis/text
  REF d76205c12300234f815e099e5f8152f443515df5
  SHA512 836b6cb1a59cd1138bc4c00f9f511bced912d1d5dc36a4a7d757ef1cd7e31cf5046b5a32476ffa89ea9c0ca7834028774f9baa8c74bfc9287cc16ef3b4e987df
  HEAD_REF main
)

vcpkg_cmake_configure(
  SOURCE_PATH ${SOURCE_PATH}
  OPTIONS
    -DFETCHCONTENT_FULLY_DISCONNECTED=ON
    -DFETCHCONTENT_SOURCE_DIR_ZTD.CMAKE=${ZTD_CMAKE_PATH}
    -DFETCHCONTENT_SOURCE_DIR_ZTD.IDK=${ZTD_IDK_PATH}
)
vcpkg_cmake_install()

file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug" "${CURRENT_PACKAGES_DIR}/bin" "${CURRENT_PACKAGES_DIR}/lib")

file(INSTALL "${CMAKE_CURRENT_LIST_DIR}/usage" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}")
file(INSTALL "${SOURCE_PATH}/LICENSE" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}" RENAME copyright)
