# Every update requires an update of these hashes and the version within the control file of each of the 32 ports.
# So it is probably better to have a central location for these hashes and let the ports update via a script
set(QT_MAJOR_MINOR_VER 5.15)
set(QT_PATCH_VER 8)
set(QT_UPDATE_VERSION 0) # Switch to update qt and not build qt. Creates a file cmake/qt_new_hashes.cmake in qt5-base with the new hashes.

set(QT_PORT_LIST base 3d activeqt charts connectivity datavis3d declarative gamepad graphicaleffects imageformats location macextras mqtt multimedia networkauth
                 purchasing quickcontrols quickcontrols2 remoteobjects script scxml sensors serialport speech svg tools virtualkeyboard webchannel websockets
                 webview winextras xmlpatterns doc x11extras androidextras translations serialbus webengine webglplugin wayland)

set(QT_HASH_qt5-3d               3b7b9e2009c9cb9a8c1246651d7c2446bdc4ef73abea9199204fde64575ddbe4dbbab599c030347b26ef1600f354e0d940abb946c952968ca19b26b25bf580b6)
set(QT_HASH_qt5-activeqt         018a2dbaccb23e9f5ecb8f5cdf42a34199a54bbb70d4857f4cf875854460bc6a0150adbb5681f1305ba95f1809918038d2346d1acc980cb0f8522a68019538e7)
set(QT_HASH_qt5-androidextras    46874ad3f12b33d603af3e7c4a17837835213c9ef4a0a9da00305124bfa1eeee669e02ff0a74ee72b44edd8b903e2043803df0d2892c2d28fcd381ce6d13f8e4)
set(QT_HASH_qt5-base             29e8877bafdbc908072209f1b27a5040b022e2b71f17f4ab4cecd570adeae21597f9af7f1d38758760f3cb30376eeb15c5f066bf02c6e9a9e3a4d07f967046ce)
set(QT_HASH_qt5-charts           1c57e2f92d33c038ddf17fa5f8863b474f229fb2d8f2eb16e8f48455c98b3f500d3a7d73423c0512b6c44ad33227fac3fca624bfcdbc4bbcf64da54f79b4ac7b)
set(QT_HASH_qt5-connectivity     d600e7b600a8cc204333b69bbbd37bc6f4d578bf50406a705c9bc9b04a0399461c8cc8e3bf89a8e0a8820897e9d586d77543570de6229a0cfed312b422b9fda6)
set(QT_HASH_qt5-datavis3d        607359e2489ed33b12f56ace2aedef71e1342d88835d4f81346008f180c8ee74d3f2897e812b7bc9ac6c586908a9ee426d61e226c4faab3baa9d162a604665cc)
set(QT_HASH_qt5-declarative      c611cc1d25b7eea1da3e5932d253d024459044d8fff6a31066033ea5867dd20aeb183b2d2ba8a2ca71cf263fc1921126509212dd43ab680134e7a9df8d937d73)
set(QT_HASH_qt5-doc              1e24ab1e8813928cc5240740d2a979a1194ea125ca45fb3b11154f750cc6cc3f3c9c5977f5cacbca1bec3cdee527ebf1d93b02adde5d0f604a3252903f083220)
set(QT_HASH_qt5-gamepad          f1002906dd53f4c6108b1a7965454e9d30f433b954f90218927b943eb65a63a280f00eea78d21847f91789923e3211a7b8aa599c32157873d1f42153d2e309db)
set(QT_HASH_qt5-graphicaleffects bac9d18492b7ce0092ae9e3b27bcbc2fa421531eb76b3f4c69d20eeaa0520201eca850a2cc692c38f00b8efb24015cd28f53bd892b350e3c1d1337003b399c28)
set(QT_HASH_qt5-imageformats     e601a1ebd0881e59c1f87df748faf63df12f552fe668d16af27a58421848ba4de822b4dc3fc54f23c17b818408b6af2edbfb0b59c29e7da8a272d25ac51d7cdd)
set(QT_HASH_qt5-location         a337fade917150c13fa2ea22ad1949f41541cea4ceb1f732ab53c20c2f19a63dcfc6f9f544ca64fdb5703d3ac8d2ec6e832f1f199a32e73a2f6c51febf53f514)
set(QT_HASH_qt5-macextras        f79f337fa2555a472560cc71748a6b3c52c406704c71795f59ee6e1e2c777bb7dd9e68461e923e9953439a052a8547f2f5a85b4dcb58c850f93a22a80faacb2d)
set(QT_HASH_qt5-mqtt             c0dd94fbdda9f031bdde89ccfe7ec4b306a8c96740f523d9807a7f1af951635f65b851b0f0dfe260bc21ca77fd2b47042218d6fa73695e509ea020b438867e69)
set(QT_HASH_qt5-multimedia       d448a612845e0afb896d6d0292506a8fae7da0b735ee4d139ab69123c93e67723aa41280dea7e704df89e43b849e7f6da3eeea1de94eee167b43d7c35a1a39cd)
set(QT_HASH_qt5-networkauth      1680d6ec84b2fba24c837ff808c5b9e13b73a84c7353f6d533e10986f23f879e0d3ce9cc4ce84000b4cfbd5904e12d975210977f5376b070075c2ec814eb2baf)
set(QT_HASH_qt5-purchasing       9bff75d85b331211cdc74405c01dfb4bdd142015ea66f8292bbefa140c0a6268509ed2c635f440779e78a6433994908ef5d50a74270a5377d9a37286de278953)
set(QT_HASH_qt5-quickcontrols    4b93b1cc69f455bc0e3e06e9702a25791f1dcd9f3b5454ce791ab66cbc5a9ad2f3a91cf664bc2e66369c64d8d52555a02262bc8333866f1d5ff9335de1ea4040)
set(QT_HASH_qt5-quickcontrols2   d42fd70f1d9d1d951e5a8eee886311bf70f0c9b21718b3b76b87ee38fee010c654abc82259e73883c9aca36dafcefb25e5297bf34213cafe4da6a68c4f45d816)
set(QT_HASH_qt5-remoteobjects    a6610df5da8811f0cc19a24759b84fcf84f19e6dbba8e3d45e1edefad1eef750fd56b0fe95992385790207b09f7a0cfe94eec13eddb6ae2c13b5305789f01bc7)
set(QT_HASH_qt5-script           977bb6d134c499e010d96383fd2e81c10c2864af305770353b378af1eb81debe6bd4cfa304b296ce100af87155066ce7a09b68d83c74de6e4113e2b01a1c5638)
set(QT_HASH_qt5-scxml            f1e560e3091eb60b70e5b7ab187511708d16c1b2e8a0c1a6d7a95358eb3ed998bdf0e57b7855e38a773509805790603e3e8e64627f52f05f305d8a29108db9f2)
set(QT_HASH_qt5-sensors          333bc05dd3bf4ba8ca4069279bf5e73f59475dd0d6e0411f16dc796f4cceb4354a7730be931ad868ef7052ebf8e36e151155dbe6576e9f33a38494bb589611d9)
set(QT_HASH_qt5-serialbus        7877834f775d98464a5a220348ba395b91d6c4ce0cb794f2cd56d0878e8a7a36a1aff69abbcaa231a4ee42950b2b9db9db578d27dacaa48382522b0dd9bbe88a)
set(QT_HASH_qt5-serialport       974ae97ec9bdbb4bcecc80a07c343efe4ed686c968810e76fb0e4cd62165949c30d57a37035ac08916850cc2d207fabc0aa09e593184e65fc6d74b36bfbdc444)
set(QT_HASH_qt5-speech           01b625f44ea0ce799ab338f76ca17701025f288b0e83d8d36f5ad0f8b1fd505bb3fa109ace6942c19b0d5734e01aae1c69b28f7da98f986066dcd0ae0d175cee)
set(QT_HASH_qt5-svg              a110a815e7399fc96b0197b96e9c6dec289b9a2c38393711ccfc536c087791009f8452e222f9364b5b133930fa4dea77d7bea2f250511c0511a1a76aa511dcda)
set(QT_HASH_qt5-tools            1248b61e21d1bab30c6f8380af0b83ffd2c5f4e75b2906f561f8aae3a8be2e426ca4ffa28164d64a90cc75c570652229847c7009b7aec63c6ba8e977dbdd4f4f)
set(QT_HASH_qt5-translations     384767c1726db54935c982452b03002e209f4b090b3374c725617a3f5f3af70e8d895b7826039fa04f537fd4e0491a143190fb580298c74edaad0d72b8545917)
set(QT_HASH_qt5-virtualkeyboard  b2f4dddf67556d5d83ee5d0587909ebc745daa9b161b2a12e7e2135b37229b35c7ee2e3a30296f805e5e83648828c973aa2e62e130f2bac739fd228cea38a327)
set(QT_HASH_qt5-wayland          6c6e9dc20f98d71abd7dba54ff278bf4535e70f86bfc4e6dd46c1af7c87777f045a6aba02bba3eb786f7cf383da5fb72b03e1e6ec636c8be0cde0e4e5b7b5b2d)
set(QT_HASH_qt5-webchannel       d607b74f6f433be874e42808259fdc6fa69e1ec754544e1f7d614b6a65ed266cdba76e0a7cd535d65045bc708045c8757c1b3826c7885bc08a787458b60ae1cc)
set(QT_HASH_qt5-webengine        2c4df48de31cb93a77ba9a5119bc57749ba0509f25348d16f97111c446f122d336e5a03f580c9371a487992f3c98190c622bb7ae314b26fbdfdf27a535504dd9)
set(QT_HASH_qt5-webglplugin      1d23543b439e5aa2c1356d7ee1023bfb11c868289c156fe8e81fb8c94358f42649ea11766029feaea9f107ad592fb0a4e7881e108a5cea5691efbbccf59470b6)
set(QT_HASH_qt5-websockets       d44f8beab7536882cb4c8b9250a9e39a274b549b0ff6ea003f16c614a9e5f1bef7d0526acacd3d4382dea9ddc86be1631903df72a605b4cde06aa109320fe05f)
set(QT_HASH_qt5-webview          1afa2c5b7e4a0f422986ac982345d398af9cf468c2e8690205e5d7a820b0eb8c44e4a6d711735d039a05c44c1c6c4f41faf7bfe4cb2bbbd248b278a3e6c72cb5)
set(QT_HASH_qt5-winextras        c6e230913e255b81fd199448df7a1131e54e3d172703ec88c304f0c22ee58c0780dd1b3a6da87864a3abc465c8e747f12c2cea81ceb572d0222026b50c0bfa5e)
set(QT_HASH_qt5-x11extras        a7b2cd611ec863b43cbf16a09868a9543b4dfc3c40b21c23317a3520345a9464e2ad34f884f3619fa67fdf563bc2d1a8b31d97d063766a8988454ee4a8c8e1fd)
set(QT_HASH_qt5-xmlpatterns      150a1425b763d42d8fa8f06a520ed5280ac6d7874e5ef0b617bd5a452ea1899d96909a4d04bae030256f7acc8a76f6f434a7aafd0a0756abf3f1534ef4a0a0b6)

if(QT_UPDATE_VERSION)
    message(STATUS "Running Qt in automatic version port update mode!")
    set(_VCPKG_INTERNAL_NO_HASH_CHECK 1)
    if("${PORT}" MATCHES "qt5-base")
        function(update_qt_version_in_manifest _port_name)
            set(_current_control "${VCPKG_ROOT_DIR}/ports/${_port_name}/vcpkg.json")
            file(READ ${_current_control} _control_contents)
            #message(STATUS "Before: \n${_control_contents}")
            string(REGEX REPLACE "\"version.*\": \"[0-9]+\.[0-9]+\.[0-9]+\",\n" "\"version\": \"${QT_MAJOR_MINOR_VER}.${QT_PATCH_VER}\",\n" _control_contents "${_control_contents}")
            string(REGEX REPLACE "\n  \"port-version\": [0-9]+," "" _control_contents "${_control_contents}")
            #message(STATUS "After: \n${_control_contents}")
            file(WRITE ${_current_control} "${_control_contents}")
            configure_file("${_current_control}" "${_current_control}" @ONLY NEWLINE_STYLE LF)
        endfunction()

        update_qt_version_in_manifest("qt5")
        foreach(_current_qt_port_basename ${QT_PORT_LIST})
            update_qt_version_in_manifest("qt5-${_current_qt_port_basename}")
        endforeach()
    endif()
endif()
