#ifndef _TDFCONFIG_H
#define _TDFCONFIG_H 1
/*
 *                           t d F C o n f i g . h
 *
 *  Function:
 *     Include file for the configuration allocation package, CONFIG.
 *
 * Sccs Id:     tdFconfig.h, Release 1.3, 01/24/02
 *
 *  History:
 *     28th Sep 1994.  Original version. KS/AAO.
 *     10th Oct 1994.  Added definitions of ConfigButtonClear() etc. KS/AAO.
 *     17th Oct 1994.  Parameter routines now provided in both algorithm-
 *                     specific and non-specific code. KS/AAO.
 *     22nd Jan 1999.  Merge in GBD's changes - Add ObjName to 
 *                     CONFIG_TargetInfo structure.  Add function prototypes
 *                     ConfigSetImportFile() nad ConfigSetImportOnlyMode().
 *                     Also add ConfigMethodSetImportFile() prototype and
 *                     SCCS Id.  TJF/AAO.
 *     07th Mar 2000.  Major changes to support new style where the
 *                     algorithm routines are called via function pointer. 
 *                     TJF/AAO.
 *     08th Mar 2000.  Extract tdFconfigMethod.h from tdFconfig.h.
 *     20th Mar 2000.  Add ConfigSetPivotFlag() and ConfigSetSpecPivotsFlag()
 *                     TJF/AAO.
 *     28th Mar 2000.  Add CONFIG_AllocRptFunction etc.
 *     19th Apr 2000.  Drop ConfigFieldCheck1().
 *     22nd Aug 2000.  Made sure Status was undefined so it can be used as
 *                     a variable name. Forced explicit include of status.h
 *                     and sds.h KS/AAO.
 *     19th Nov 2001.  Added ConfigSetSky(). KS/AAO.
 *      3rd Jan 2001.  Added PositionerTolerances argument to ConfigFieldCheck()
 *                     calling sequence. KS/AAO.
 *
 */
 
#ifdef Status
#undef Status
#endif

#include "status.h"
#include "sds.h"

#include "fpil.h"
#include "tdFconfigMethod.h"

#ifdef __cplusplus
extern "C" {
#endif

/* -------------------------------------------------------------------------- */

/*  These are the documented interface routines provided for call from
 *  outside the configuration allocation package. Changing the interfaces
 *  defined here will involve not only updating the documentation, but will
 *  also require the equivalent changes to any program that uses the
 *  allocation package.
 */

void ConfigInitialise (
   FpilType Instrument,          /* (>) Instrument details         */
   FpilConstantsType InstConstDetails,/* (>)  Instrument constants details */
   ConfigInfoRoutine InfoRoutine, /* (>) Info reporting routine */
   void *FunctionArg,             /* (>) Caller-supplied argument */
   StatusType *Status);           /* (!) Inherited status variable */

void ConfigSetTargets (
   char *FileName,                /* (>) File containing structure */
   SdsIdType TopID,               /* (>) SDS ID of top of structure */
   int Field,                     /* (>) Field in question */
   CONFIG_ReportFunction ReportFunction,
                                  /* (>) Feedback routine to call */
   void *FunctionArg,             /* (>) Caller-supplied argument */
   StatusType *Status);           /* (!) Inherited status */

void ConfigAllocate (
   CONFIG_ReportFunction ReportFunction,
                                  /* (>) Feedback routine to call */
   void *FunctionArg,             /* (>) Caller-supplied argument */
   CONFIG_AllocRptFunction AllocReport,
                                  /* (>) Allocation report function */
   void *AllocRptArg,             /* (>) Caller-supplied argument */
   StatusType *Status);           /* (!) Inherited status */

void ConfigClose(
   StatusType *Status);           /* (!) Inherited status variable */

int ConfigNumberParameters (void);/* (<) Returns number of parameters */

void ConfigParameterDetails (     /*     Gets details of a given parameter */
   int ParameterNumber,           /* (>) Number of parameter */
   char **Name,                   /* (<) Parameter name */
   char *Type,                    /* (<) Type code for parameter */
   double Limits[2],              /* (<) Numerical range */
   int *NValues,                  /* (<) # of possible values */
   char ***Values,                /* (<) List of possible values */
   StatusType *Status);           /* (!) Inherited status */

void ConfigSetParameter (         /*     Set value of a named parameter */
   char *Name,                    /* (>) Name of parameter */
   char *Value,                   /* (>) Value for parameter */
   StatusType *Status);           /* (!) Inherited status */

void ConfigGetParameter (         /*     Get value of a named parameter */
   char *Name,                    /* (>) Name of parameter */
   char *Value,                   /* (>) Value for parameter */
   int VSize,                     /* (>) Maximum number of characters */
   StatusType *Status);           /* (!) Inherited status */


void ConfigFieldCheck (          /*     Performs a full field validation */
   CONFIG_ReportFunction ReportFunction,
                                 /* (>) Feedback routine to call */
   void *FunctionArg,            /* (>) Caller-supplied argument */
   int PositionerTolerances,     /* (>) If true, use positioner tolerances */
   StatusType  *status);         /* (!) Inherited status variable */

void ConfigSetImportFile(
   char name[80]);               /* (>) Name of Import File */

void ConfigSetImportOnlyMode(
   int value);                   /* (>) New value for flag */

void ConfigRegisterMethod(
    const CONFIG_MethodDetails *Method,/* (>) Details of new method */
    int Enable,                        /* (>) Is method to be enabled */
    unsigned *Index,                   /* (<) Method Index          */
    StatusType *status);               /* (!) Inherited status variable */
    


void ConfigSelectMethod(
    unsigned Index,              /* (>) Index of method to select */
    StatusType *status);         /* (!) Inherited status variable */

void ConfigNumMethods(
    unsigned *Number,            /* (>) Number of methods available */
    StatusType *status);         /* (!) Inherited status variable */

void ConfigGetMethodName(
    unsigned Index,              /* (>) Index of method to select */
    unsigned Namelen,            /* (>) Length of name            */
    char *Name,                  /* (<) Name is written here      */
    StatusType *status);         /* (!) Inherited status variable */


extern void ConfigSetPivotFlag(
    int Pivot,                   /* (>) Pivot to change the flag */
    int flag,                    /* (>) New value for the flag   */
    StatusType *Status);         /* (!) Inherited status variable */

extern void ConfigSetSpecPivotsFlag(
    int Spec,                    /* (>) Spectrograph to change pivots flags */
    int flag,                    /* (>) New value for the flag   */
    StatusType *Status);         /* (!) Inherited status variable */

extern void ConfigSetSky(
   int FibreType,                /* (>) Fibre type code */
   int NumberSkyAllocations,     /* (>) Number of fibres for sky targets */
   StatusType *Status);          /* (!) Inherited status */

/*
 * Return the details for the default method implementation.
 */
extern void ConfigMethodDetails(CONFIG_MethodDetails *MethodDetails);



#ifdef __cplusplus
}
#endif
#endif
