#ifndef _FPCOL_FPMDL_H
#define _FPCOL_FPMDL_H
/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: fpcolMdl.h 77237 2003-01-31 05:42:32Z flamemgr $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* tfarrell  20/06/00  created
* tfarrell  03/11/00  We can't have a macro defined to indicate VLT.  Instead
*                     use DRAMA_BUILD to indicate DRAMA.
* tfarrell  10/07/01  Merge in JAB's code for actual model.
*                     Add fpcolMdlDramaErrorToVLTError() routine.
* tfarrell  11/07/01  Rename OzPos to OzPoz.
*                     Add fpcolMdlCvtMeanToRT() and associated type 
*                     fpcolMdlPM_PARS .
* tfarrell  17/07/01  Add fpcolMdlCvtMeanToXY().
* tfarrell  31/07/01  This include file may be included in a database defintion
*                     module (for fpfas).  We only need the definition of
*                     fpcolMdlMODEL_N_PARS defined so ensure we don't define
*                     anything else by using the MAKE_DBL macro.
* tfarrell  01/08/01  Drop fpcolMdlMODEL_N_PARS, use fpcolMdl_NUM_PARS instead.
* tfarrell  24/08/01  Must include fpDefines.h every time.
* tfarrell  04/09/01  Add fpcolMdlDump.
* tfarrell  20/09/01  Remove fpcolMdlDramaErrorToVLTError, repalced
*                     by fpcolDRAMAErrorToVLTError in fpcol.h
* tfarrell  20/09/01  Support building with the calibration software, external
*                     to VLT software, indicated by CAL_BUILD macro.
* tfarrell  16/04/02  Add fpcolMDL_PAR_* items.  Add fpcolMdlNormalize()
* tfarrell  10/05/02  Ensure fpcolMdlCvtMeanToXY() and fpcolMdlCvtMeanToRT() are const correct.
* tfarrell  20/06/02  Dropping the last distortion parameter due to new model.
* tfarrell  27/06/02  Added fpcolMdlRd2Tan().
* tfarrell  25/08/02  Added fpcolMdlNormalizeDist(), renamed fpcolMdlNormalize()
*                     to fpcolMdlNormalizeLinear
* tfarrell  30/09/02  CvtInit needs the field centre wavelength as well as
*                     the observation wavelength.
* tfarrell  18/10/02  Added fpcolMdlMicrons2Arcsec prototype.
* rschmutz  23/11/02  fpInsStatus.sds -> ../config/fpInsStatus.sds
* rschmutz  28/01/03  fpInsStatus.sds -> fpossInsStatus.sds
*/

/************************************************************************
 *
 * Header file for the OzPoz Telescope Model interface to the AAO's FPIL 
 * library, required by the CONFIGURE program and the VLT instrumtation
 * software.
 *
 * If this module is compiled without the macro DRAMA_BUILD defined then 
 * it is assumed DRAMA and the fpil.h include file are not available.  
 * This module will then emulate what is provided by fpil.h and status.h 
 * sufficently for use of this module as part of the OzPoz instrument 
 * environment.
 *
 *----------------------------------------------------------------------
 */

/*
 * fpcolMdlReadModel and fpcolMdlWriteModel are not used in the VLT environment or
 * configure, but instead in the Calibration software.  The use the file name
 * given by fpcolMODEL_FILE, which is plate specific.  
 *
 * fpcolMdlTransAccess is used from configure and uses the name given
 * by fpcolSTATUS_FILE, which is the OzPoz instrument structure file.
 *
 * A command - fpcolMdlLoadModel() will load a model form the calibration 
 * software into the VLT fp DB.
 */
#define fpcolMODEL_FILE      "OzPozModel%d.sds"
#define fpcolSTATUS_FILE     "../config/fpossInsStatus.sds"


/*
 * Macros defining the location of items in the array of telescope
 * model parameters saved to the file and stored/fetched.
 */
#define fpcolMDL_PAR_LASTLIN 5           /* Last linear model parameter index */
#define fpcolMDL_PAR_ROT     6           /* Rotation parameter index          */
#define fpcolMDL_PAR_SCALE   7           /* Scale parameter index             */
#define fpcolMDL_PAR_NW_DIST_FIRST  8    /* First non-wavelength dependent distortion par index */
#define fpcolMDL_PAR_NW_DIST_LAST   10   /* Last  non-wavelength dependent distortion par index */
#define fpcolMDL_PAR_W_DIST_FIRST 11     /* First wavelength dependent distortion par index */
#define fpcolMDL_PAR_W_DIST_LAST  12     /* Last  wavelength dependent distortion par index */
#define fpcolMDL_PAR_NONPERP 18          /* Non-perpendicularity              */

#include "fpDefines.h"


#ifndef DRAMA_BUILD
/*
 * VLT or calbration software mode. only mode.  
 * No fpil.h available.  status.h can only
 * be used when compiling the fpcolMdl module itself (indicated by
 * FMDL_MODULE being defined) or if building for the calibration
 * softare (CAL_BUILD macro defined)..
 *
 * First define StatusType, normally defined in status.h
 */
#if defined(FPCOL_MDL_MODULE) || defined(CAL_BUILD)

#include "status.h"

#else

typedef int StatusType;
#define STATUS__OK 0

#endif /* defined FPCOLMDL_MODULE */

/*
 * Now define things we need from fpil.h
 */
typedef void (*FpilRptRoutineType) (
        void * clientData,
        const char *string,
        StatusType *status);

/*
 * We need FpilModelType, which is a FpilModeStruct.  But we don't acutally
 * use FpilModelStruct contents when compiling under VLT, so just make
 * it a dummy structure
 */
struct FpilModelStruct {
    void * dummy;
};
typedef struct FpilModelStruct FpilModelType;

/*
 * VLT and OzPoz (FP) include files we need.
 */
#ifndef CAL_BUILD
#include "ccs.h"
#include "err.h"
#include "fpTypes.h"
#endif

#define IN
#define OUT

#else /* defined DRAMA_BUILD */
/*
 * DRAMA (configure) version.  We can use fpil.h.  We include
 * fpcolMdl_err.h for compatiblity with older versions.
 */
#include "status.h"
#include "fpcolMdl_err.h"
#include "fpil.h"
#endif /* defined DRAMA_BUILD */



/*
 * This structure contains parameters used for proper motion calcuations.
 *
 * Note that if compiled for c++, a inline constructor can be used
 * to initailse the object.
 */

struct  fpcolPM_PARS {
    double ra;       /* Proper motion - RA, changes per Julian Year */
    double dec;      /* Proper motion - Dec, changes per Juilian Year */
    double parallax; /* Parallax (arcsec) */
    double radialVel;/* Radial velocity (km/s, +ve if receding) */

    
#ifdef __cplusplus
    /*
     * If compiling for C++ - compile the constructor
     */
    fpcolPM_PARS(double r=0,double d=0, double p=0, double rv=0) :
        ra(r), dec(d), parallax(p), radialVel(rv) {};
#endif    
};
    


/*
 * Exported functions.
 */

#ifdef __cplusplus
extern "C" {
#endif

extern void fpcolMdlTransAccess (
    void * clientData,
    const char *dirOverride,
    const char *dirFallback,
    FpilRptRoutineType RptRoutine,
    void * RptArg,
    unsigned int field,
    FpilModelType **model,
    StatusType *status);


extern void fpcolMdlReadModel (
    const char *dirOverride,
    const char *dirFallback,
    FpilRptRoutineType RptRoutine,
    void * RptArg,
    unsigned int field,
    FpilModelType **model,
    StatusType *status);
    
extern void fpcolMdlCreateModel (    
    int npars,
    double *pars,
    unsigned int field, 
    FpilModelType **model,
    StatusType *status);

extern void fpcolMdlCvtInit (
    FpilModelType *model,
    double mjd,
    double dut,
    double temp,
    double pres,
    double humid,
    double cenWave,
    double obsWave,
    const double * params,
    StatusType *status);


extern void fpcolMdlRd2Tan (
    const FpilModelType *model,
    double cra,
    double cdec,
    double ra,
    double dec,
    double mjd,
    double *xi,
    double *eta,
    StatusType *status);

extern void fpcolMdlRd2Xy (
    const FpilModelType *model,
    double cra,
    double cdec,
    double ra,
    double dec,
    double mjd,
    double *x,
    double *y,
    StatusType *status);

extern void fpcolMdlXy2Pos (
        const FpilModelType *model,
        double x,
        double y,
        double *xp,
        double *yp,
        StatusType *status);

extern void fpcolMdlXy2Rd (
    const FpilModelType *model,
    double cra,
    double cdec,
    double x,
    double y,
    double mjd,
    double *ra,
    double *dec,
    StatusType *status);

extern void fpcolMdlPos2Xy (
    const FpilModelType *model,
    double xp,
    double yp,
    double *x,
    double *y,
    StatusType *status);

extern void fpcolMdlFree (
    const FpilModelType *model,
    StatusType *status);

extern void fpcolMdlQuickAppToObs  (
    const FpilModelType *model,
    double ra,
    double dec,
    double *aob,
    double *zob,
    double *hob,
    double *dob,
    double *rob,
    StatusType *status);

extern void fpcolMdlWriteModel(
    FpilModelType *model,
    char* dirname, 
    StatusType *status);
    
extern void fpcolMdlGetModel(
    FpilModelType *model,
    int npars,
    double *pars,
    StatusType *status);
    
extern void fpcolMdlSetModel(
    FpilModelType *model,
    int npars,
    double *pars,
    StatusType *status);
    

extern void fpcolMdlNormalizeLinear  (
    double rotation,
    double scale,
    double nonperp,
    double *a,
    double *b,
    double *c,
    double *d,
    double *e,
    double *f,
    StatusType *status);

extern void fpcolMdlNormalizeDist  (
    double scale,
    double *d0,
    double *d1,
    double *d2,
    double *d3,
    double *d4,
    double *d5,
    StatusType *status);

extern void fpcolMdlNormalizeModel  (
     FpilModelType *model,
     StatusType *status);

extern void fpcolMdlDump(FpilModelType *model);

extern void fpcolMdlMicrons2Arcsec(
    const FpilModelType *model,
    const double microns,
    double * const arcsec,
    StatusType * const status);

#ifndef DRAMA_BUILD
#ifndef CAL_BUILD


extern ccsCOMPL_STAT fpcolMdlCvtMeanToXY(
    IN  const FpilModelType *model,
    IN  const fpFIBRE_SKY_POS *skyCoord,
    IN  const struct fpcolPM_PARS *pmPars,
    IN  double cenRA,
    IN  double cenDec,
    IN  double mjd,
    IN  const double gmap[21],
    OUT fpPOS *pos,
    OUT double *appRA,
    OUT double *appDec,
    OUT ccsERROR *error);

extern ccsCOMPL_STAT fpcolMdlCvtMeanToRT(
    IN  const FpilModelType *model,
    IN  const fpFIBRE_SKY_POS *skyCoord,
    IN  const struct fpcolPM_PARS *pmPars,
    IN  double cenRA,
    IN  double cenDec,
    IN  double mjd,
    IN  const double gmap[21],
    OUT fpFIBRE_POS *plateCoord,
    OUT double *appRA,
    OUT double *appDec,
    OUT ccsERROR *error);
#endif /* ! CAL_BUILD   */
#endif /* ! DRAMA_BUILD */


#ifdef __cplusplus
}
#endif


#endif /*!_H*/
