#ifndef _FPCOL_INST_DESCR_H
#define _FPCOL_INST_DESCR_H
/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: fpcolInstDescr.h 75769 2002-12-21 21:03:20Z flamemgr $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* tjf       08/06/00  created
* tjf       15/06/00  Values filled in based on email from Peter Gillingham
* tjf       31/10/00  Remove anything we can pick up from fpDefines.h and
*                     include that.
* ks        30/01/01  Decreased maximum pivot angle from 35 to 26 degrees.
* ks        02/02/01  Used the fibre radius rather than the diameter in the
*                     definition of the required fibre clearance.
* dpopovic  29/10/01  fpcolINST_EXTENSION = ( fpcolINST_PIVOT_RAD+10000)
*                     New definitions replacing FPDLT.db attributes:
*                     fpcolINST_FID_MIN_NUM, fpcolINST_SAFE_RADIUS,
*                     fpcolINST_FIBRE_PATH_TOL.
* tfarrell  01/11/01  Update PARK/PIVOT/FIELD radius values and comments. 
*                     Add  fpcolINST_PIV_ANGLE_MOVE_STARTS definition which
*                     may end up being used by fpcolBase.c.
* tfarrell  16/11/01  Limit field with to 18.4 arc-minute and make fibres 5mm
*                     in diameter to avoid retractor releated problems.
* tfarrell  16/01/02  Add an FACB tail length - they are longer.  In addition,
*                     allow an extra 5mm since the fibres are not flexible
*                     near the tail.
* dpopovic  03/03/02  Paranal - #defines for MK_I and MK_II retractors
*                     MK_II values used.
* dpopovic  11/03/02  Paranal - #define fpcolINST_PARK_RAD_MK_II  444500
* dpopovic  19/03/02  Paranal - #define fpcolINST_PIVOT_RAD_MK_II 460000
* tfarrell  20/03/02  Increase fpcolINST_FIBRE_CLEAR by 1000 (1mm) to allow
*                     for  inprecise definition of pivot point.
* dpopovic  21/10/02  Introduction of fpcolINST_BUNDLE_EXT
* rschmutz  20/12/02  IFU range updated.
*/

/************************************************************************
 *
 * OzPoz Instrumentation Description Include file.
 *
 * This include file defines various values required to describe
 * details of the OzPoz instrument, for example, Fibre Button sizes.
 *
 * NOTE: This include file is used by both the instrument software and
 * the configure software.  The Instrument software is written to VLT
 * software specifications.  The configure software is a standalone program
 * written using the AAO's DRAMA style.  This include file must be
 * compatible with both styles.  But is should only be a set
 * of #define's.
 *----------------------------------------------------------------------
 */

/*
 * Pick up the standard fp Defines, which are part of this instrument
 * description.  When we build outside of the fp environment, we must
 * fetch this fpDefines.h file into the current directory.
 */
#include "fpDefines.h"
/*
 *  Field plate and fibre descriptions.  Values are in microns unless 
 *  otherwise noted.
 */

/*
 * If fibres parked on the plate - MK I retractors:
 * ================================================
 * The assumption in the three values below are that the buttons are parked
 * on plate (which is of diameter 440mm) at least 1mm in from the edge of the plate.
 * Since the buttons are 6 mm in diameter, this makes the park radius 440-(1+6/2)=436. The
 * usable field is therefor 436-(6/2) = 433mm.
 * The pivot radius is a bit of a problem as the pivot point appears to move
 * depending on the angle involved.  When with-in +/- 17 degrees, it could
 * be taken as at 460mm, but when outside this range, it should be taken to
 * be 450mm.  If we assume 450 we are probably close enough
 *
 * If fibres parked on the porch - MK II retractors:
 * =================================================
 * The centre of the porch is ~5mm from the edge of the plate, so the parked
 * position is: plate radius (440mm) + 5mm = 445mm = 445000 microns.
 * The pivot radius is a bit of a problem as the pivot point appears to move
 * depending on the angle involved.  We assume 460mm to be probably close enough.
 *
 */

/*
 *  TEMP ONLY - LIMIT FIELD TO ABOUT 18.4 MINUTES (318688 microns on plate) 
 *  TO AVOID PUTTING FIBRES IN ZONE
 *  WHERE THEY MIGHT INTERFERE WITH OTHERS (UNTIL WE GET MKII RETRACTORS)
 *
*/

#define fpcolINST_FIELD_RAD_18_4  318688  /* Usable Field Radius on the plate, for the
					   * limited field of 18.4 minutes */   
#define fpcolINST_FIELD_RAD_FULL  433000  /* Usable Field Radius on the plate, 433mm.
					   * We assume that almost full plate is usable! */
#define fpcolINST_FIELD_RAD       fpcolINST_FIELD_RAD_FULL


#define fpcolINST_PARK_RAD_MK_I   436000  /* Radius of park positions, for MK I   */
#define fpcolINST_PARK_RAD_MK_II  444500  /* Radius of park positions, for MK II  */
#define fpcolINST_PARK_RAD        fpcolINST_PARK_RAD_MK_II


#define fpcolINST_PIVOT_RAD_MK_I  450000  /* Radius of fibre pivot point, for MK I */
#define fpcolINST_PIVOT_RAD_MK_II 460000  /* Radius of fibre pivot point, for MK II */
#define fpcolINST_PIVOT_RAD       fpcolINST_PIVOT_RAD_MK_II


#define fpcolINST_ARGUS_RAD 14000    /* Diameter around Argus.  Can place
                                        buttons within 7mm of center of
                                        plate */


#define fpcolINST_FID_RAD  450      /* Fiducial hole radius */
#define fpcolINST_FID_DIA  (fpcolINST_FID_RAD*2)  /* Fiducial hole diameter */


/*
 * FIELD_ON_SKY is an approximation of the field size on the sky in
 * radians - 25 arc minutes = 
 *    25/60 * 2 * PI /360
 */
#define fpcolINST_FIELD_ON_SKY   ((2.0*M_PI*25.0)/(360.0*60.0))

/*
 * Button and fibre description.

  
             (Crude) Plain view of Button.
  
                  RAD                 TAIL
                   |                   |
                   v                   v
      
                        ---
                      -     - 
                    -        -----------          <-THW
                   -     o             +------  
                    -        -----------
                      -     -
                        ---
                         ^
                         |
                         |
                       Origin - center of microprism.

    The OzPoz button is circular but there is a tail on the fibre.

 *  All dimensions in microns unless stated.
 */
#define fpcolINST_POS_ACCURACY   60      /* (15 RMS) Spec-ed positioner accuracy     */

#define fpcolINST_BUTTON_RAD     3000    /* Button radius - 3.0 mm          */

#define fpcolINST_BUTTON_TAIL_SPEC 10000   /* Length of tail, Medusa and UVES, 10mm   */
#define fpcolINST_BUTTON_TAIL_IFU   8250   /* Length of tail, IFU's, 8.25             */
#define fpcolINST_BUTTON_TAIL_FACB  20000   /* Length of tail, FACB's, 20mm             */
#define fpcolINST_BUTTON_TAIL   (fpcolINST_BUTTON_TAIL_FACB+5000)  /* Length of tail, longer fibre type and allow for inflexibilty of fibre near button.  */


#define fpcolINST_BUTTON_THW_SPEC 900     /* Tail half width, Medusa and UVES, .9mm   */
#define fpcolINST_BUTTON_THW_IFU  1500    /* Tail half width, IFU's, 1.5mm             */


#define fpcolINST_BUTTON_THW  fpcolINST_BUTTON_THW_IFU     /* Tail half width, wider fibre type   */
#define fpcolINST_BUTTON_TD   (fpcolINST_BUTTON_THW_IFU*2)  /* Tail width, wider fibre type*/


#define fpcolINST_FIBRE_DIA_SPEC 1000     /* Diameter of fibre, Medusa and UVES, 1.0mm   */
#define fpcolINST_FIBRE_DIA_IFU  2500     /* Diameter of fibre, IFU's, 2.5mm             */
#define fpcolINST_FIBRE_DIA      3000     /* Assumed diameter of fibre. It is slightly
					   * larger than the largist diameter due to the
					   * moving pivot point. */


/*
 * Other values.  Clearances are just reasonable values chosen based
 * on experience.
 */
#define fpcolINST_EXTENSION     (fpcolINST_PIVOT_RAD+2000) /* Maximum allowed
                                extension, center of plate + 2mm    */

/* Maximum allowed extension of fibre bundles, FACB and IFU, center of plate - 15 mm */
#define fpcolINST_BUNDLE_EXT    (fpcolINST_PIVOT_RAD-15000) 


/* Minimum and maximum radial positions for bundles */
#define fpcolINST_FACB_MIN_RADIUS    50000 
#define fpcolINST_FACB_MAX_RADIUS   380000 
#define fpcolINST_IFU_MIN_RADIUS     15000 
#define fpcolINST_IFU_MAX_RADIUS    fpcolINST_FIELD_RAD_FULL 


#define fpcolINST_BUTTON_CLEAR (100 + fpcolINST_POS_ACCURACY) 
                                         /* Minimum allowed button/button 
                                            clearance (no space required for   
                                            gripper)                        */
#define fpcolINST_FIBRE_CLEAR ((fpcolINST_FIBRE_DIA / 2) + fpcolINST_POS_ACCURACY +1000) 
                                         /* Minimum allowed button/fibre
                                            clearance.   Add an extra mm to allow
					    for inprecsion in pivot point */

#define fpcolINST_FID_CLEAR    100       /* Minimum allowed fiducial/fibre or
                                            fiducial/button clearance.       */

#define fpcolINST_FID_MIN_NUM  3         /* Minimum number of uncovered fiducials.
					    Needed for SURVEY. */

#define fpcolINST_SAFE_RADIUS  320000    /* Safe radius where we do not care about 
					    straight line. */

#define fpcolINST_FIBRE_PATH_TOL  1000    /* Fibre path tolerance for staright line. */

#define fpcolINST_MAX_PIV_ANGLE 0.45378561 
                                         /* +/- max allowed piv/fib , angle,
                                           radians, equivalent to 26 degrees. */
                                              
#define fpcolINST_PIV_ANGLE_MOVE_STARTS 0.296706 /* Angle at which pivot point starts to 
						    move = 17 degrees */
/*
 * We need the value fpcolINST_MAX_BUT_SIZE_CLR representing the size 
 * around the button we are sure the button will be within, from a
 * consertive check point of view.  Used by fpcol.c.  fpcolINST_MAX_BUT_SIZE
 * is just used to calculate fpcolINST_MAX_BUT_SIZE_CLR
 */
#define fpcolINST_MAX_BUT_SIZE (fpcolINST_BUTTON_TAIL+fpcolINST_BUTTON_RAD)
#define fpcolINST_MAX_BUT_SIZE_CLR (fpcolINST_MAX_BUT_SIZE+fpcolINST_BUTTON_CLEAR)


#endif /*!_H*/
