

// $Id$
/*
 * Standard trace metadata used by all ESMF traces.
 *
 * Earth System Modeling Framework
 * Copyright (c) 2002-2024, University Corporation for Atmospheric Research, 
 * Massachusetts Institute of Technology, Geophysical Fluid Dynamics 
 * Laboratory, University of Michigan, National Centers for Environmental 
 * Prediction, Los Alamos National Laboratory, Argonne National Laboratory, 
 * NASA Goddard Space Flight Center.
 * Licensed under the University of Illinois-NCSA License.
 */

#include <string.h>
#include "ESMCI_Trace.h"

namespace ESMCI {

  std::string TraceGetMetadataString() {
    
    std::string metadata_string;
    metadata_string = ""
    "/* CTF 1.8 */\n"
    "\n"
    "/*\n"
    " * The MIT License (MIT)\n"
    " *\n"
    " * Copyright (c) 2015-2016 Philippe Proulx <pproulx@efficios.com>\n"
    " *\n"
    " * Permission is hereby granted, free of charge, to any person obtaining a copy\n"
    " * of this software and associated documentation files (the \"Software\"), to deal\n"
    " * in the Software without restriction, including without limitation the rights\n"
    " * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n"
    " * copies of the Software, and to permit persons to whom the Software is\n"
    " * furnished to do so, subject to the following conditions:\n"
    " *\n"
    " * The above copyright notice and this permission notice shall be included in\n"
    " * all copies or substantial portions of the Software.\n"
    " *\n"
    " * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
    " * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
    " * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n"
    " * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n"
    " * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n"
    " * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n"
    " * THE SOFTWARE.\n"
    " *\n"
    " * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -\n"
    " *\n"
    " * The following TSDL code was generated by barectf v2.2.1\n"
    " * on 2018-08-21 22:52:11.845006.\n"
    " *\n"
    " * For more details, see <http://barectf.org>.\n"
    " */\n"
    "\n"
    "trace {\n"
    "	major = 1;\n"
    "	minor = 8;\n"
    "	byte_order = le;\n"
    "	uuid = \"21c4e078-a5c7-11e8-8529-34f39aeaad30\";\n"
    "	packet.header := struct {\n"
    "		integer {\n"
    "			size = 32;\n"
    "			align = 32;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} magic;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} uuid[16];\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "env {\n"
    "	tracer_major = 2;\n"
    "	esmf_trace_version = \"0.6\";\n"
    "	barectf_gen_date = \"2018-08-21T22:52:11.844952\";\n"
    "	tracer_patch = 1;\n"
    "	domain = \"bare\";\n"
    "	tracer_minor = 2;\n"
    "	tracer_name = \"barectf\";\n"
    "};\n"
    "\n"
    "clock {\n"
    "	name = sys_clock;\n"
    "	description = \"System clock\";\n"
    "	freq = 1000000000;\n"
    "	offset_s = 0;\n"
    "	offset = 0;\n"
    "	precision = 0;\n"
    "	absolute = false;\n"
    "};\n"
    "\n"
    "/* default */\n"
    "stream {\n"
    "	packet.context := struct {\n"
    "		integer {\n"
    "			size = 64;\n"
    "			align = 64;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "			map = clock.sys_clock.value;\n"
    "		} timestamp_begin;\n"
    "		integer {\n"
    "			size = 64;\n"
    "			align = 64;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "			map = clock.sys_clock.value;\n"
    "		} timestamp_end;\n"
    "		integer {\n"
    "			size = 32;\n"
    "			align = 32;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} packet_size;\n"
    "		integer {\n"
    "			size = 32;\n"
    "			align = 32;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} content_size;\n"
    "		string {\n"
    "			encoding = UTF8;\n"
    "		} nodename;\n"
    "		integer {\n"
    "			size = 32;\n"
    "			align = 32;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} pet;\n"
    "	} align(1);\n"
    "	event.header := struct {\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} id;\n"
    "		integer {\n"
    "			size = 64;\n"
    "			align = 64;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "			map = clock.sys_clock.value;\n"
    "		} timestamp;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"prologue_enter\";\n"
    "	id = 0; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} vmid;\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} baseid;\n"
    "		enum : integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} {\n"
    "			\"initialize\" = 0,\n"
    "			\"run\" = 1,\n"
    "			\"finalize\" = 2,\n"
    "		} method;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} phase;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"epilogue_exit\";\n"
    "	id = 1; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} vmid;\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} baseid;\n"
    "		enum : integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} {\n"
    "			\"initialize\" = 0,\n"
    "			\"run\" = 1,\n"
    "			\"finalize\" = 2,\n"
    "		} method;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} phase;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"phase_enter\";\n"
    "	id = 2; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} vmid;\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} baseid;\n"
    "		enum : integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} {\n"
    "			\"initialize\" = 0,\n"
    "			\"run\" = 1,\n"
    "			\"finalize\" = 2,\n"
    "		} method;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} phase;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"phase_exit\";\n"
    "	id = 3; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} vmid;\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} baseid;\n"
    "		enum : integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} {\n"
    "			\"initialize\" = 0,\n"
    "			\"run\" = 1,\n"
    "			\"finalize\" = 2,\n"
    "		} method;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} phase;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"region_enter\";\n"
    "	id = 4; /* default */\n"
    "	fields := struct {\n"
    "		string {\n"
    "			encoding = UTF8;\n"
    "		} name;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"region_exit\";\n"
    "	id = 5; /* default */\n"
    "	fields := struct {\n"
    "		string {\n"
    "			encoding = UTF8;\n"
    "		} name;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"define_region\";\n"
    "	id = 6; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} id;\n"
    "		enum : integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} {\n"
    "			\"comp_phase\" = 0,\n"
    "			\"user_defined\" = 1,\n"
    "		} type;\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} vmid;\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} baseid;\n"
    "		enum : integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} {\n"
    "			\"initialize\" = 0,\n"
    "			\"run\" = 1,\n"
    "			\"finalize\" = 2,\n"
    "		} method;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} phase;\n"
    "		string {\n"
    "			encoding = UTF8;\n"
    "		} name;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"regionid_enter\";\n"
    "	id = 7; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} regionid;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"regionid_exit\";\n"
    "	id = 8; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} regionid;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"comp\";\n"
    "	id = 9; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} vmid;\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} baseid;\n"
    "		string {\n"
    "			encoding = UTF8;\n"
    "		} name;\n"
    "		string {\n"
    "			encoding = UTF8;\n"
    "		} IPM;\n"
    "		string {\n"
    "			encoding = UTF8;\n"
    "		} RPM;\n"
    "		string {\n"
    "			encoding = UTF8;\n"
    "		} FPM;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"mem\";\n"
    "	id = 10; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 32;\n"
    "			align = 32;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} virtMem;\n"
    "		integer {\n"
    "			size = 32;\n"
    "			align = 32;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} physMem;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"clk\";\n"
    "	id = 11; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} year;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} month;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} day;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} hour;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} minute;\n"
    "		integer {\n"
    "			size = 8;\n"
    "			align = 8;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} second;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"mpiwait\";\n"
    "	id = 12; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 32;\n"
    "			align = 32;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} count;\n"
    "		integer {\n"
    "			size = 64;\n"
    "			align = 64;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} time;\n"
    "	} align(1);\n"
    "};\n"
    "\n"
    "event {\n"
    "	name = \"region_profile\";\n"
    "	id = 13; /* default */\n"
    "	fields := struct {\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} id;\n"
    "		integer {\n"
    "			size = 16;\n"
    "			align = 16;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} parentid;\n"
    "		integer {\n"
    "			size = 64;\n"
    "			align = 64;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} total;\n"
    "		integer {\n"
    "			size = 64;\n"
    "			align = 64;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} self;\n"
    "		integer {\n"
    "			size = 32;\n"
    "			align = 32;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} count;\n"
    "		integer {\n"
    "			size = 64;\n"
    "			align = 64;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} max;\n"
    "		integer {\n"
    "			size = 64;\n"
    "			align = 64;\n"
    "			signed = false;\n"
    "			byte_order = le;\n"
    "			base = 10;\n"
    "			encoding = none;\n"
    "		} min;\n"
    "		floating_point {\n"
    "			exp_dig = 11;\n"
    "			mant_dig = 53;\n"
    "			align = 64;\n"
    "			byte_order = le;\n"
    "		} mean;\n"
    "		floating_point {\n"
    "			exp_dig = 11;\n"
    "			mant_dig = 53;\n"
    "			align = 64;\n"
    "			byte_order = le;\n"
    "		} stddev;\n"
    "	} align(1);\n"
    "};\n"
    ;

    return metadata_string;
  }
}
