#include<stdio.h>
#include<stdlib.h> /* malloc() */
#include<ctype.h>  /* isspace() */
#include<unistd.h> /* dup() */
#include<string.h>

#include<errno.h>
extern int errno ;

#include "utils.h"
#include "Logger.h"

/* - - - - - - - - - - - - - - - - - - - - */ 


char* trimSpace( const char *inString ){

	char
		/* value we return to caller */
		*outString
	;

	char
		/* pointers for walking "outString" */
		*begin_string = NULL ,
		*end_string = NULL
	;

	static const char* thisFunction = "trimSpace()" ;

	Logger* log = Logger_getInstance() ;

	log->traceWithID( thisFunction , "entered ( \"%s\" )" , inString ) ; 


	if(
		NULL == inString
		||
		0 == strlen( inString )
	){
		return( NULL ) ;
	}


	/*
	Duplicate string such that we can alter our private copy.

	if strdup fails, we can't do anything, so we bail
	*/

	outString = (char*)strdup( inString ) ;

	if( NULL == outString ){

		log->debugWithID( thisFunction , "unable to duplicate input string" ) ;
		return( NULL ) ;

	}

	/*
	trim whitespace from the head of the string:
	walk "outString" with another pointer until
	we hit a non-space, then reassign "outString"
	to that value.
	*/
	begin_string = outString ; 

	while( 0 != isspace( *begin_string ) ){
		++begin_string ;
	}

	outString = begin_string ; 


	/*
	trim whitespace from the end of the string:
	same deal as with the front of the string,
	but we walk backwards from the end, then cap
	the string with a null.
	*/
	end_string = outString + strlen( outString ) - 1 ;

	while( 0 != isspace( *end_string ) ){
		--end_string ;
	}

	*(end_string + 1)  = '\0' ;

	log->debugWithID( thisFunction , "returning  \"%s\" (%p) (%d)" , outString , outString , strlen( outString ) ) ; 

	return( outString ) ; 

} /* trimSpace() */


/* - - - - - - - - - - - - - - - - - - - - */

const char* printVector( char** vector ){

	static const char* thisFunction = "printVector()" ;

	int length = 0 ;
	int ix = 0 ;
	int max = 0 ;
	static const char* space = " " ;
	char* result = NULL ;


	Logger* log = Logger_getInstance() ;

	log->traceWithID( thisFunction , "entered ( %p )" , vector ) ;

	/* pass 1: get number of elements and length of new string to create */
	while( NULL != vector[ix] ){
		log->debugWithID( thisFunction , "length of \"%s\": %d" , vector[ix] , strlen( vector[ix] ) ) ;

		/* the extra 1 char accounts for the space we'll be putting in after this word */
		length += strlen( vector[ix] ) + 1 ;
		++ix ;
	}

	log->debugWithID( thisFunction , "total string size is %d" , length ) ; fflush( stdout ) ;

	max = ix ;
	ix = 0 ;

	/* pass 2: malloc() new string and copy the vector's contents to it */

	result = (char*) malloc( ( length + 1 ) * sizeof( char ) ) ;

	if( NULL == result ){
		log->debugWithID( thisFunction , "unable to allocate memory for string" ) ;
		return( NULL ) ;
	} else {

		log->debugWithID( thisFunction , "[successfully allocated memory for string]" ) ; fflush( stdout ) ;
	}

	while( ix < max ){
		log->debugWithID( thisFunction , "adding string \"%s\"" , vector[ix] ) ;
		strncat( result , vector[ix] , strlen( vector[ix] ) ) ;
		++ix ;

		if( max != ix ){
			strncat( result , space , 1 ) ;
		}

	}

	log->debugWithID( thisFunction , "done with loop, index is currently %d" , ix ) ;

	result[length -1 ] = '\0' ;
	log->debugWithID( thisFunction , "length of result: %d" , strlen( result ) ) ;
	
	log->traceWithID( thisFunction , "returning %p" , result ) ;
	
	return( result ) ;

} /* printVector() */

/* - - - - - - - - - - - - - - - - - - - - */

char** string2array( const char *inString ){

	static const char* thisFunction = "string2array()" ;

	char
		/* copy of inString that we can alter */
		*commandString = NULL ,

		/* resultant array */
		**commandArray = NULL 
	;

	int

		/* number of items [arguments] in string */
		itemCount = 0 ,

		/* array index for walking string */
		stringIndex = 0
	; 

	Logger* log = Logger_getInstance() ;

	/* -------------------- */

	log->traceWithID( thisFunction , "called..." ) ;

	commandString = (char*)strdup( inString ) ; 

	log->debugWithID( thisFunction , "inString: \"%s\" (%p)" , inString , inString ) ; 

	if( NULL == commandString ){
		log->error( "unable to allocate memory to parse command: %s" , printError(errno));
		/* exit( EXIT_ERROR_NOMALLOC ) ; */
		return( NULL ) ;

    }


	/* pass 1: count the number of arguments in the string */
	itemCount = 1 ; 

	while( '\0' != commandString[stringIndex] ){
		log->debugWithID( thisFunction , "counted %d items" , itemCount ) ;

		if( 0 != isspace( commandString[stringIndex] ) ){
			++itemCount ; 
		}

		++stringIndex ; 
	}


	/*
	create array of char pointers based on the number of args
	add an entry for the final NULL terminator value
	*/

	commandArray = (char **)malloc( (itemCount + 1) * sizeof(char *) ) ;

	if( NULL == commandArray ){
		log->error( "unable to allocate memory to create command vector: %s" , printError(errno));
		return( NULL ) ; 
    }


	/*
	pass 2: replace spaces with NULL's and
	place the items in the array
	*/

	commandArray[0] = strtok( commandString , " " ) ;

	/* reset itemCount for the second walk */
	itemCount = 1 ;

	/*
	this even caps off the array for us... how nice.
	*/
	while( NULL != (commandArray[itemCount] = strtok( NULL , " " )) ){

		log->debugWithID( thisFunction , "parsed out %d items" , itemCount ) ;

		++itemCount ;

	}

	log->traceWithID( thisFunction , "...returning to caller" ) ;
	return( commandArray ) ; 

} /* string2array */


/* - - - - - - - - - - - - - - - - - - - - */

const char* printError( int code ){

	static const char* noError = "errno not set" ;

	const char* result = ( 0 != code ? strerror( code ) : noError ) ;

	return( result ) ;

} /* printError() */


/* - - - - - - - - - - - - - - - - - - - - */

ConfigItem* ConfigItem_create(){

	static const char* thisFunction = "ConfigItem_create()" ;

	Logger* log = Logger_getInstance() ;

	log->traceWithID( thisFunction , "called..." ) ;

	ConfigItem* result = ( ConfigItem* ) malloc( sizeof( ConfigItem ) ) ;

	if( NULL == result ){

		log->debugWithID( thisFunction , "ConfigItem_create(): unable to allocate memory for new structure" ) ;
		return( NULL ) ;
	}

	result->key   = NULL ;
	result->val   = NULL ;
	result->line  = -1 ;
	result->next  = NULL ;

	log->traceWithID( thisFunction , "...returning to caller" ) ;

	return( result ) ;

} /* ConfigItem_create() */

/* - - - - - - - - - - - - - - - - - - - - */

void ConfigItem_free( ConfigItem* current ){

	static const char* thisFunction = "ConfigItem_free()" ;

	Logger* log = Logger_getInstance() ;

	log->traceWithID( thisFunction , "called..." ) ;

	while(
		NULL != current
			&&
		NULL != current->next
	){
		ConfigItem* nextOne = current->next ;
		log->traceWithID( thisFunction , "deleting item..." ) ;
		free( current ) ;
		current = nextOne ;
	}

	log->traceWithID( thisFunction , "...returning to caller" ) ;

	return ;

} /* ConfigItem_free() */

/* - - - - - - - - - - - - - - - - - - - - */

ConfigItem* parseConfig( FILE* file_handle ){

	static const char* thisFunction = "parseConfig()" ;

	Logger* log = Logger_getInstance() ;

	log->traceWithID( thisFunction , "called..." ) ;

	/* current line number */
	int lineNum = 0 ;

	/* input buffer for fgets() */
	static char lineBuf[BUFSIZ] ;

	char
		/* a copy of the input line, minus the surrounding whitespace */
		*trimLine = NULL ,

		/* key/value pair for lines read from file */
		*key = NULL , 
		*val = NULL
	;

	ConfigItem* result = ConfigItem_create() ;

	if( NULL == result ){
		log->debugWithID( thisFunction , "unable to allocate memory for new structure" ) ;
		ConfigItem_free( result ) ;
		return( NULL ) ;
	}

	ConfigItem* current = result ;

	while( NULL != fgets( lineBuf , BUFSIZ , file_handle ) ) {

		++lineNum ;

		/* skip comments and blank lines */
		if(
			'#' == lineBuf[0] 
			||
			0 == strlen( lineBuf )
		){
			log->debugWithID( thisFunction , "line %d is comment/blank, skipping" , lineNum ) ;
			continue ;
		}


		/* chop off the newline */
		lineBuf[ strlen( lineBuf ) - 1 ] = '\0' ;

		trimLine = trimSpace( lineBuf ) ; 


		key = strtok( trimLine , "=" ) ;
		val = strtok( NULL , "=" ) ;

		/* if either value is null, it's an invalid statement */
		if(
			NULL == key
			||
			NULL == val
		){

			log->debugWithID( thisFunction , "line %d key or value is NULL, skipping" , lineNum ) ;
			continue ; 

		}


		current->key = (char*) strdup( trimSpace( key ) ) ;
		current->val = (char*) strdup( trimSpace( val ) ) ; 
		current->line = lineNum ;
		current->next = ConfigItem_create() ;

		log->debugWithID(
			thisFunction ,
			"key \"%s\" => \"%s\" (line %d)" ,
			current->key , current->val , current->line
		) ;

		current = current->next ;

	} 

	/* tear off the last (unused) item */

	ConfigItem_free( current ) ;
	current = NULL ;

	log->traceWithID( thisFunction , "...returning to caller" ) ;

	return( result ) ;

} /* parseConfig() */

/* - - - - - - - - - - - - - - - - - - - - */

const char* printNull( const char* value , const char* defaultValue ){

	return( NULL != value ? value : defaultValue ) ;

} /* printNull() */


/* - - - - - - - - - - - - - - - - - - - - */

/* utils.c */
