## ------------------------------------------------------------
## RPM spec file for Erni
## ------------------------------------------------------------

%define	product_name			erni
%define	product_version			0.50.0
%define rpm_release				1

%define	product_nameversion		%{product_name}-%{product_version}
%define	product_source_dir		%{product_nameversion}
%define	product_tarball			%{product_nameversion}-src.tar.gz
%define product_man_section		8

## CUSTOM RPM BUILDERS: change this macro to move Erni's install path.
%define	install_prefix			/usr

## QQQ - need to find a way to randomize this value
## to prevent race conditions
BuildRoot:						%{_tmppath}/erni-build-root-xxxxx

## ------------------------------------------------------------

## main package
Summary: Erni enables root to run processes as any given user, even if they have no shell.
Name: %{product_name}
Version: %{product_version}
Release: %{rpm_release}
License: similar to Artistic License - see LICENSE file for details
Group: Utilities
URL: http://www.BrandXDev.net/
Vendor: BrandXDev
Source: %{product_tarball}

%description

On Unix-based systems, many user accounts exist only as "daemon"
accounts, or placeholders to run services. For security reasons it is
often desirable to limit these accounts' usage -- for example, to lock
out their passwords or disable their shells.

The problem is that some services require the demon account to have a
valid login shell such that the service may be started at system boot
time, i.e. one of the init.d scripts calls the ever-familiar
     su - <account> -c <start script>

Erni enables you to have the best of both worlds: the daemon account
can still run processes, but it need not have a valid shell to do so.
Erni does this by assuming the daemon account's user priveleges within
the current process space -- using the system's setuid() and setgid()
system calls -- before running the command in question. The account's
shell is never loaded in this case.

Erni also has the option of performing a chroot before running the
command.


## ------------------------------------------------------------

%prep

umask 022
cd ${RPM_BUILD_DIR}
rm -rf ${RPM_BUILD_DIR}/%{product_nameversion}
zcat ${RPM_SOURCE_DIR}/%{product_tarball} | tar xvf -

## soon ...
## cd %{product_source_dir}
## ./configure --prefix=%{install_prefix}

## ------------------------------------------------------------

%build
umask 022
cd ${RPM_BUILD_DIR}/%{product_source_dir}
make

## ------------------------------------------------------------

%install
umask 022

cd ${RPM_BUILD_DIR}/%{product_source_dir}

## RPM_BUILD_ROOT is created for us by RPM.
## if it already exists, the build process will fail
rm -rf ${RPM_BUILD_ROOT}

make ALT_ROOT_DIR="${RPM_BUILD_ROOT}" PREFIX="%{install_prefix}" install

## ------------------------------------------------------------

%clean
rm -rf ${RPM_BUILD_ROOT}

## ------------------------------------------------------------

%files




%dir %attr( -    , root , root ) %{install_prefix}
%dir %attr( -    , root , root ) %{install_prefix}/sbin

## only root can run Erni, so only root needs to see it
     %attr( 0500 , root , root ) %{install_prefix}/sbin/erni

## soon...
%dir %attr( -    , root , root ) %{install_prefix}/man
%dir %attr( -    , root , root ) %{install_prefix}/man/man%{product_man_section}
%attr( 0444 , root , root ) %{install_prefix}/man/man%{product_man_section}/erni.%{product_man_section}.gz

## docs
%doc %dir %attr( -    , root , root ) %{install_prefix}/share
%doc %dir %attr( -    , root , root ) %{install_prefix}/share/doc
%doc %dir %attr( 0555 , root , root ) %{install_prefix}/share/doc/%{product_name}
%doc      %attr( 0444 , root , root ) %{install_prefix}/share/doc/%{product_name}/LICENSE
%doc      %attr( 0444 , root , root ) %{install_prefix}/share/doc/%{product_name}/README
%doc      %attr( 0444 , root , root ) %{install_prefix}/share/doc/%{product_name}/erni.SAMPLE_CONFIG
%doc      %attr( 0444 , root , root ) %{install_prefix}/share/doc/%{product_name}/erni.%{product_man_section}.html
%doc      %attr( 0444 , root , root ) %{install_prefix}/share/doc/%{product_name}/erni.%{product_man_section}.txt


## ------------------------------------------------------------

## EOF erni.spec
