searchData={"items":[{"type":"module","title":"debugger","doc":"The Erlang Debugger for debugging and testing of Erlang programs.","ref":"debugger.html"},{"type":"function","title":"debugger.quick/3","doc":"Debugs a single process.\n\nThe module `Module` is interpreted and\n[`apply(Module, Name, Args)`](`apply/3`) is called. This opens an \"Attach\nProcess\" window. For details, see the\n[User's Guide](debugger_chapter.md).","ref":"debugger.html#quick/3"},{"type":"function","title":"debugger.start/0","doc":"Starts Debugger.\n\nStarted by this function, Debugger interprets code on all known nodes.","ref":"debugger.html#start/0"},{"type":"function","title":"debugger.start/1","doc":"Starts Debugger.\n\nIf `ModeOrFile` is a string, it is assumed to be the name of a file,\nand Debugger tries to load its settings from this file. For details\nabout settings, see the [User's Guide](debugger_chapter.md).\n\nIf `ModeOrFile` is atom `local`, Debugger interprets code only at the\ncurrent node. If `ModeOrFile` is `global`, Debugger interprets code on\nall known nodes.","ref":"debugger.html#start/1"},{"type":"function","title":"debugger.start/2","doc":"Starts Debugger.\n\nDebugger tries to load its settings from the file named by `File`.\nFor details about settings, see the [User's Guide](debugger_chapter.md).\n\nIf `Mode` is `local`, Debugger interprets code only on the current\nnode. If `Mode` is `global`, Debugger interprets code on all known\nnodes.","ref":"debugger.html#start/2"},{"type":"module","title":"i","doc":"Debugger/Interpreter Interface.\n\nThe `i` module provides short forms for some of the functions used by the\ngraphical Debugger and some of the functions in module `m:int`, the Erlang\ninterpreter.\n\nThis module also provides facilities for displaying status information about\ninterpreted processes and break points.\n\nIt is possible to attach to interpreted processes by only giving the corresponding\nprocess identity. By default, an attachment window is displayed. Processes\nat other Erlang nodes can be attached manually or automatically.\n\nThe functions in this module are defined in the Erlang shell. That is,\nthey can be called without the `i:` prefix. For example:\n\n```erlang\n1> ii(t).\n{module,t}\n2> iaa([init]).\ntrue\n```","ref":"i.html"},{"type":"function","title":"i.help/0","doc":"Prints help for using the functions in this module.","ref":"i.html#help/0"},{"type":"function","title":"i.ia/1","doc":"Attaches to the debugged process `Pid`.\n\nAn \"Attach Process\" window is opened for the process.","ref":"i.html#ia/1"},{"type":"function","title":"i.ia/2","doc":"Attaches to the debugged process `Pid`.\n\nThe interpreter calls [`spawn(Module, Name, [Pid])`](`spawn/3`) (and\nignores the result).","ref":"i.html#ia/2"},{"type":"function","title":"i.ia/3","doc":"Equivalent to [`ia(Pid)`](`ia/1`), where `Pid` is the result of calling the shell\nfunction `pid(X, Y, Z)`.","ref":"i.html#ia/3"},{"type":"function","title":"i.ia/4","doc":"Equivalent to [`ia(Pid, Function)`](`ia/2`), where `Pid` is the result of calling the\nshell function `pid(X, Y, Z)`.\n\nAn attached process is expected to call the unofficial function\n`int:attached(Pid)` and to be able to handle messages from the\ninterpreter. For an example, see `dbg_wx_trace.erl`.","ref":"i.html#ia/4"},{"type":"function","title":"i.iaa/1","doc":"Sets when to attach to a debugged process automatically.\n\nDebugger supplies a function that opens \"Attach Process\" window for\nthe process.\n\nSee [int:auto_attach/2](`int:auto_attach/2`) for more information.","ref":"i.html#iaa/1"},{"type":"function","title":"i.iaa/2","doc":"Sets when and how to attach to a debugged process automatically.\n\nSee [int:auto_attach/2](`int:auto_attach/2`) for more information.","ref":"i.html#iaa/2"},{"type":"function","title":"i.ib/2","doc":"Creates a breakpoint at `Line` in `Module`.","ref":"i.html#ib/2"},{"type":"function","title":"i.ib/3","doc":"Creates breakpoints at the first line of every clause of function\n`Module:Name/Arity`.","ref":"i.html#ib/3"},{"type":"function","title":"i.iba/3","doc":"Sets the trigger action of the breakpoint at `Line` in `Module` to `Action`.","ref":"i.html#iba/3"},{"type":"function","title":"i.ibc/3","doc":"Sets the conditional test of the breakpoint at `Line` in `Module` to `Function`.\n\nThe conditional test is performed by calling `Module:Name(Bindings)`, where\n`Bindings` is the current variable bindings. The function must return `true`\n(break) or `false` (do not break). To retrieve the value of a variable `Var`\nuse [int:get_binding(Var, Bindings)](`int:get_binding/2`).","ref":"i.html#ibc/3"},{"type":"function","title":"i.ibd/2","doc":"Makes the breakpoint at `Line` in `Module` inactive.","ref":"i.html#ibd/2"},{"type":"function","title":"i.ibe/2","doc":"Makes the breakpoint at `Line` in `Module` active.","ref":"i.html#ibe/2"},{"type":"function","title":"i.ic/0","doc":"Clears information about processes executing interpreted code by removing all\ninformation about terminated processes.","ref":"i.html#ic/0"},{"type":"function","title":"i.ii/1","doc":"Interprets the specified module(s) on the local node.\n\n- If `AbsModule :: Module | File`, then `Result :: {module, Module} | error`.\n- If `AbsModules :: [AbsModule]`, then `Result :: ok`.\n\nSee `int:i/1` for more information.","ref":"i.html#ii/1"},{"type":"function","title":"i.il/0","doc":"Makes a printout of all interpreted modules.\n\nModules are printed together with the full path name of the\ncorresponding source code file.","ref":"i.html#il/0"},{"type":"function","title":"i.im/0","doc":"Starts a new graphical Monitor window.\n\nThis is the Monitor window, the main window of Debugger. All the\nDebugger and interpreter functionality is accessed from the Monitor\nwindow. This window displays the status of all processes that have\nbeen or are executing interpreted modules.","ref":"i.html#im/0"},{"type":"function","title":"i.ini/1","doc":"Interprets the specified module(s) on all known nodes.\n\n- If `AbsModule :: Module | File`, then `Result :: {module, Module} | error`.\n- If `AbsModules :: [AbsModule]`, then `Result :: ok`.\n\nSee `int:ni/1` for more information.","ref":"i.html#ini/1"},{"type":"function","title":"i.inq/1","doc":"Stops interpreting the specified module on all known nodes.","ref":"i.html#inq/1"},{"type":"function","title":"i.ip/0","doc":"Prints the current status of all interpreted processes.","ref":"i.html#ip/0"},{"type":"function","title":"i.ipb/0","doc":"Prints all existing breakpoints.","ref":"i.html#ipb/0"},{"type":"function","title":"i.ipb/1","doc":"Prints all existing breakpoints in `Module`.","ref":"i.html#ipb/1"},{"type":"function","title":"i.iq/1","doc":"Stops interpreting the specified module on the local node.","ref":"i.html#iq/1"},{"type":"function","title":"i.ir/0","doc":"Deletes all breakpoints in all interpreted modules.","ref":"i.html#ir/0"},{"type":"function","title":"i.ir/1","doc":"Deletes all breakpoints in `Module`.","ref":"i.html#ir/1"},{"type":"function","title":"i.ir/2","doc":"Deletes the breakpoint at `Line` in `Module`.","ref":"i.html#ir/2"},{"type":"function","title":"i.ir/3","doc":"Deletes the breakpoints at the first line of every clause of function\n`Module:Name/Arity`.","ref":"i.html#ir/3"},{"type":"function","title":"i.ist/1","doc":"Sets how to save call frames in the stack.\n\nSee [int:stack_trace/1](`int:stack_trace/0`) for more information.","ref":"i.html#ist/1"},{"type":"function","title":"i.iv/0","doc":"Returns the current version of the interpreter (Debugger).","ref":"i.html#iv/0"},{"type":"module","title":"int","doc":"Interpreter Interface.\n\nThe Erlang interpreter provides mechanisms for breakpoints and stepwise\nexecution of code. It is primarily intended to be used by Debugger; see the\n[Users's Guide for Debugger](debugger_chapter.md) and module `m:debugger`.\n\nThe following can be done from the shell:\n\n- Specify the modules to be interpreted.\n- Specify breakpoints.\n- Monitor the current status of all processes executing code in interpreted\n  modules, also processes at other Erlang nodes.\n\nBy _attaching to_ a process executing interpreted code, it is possible to\nexamine variable bindings and order stepwise execution. This is done by sending\nand receiving information to/from the process through a third process, called\nthe meta process. You can implement your own attached process. See `int.erl` for\navailable functions and `dbg_wx_trace.erl` for possible messages.\n\nThe interpreter depends on the Kernel, STDLIB, and WX applications. This means\nthat modules belonging to any of these applications are not allowed to be\ninterpreted, as it could lead to a deadlock or emulator crash. This also applies\nto modules belonging to the Debugger application.\n\n[](){: #int_breakpoints }","ref":"int.html"},{"type":"module","title":"Breakpoints - int","doc":"Breakpoints are specified on a line basis. When a process executing code in an\ninterpreted module reaches a breakpoint, it stops. This means that a breakpoint\nmust be set at an executable line, that is, a code line containing an executable\nexpression.\n\nA breakpoint has the following:\n\n- A status, which is _active_ or _inactive_. An inactive breakpoint is ignored.\n- A trigger action. When a breakpoint is reached, the trigger action specifies\n  if the breakpoint is to continue as active (_enable_), or to become inactive\n  (_disable_), or to be removed (_delete_).\n- Optionally an associated condition. A condition is a tuple `{Module,Name}`.\n  When the breakpoint is reached, `Module:Name(Bindings)` is called. If it\n  evaluates to `true`, execution stops. If it evaluates to `false`, the\n  breakpoint is ignored. `Bindings` contains the current variable bindings. To\n  retrieve the value for a specified variable use `get_binding/2`.\n\nBy default, a breakpoint is active, has trigger action `enable`, and has no\nassociated condition. For details about breakpoints, see\n[Breakpoints and Break Dialog\nWindows](debugger_chapter.md#breakpoints-and-break-dialog-windows)\nin the User's Guide for Debugger.","ref":"int.html#module-breakpoints"},{"type":"function","title":"int.action_at_break/3","doc":"Sets the trigger action of the breakpoint at `Line` in `Module` to `Action`.","ref":"int.html#action_at_break/3"},{"type":"function","title":"int.all_breaks/0","doc":"Gets all breakpoints.","ref":"int.html#all_breaks/0"},{"type":"function","title":"int.all_breaks/1","doc":"Gets all breakpoints in module `Module`.","ref":"int.html#all_breaks/1"},{"type":"function","title":"int.auto_attach/0","doc":"Gets how to attach automatically to a process executing code in\ninterpreted modules.\n\nSee `auto_attach/2` for the meaning of the possible values in `Flags`.","ref":"int.html#auto_attach/0"},{"type":"function","title":"int.auto_attach/1","doc":"Disables auto attach.","ref":"int.html#auto_attach/1"},{"type":"function","title":"int.auto_attach/2","doc":"Sets when and how to attach automatically to a process executing code\nin interpreted modules.\n\nBy default when the interpreter is started, automatic attach is disabled.\n\nIf `Flags` is an empty list, automatic attach is disabled.\n\nOtherwise `Flags` should be a list containing  at least one of the following\nflags:\n\n- `init` - Attach when a process for the first time calls an interpreted\n  function.\n- `break` - Attach whenever a process reaches a breakpoint.\n- `exit` - Attach when a process terminates.\n\nWhen the specified event occurs, the function `Function` is called as:\n\n```erlang\nspawn(Module, Name, [Pid | Args])\n```\n\n`Pid` is the pid of the process executing interpreted code.","ref":"int.html#auto_attach/2"},{"type":"function","title":"int.break/2","doc":"Creates a breakpoint at `Line` in `Module`.","ref":"int.html#break/2"},{"type":"function","title":"int.break_in/3","doc":"Creates a breakpoint at the first line of every clause of function\n`Module:Name/Arity`.","ref":"int.html#break_in/3"},{"type":"function","title":"int.clear/0","doc":"Clears information about processes executing interpreted code by removing all\ninformation about terminated processes.","ref":"int.html#clear/0"},{"type":"function","title":"int.continue/1","doc":"Resumes process execution for `Pid`.","ref":"int.html#continue/1"},{"type":"function","title":"int.continue/3","doc":"Resumes process execution for `c:pid(X, Y, Z)`.","ref":"int.html#continue/3"},{"type":"function","title":"int.del_break_in/3","doc":"Deletes the breakpoints at the first line of every clause of function\n`Module:Name/Arity`.","ref":"int.html#del_break_in/3"},{"type":"function","title":"int.delete_break/2","doc":"Deletes the breakpoint at `Line` in `Module`.","ref":"int.html#delete_break/2"},{"type":"function","title":"int.disable_break/2","doc":"Makes the breakpoint at `Line` in `Module` inactive.","ref":"int.html#disable_break/2"},{"type":"function","title":"int.enable_break/2","doc":"Makes the breakpoint at `Line` in `Module` active.","ref":"int.html#enable_break/2"},{"type":"function","title":"int.file/1","doc":"Returns the source code filename `File` for an interpreted module `Module`.","ref":"int.html#file/1"},{"type":"function","title":"int.get_binding/2","doc":"Retrieves the binding of `Var` from `Bindings`.\n\nThis function is intended to be used by the conditional function of a breakpoint.","ref":"int.html#get_binding/2"},{"type":"function","title":"int.i/1","doc":"Interprets the specified module(s) on the local node.\n\nA module can be specified by its module name (atom) or filename.\n\nIf specified by its module name, the object code `Module.beam` is searched for\nin the current path. The source code `Module.erl` is searched for first in the\nsame directory as the object code, then in an `src` directory next to it.\n\nIf specified by its filename, the filename can include a path and the `.erl`\nextension can be omitted. The object code `Module.beam` is searched for first in\nthe same directory as the source code, then in an `ebin` directory next to it,\nand then in the current path.\n\n> #### Note {: .info }\n>\n> The interpreter requires both the source code and the object code. The object\n> code _must_ include debug information, that is, only modules compiled with\n> option `debug_info` can be interpreted.\n\nThe functions returns `{module,Module}` if the module was interpreted, otherwise\n`error` is returned.\n\nThe argument can also be a list of modules or filenames, in which case the\nfunction tries to interpret each module as specified earlier. The function then\nalways returns `ok`, but prints some information to `stdout` if a module cannot\nbe interpreted.","ref":"int.html#i/1"},{"type":"function","title":"int.interpretable/1","doc":"Checks if a module can be interpreted.\n\nThe module can be specified by its module name `Module` or its source\nfilename `File`. If specified by a module name, the module is searched\nfor in the code path.\n\nThe function returns `true` if all of the following apply:\n\n- Both source code and object code for the module is found.\n- The module has been compiled with option `debug_info` set.\n- The module does not belong to any of the applications Kernel, STDLIB, WX, or\n  Debugger.\n\nThe function returns `{error,Reason}` if the module cannot be interpreted.\n`Reason` can have the following values:\n\n- **`no_src`** - No source code is found. It is assumed that the source code and\n  object code are located either in the same directory, or in `src` and `ebin`\n  directories next to each other.\n\n- **`no_beam`** - No object code is found. It is assumed that the source code\n  and object code are located either in the same directory, or in `src` and\n  `ebin` directories next to each other.\n\n- **`no_debug_info`** - The module has not been compiled with option\n  `debug_info` set.\n\n- **`badarg`** - `AbsModule` is not found. This could be because the specified\n  file does not exist, or because `code:which/1` does not return a BEAM\n  filename, which is the case not only for non-existing modules but also for\n  modules that are preloaded or cover-compiled.\n\n- **`{app,App}`** - `App` is `kernel`, `stdlib`, `gs`, or `debugger` if\n  `AbsModule` belongs to one of these applications.\n\nNotice that the function can return `true` for a module that is not\ninterpretable the module is marked as sticky or resides in a directory\nmarked as sticky. The reason is that this is not discovered until the\ninterpreter tries to load the module.","ref":"int.html#interpretable/1"},{"type":"function","title":"int.interpreted/0","doc":"Returns a list with all interpreted modules.","ref":"int.html#interpreted/0"},{"type":"function","title":"int.n/1","doc":"Stops interpreting the specified module on the local node.\n\nSimilar to [`i/1`](`i/1`) and [`ni/1`](`ni/1`), a module can be specified by its\nmodule name or filename.","ref":"int.html#n/1"},{"type":"function","title":"int.ni/1","doc":"Interprets the specified module(s) on all known nodes.\n\nA module can be specified by its module name (atom) or filename.\n\nIf specified by its module name, the object code `Module.beam` is searched for\nin the current path. The source code `Module.erl` is searched for first in the\nsame directory as the object code, then in an `src` directory next to it.\n\nIf specified by its filename, the filename can include a path and the `.erl`\nextension can be omitted. The object code `Module.beam` is searched for first in\nthe same directory as the source code, then in an `ebin` directory next to it,\nand then in the current path.\n\n> #### Note {: .info }\n>\n> The interpreter requires both the source code and the object code. The object\n> code _must_ include debug information, that is, only modules compiled with\n> option `debug_info` can be interpreted.\n\nThe functions returns `{module,Module}` if the module was interpreted, otherwise\n`error` is returned.\n\nThe argument can also be a list of modules or filenames, in which case the\nfunction tries to interpret each module as specified earlier. The function then\nalways returns `ok`, but prints some information to `stdout` if a module cannot\nbe interpreted.","ref":"int.html#ni/1"},{"type":"function","title":"int.nn/1","doc":"Stops interpreting the specified module on all known nodes.\n\nSimilar to [`i/1`](`i/1`) and [`ni/1`](`ni/1`), a module can be specified by its\nmodule name or filename.","ref":"int.html#nn/1"},{"type":"function","title":"int.no_break/0","doc":"Deletes all breakpoints.","ref":"int.html#no_break/0"},{"type":"function","title":"int.no_break/1","doc":"Deletes all breakpoints in `Module`.","ref":"int.html#no_break/1"},{"type":"function","title":"int.snapshot/0","doc":"Gets information about all processes executing interpreted code.\n\n- `Pid` - Process identifier.\n- `Function` - First interpreted function called by the process.\n- `Status` - Current status of the process.\n- `Info` - More information.\n\n`Status` is one of the following:\n\n- `idle` - The process is no longer executing interpreted code.\n  `Info` is `{}`.\n- `running` - The process is running. `Info` is `{}`.\n- `waiting` - The process is waiting at a `receive`. `Info` is `{}`.\n- `break` - Process execution is stopped, normally at a breakpoint.\n  `Info` is `{Module,Line}`.\n- `exit` - The process is terminated. `Info` is `ExitReason`.\n- `no_conn` - The connection is down to the node where the process is running.\n  `Info` is `{}`.","ref":"int.html#snapshot/0"},{"type":"function","title":"int.stack_trace/0","doc":"Gets how to save call frames in the stack.\n\nSee `stack_trace/1` for the meaning of `Flag`.","ref":"int.html#stack_trace/0"},{"type":"function","title":"int.stack_trace/1","doc":"Sets how to save call frames in the stack.\n\nSaving call frames makes it possible to inspect the call chain of a\nprocess, and is also used to emulate the stack trace if an error (an\nexception of class error) occurs. The following flags can be\nspecified:\n\n- **`all`** - Save information about all current calls, that is, function calls\n  that have not yet returned a value.\n\n- **`no_tail`** - Save information about current calls, but discard previous\n  information when a tail-recursive call is made. This option consumes less\n  memory and can be necessary to use for processes with long lifetimes and many\n  tail-recursive calls. This is the default.\n\n- **`false`** - Save no information about current calls.","ref":"int.html#stack_trace/1"},{"type":"function","title":"int.test_at_break/3","doc":"Sets the conditional test of the breakpoint at `Line` in `Module` to `Function`.\n\nFunction `Function` must fulfill the requirements specified in section\n[Breakpoints](`m:int#int_breakpoints`).","ref":"int.html#test_at_break/3"},{"type":"extras","title":"Debugger Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Debugger Release Notes\n\nThis document describes the changes made to the Debugger application.","ref":"notes.html"},{"type":"extras","title":"Debugger 5.5 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Defining a fun in the shell using the syntax `fun Name/Arity` would fail. This has been corrected so that the following now works:\n  \n  ```\n  1> F = fun is_atom/1.\n  #Fun.erl.42.18682967>\n  > F(a).\n  true\n  3> Id = fun id/1.\n  #Fun.erl.42.18682967>\n  4> Id(42).\n  ** exception error: undefined shell command id/1\n  5> id(I) -> I.\n  ok\n  6> Id(42).\n  42\n  ```\n  \n  The Debugger has also been corrected to correctly handle this syntax for a BIF.\n\n  Own Id: OTP-19322 Aux Id: [GH-8963], [PR-8987]\n\n[GH-8963]: https://github.com/erlang/otp/issues/8963\n[PR-8987]: https://github.com/erlang/otp/pull/8987","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Erlang/OTP type specifications has been updated to eliminate overlapping domains.\n\n  Own Id: OTP-19310 Aux Id: [GH-8810], [GH-8821], [PR-8986]\n\n[GH-8810]: https://github.com/erlang/otp/issues/8810\n[GH-8821]: https://github.com/erlang/otp/issues/8821\n[PR-8986]: https://github.com/erlang/otp/pull/8986","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 5.4 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The dependencies for this application are now listed in the app file.\n\n  Own Id: OTP-18831 Aux Id: [PR-7441]\n\n[PR-7441]: https://github.com/erlang/otp/pull/7441","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Type specs have been added to all API functions.\n\n  Own Id: OTP-18819 Aux Id: [PR-7781]\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n- The Debugger now use a trace session for its internal use of tracing to avoid interfering with the user's use of tracing.\n\n  Own Id: OTP-19074 Aux Id: [PR-8389]\n\n[PR-7781]: https://github.com/erlang/otp/pull/7781\n[PR-8026]: https://github.com/erlang/otp/pull/8026\n[PR-8389]: https://github.com/erlang/otp/pull/8389","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 5.3.4 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-3-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"* Guards with nested record expression could wrongly evaluate to false.\n\n  Own Id: OTP-18958 Aux Id: GH-8120, PR-8275","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.3.3 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Map comprehensions now work in the Debugger.\n\n  Own Id: OTP-18888 Aux Id: GH-7914","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.3.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The call `int:no_break(Module)` did not remove any breakpoints.\n\n  Own Id: OTP-18644 Aux Id: GH-7336\n\n- The `maybe` expression is now supported in the Debugger.\n\n  Own Id: OTP-18740 Aux Id: GH-7410, PR-7599","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.3.1.3 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-3-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"* Guards with nested record expression could wrongly evaluate to false.\n\n  Own Id: OTP-18958 Aux Id: GH-8120, PR-8275","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.3.1.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-3-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The `maybe` expression is now supported in the Debugger.\n\n  Own Id: OTP-18740 Aux Id: GH-7410, PR-7599","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.3.1.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The call `int:no_break(Module)` did not remove any breakpoints.\n\n  Own Id: OTP-18644 Aux Id: GH-7336","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.3.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fixed a bug that would cause analysis to crash.\n\n  Own Id: OTP-18372 Aux Id: GH-6580","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.3 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-3"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- The configuration files [`.erlang`](`e:erts:erl_cmd.md`),\n  [`.erlang.cookie`](`e:system:distributed.md`) and\n  [`.erlang.crypt`](`m:beam_lib#module-erlang-crypt`) can now be located in the XDG\n  Config Home directory.\n\n  See the documentation for each file and `filename:basedir/2` for more details.\n\n  Own Id: OTP-17554 Aux Id: GH-5016 PR-5408 OTP-17821","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 5.2.1.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-2-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The call `int:no_break(Module)` did not remove any breakpoints.\n\n  Own Id: OTP-18644 Aux Id: GH-7336","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.2.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fix record index matching, it was broken and could never match.\n\n  Own Id: OTP-17865 Aux Id: GH-5571","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 5.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-2"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Improve record handling, print known records with record syntax.\n\n  Own Id: OTP-17574","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 5.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-1"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Extended error information for failing BIF calls as proposed in\n  [EEP 54](https://github.com/erlang/eep/blob/master/eeps/eep-0054.md) has been\n  implemented.\n\n  When a BIF call from the Erlang shell fails, more information about which\n  argument or arguments that were in error will be printed. The same extended\n  error information will by `proc_lib`, `common_test`, and `qlc` when BIF calls\n  fail.\n\n  For applications that wish to provide the same extended error information,\n  there are new functions `erl_error:format_exception/3` and\n  `erl_error:format_exception/4`.\n\n  There is a new [`error/3`](`error/3`) BIF that allows applications or\n  libraries to provide extended error information in the same way for their own\n  exceptions.\n\n  Own Id: OTP-16686","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 5.0 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-5-0"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- EEP-52 has been implemented.\n\n  In binary matching, the size of the segment to be matched is now allowed to be\n  a guard expression, and similarly in map matching the keys can now be guard\n  expressions. See the Erlang Reference Manual and Programming Examples for more\n  details.\n\n  Language compilers or code generators that generate Core Erlang code may need\n  to be updated to be compatible with the compiler in OTP 23. For more details,\n  see the section Backwards Compatibility in\n  [EEP 52](http://erlang.org/eeps/eep-0052.html).\n\n  Own Id: OTP-14708\n\n- The deprecated `erlang:get_stacktrace/0` BIF now returns an empty list instead\n  of a stacktrace. To retrieve the stacktrace, use the extended try/catch syntax\n  that was introduced in OTP 21. `erlang:get_stacktrace/0` is scheduled for\n  removal in OTP 24.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16484","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 4.2.8 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fix a bug where Unicode atoms are printed differently depending on if integer\n  lists are printed as strings or not.\n\n  Own Id: OTP-16186","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.2.7 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- All incorrect (that is, all) uses of \"can not\" has been corrected to \"cannot\"\n  in source code comments, documentation, examples, and so on.\n\n  Own Id: OTP-14282 Aux Id: PR-1891","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.2.6 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.2.5 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fix a bug where calling a fun inside a binary would crash the Debugger.\n\n  Own Id: OTP-14957 Aux Id: PR-1741","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.2.4 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Do not quote variables and button names in Debugger windows. The bug was\n  introduced in Erlang/OTP 20.1.\n\n  Own Id: OTP-14802","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.2.3 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2-3"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Tools are updated to show Unicode atoms correctly.\n\n  Own Id: OTP-14464","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 4.2.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The Erlang shell, `qlc:string_to_handle()`, and the Debugger (the Evaluator\n  area and Edit variable window of the Bindings area) can parse pids, ports,\n  references, and external funs, as long as they can be created in the running\n  system.\n\n  Own Id: OTP-14296\n\n- Fix editing of simple binary values in the Bindings area of the Debugger's\n  Attach Process Window.\n\n  Own Id: OTP-14318","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Miscellaneous updates due to atoms containing arbitrary Unicode characters.\n\n  Own Id: OTP-14285","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 4.2.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Update build scripts to not make assumptions about where env, cp and perl are\n  located.\n\n  Own Id: OTP-13800\n\n- A bug causing non-interpreted code to crash the debugger has been fixed.\n\n  Own Id: OTP-13756","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-2"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- When the debugger searches for source files, it will also use the location of\n  the source in the compilation information part of the BEAM file.\n\n  Own Id: OTP-13375","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 4.1.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-1-2"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Documentation corrections.\n\n  Own Id: OTP-12994","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 4.1.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fix crash when starting a quick debugging session. Thanks Alan Duffield.\n\n  Own Id: OTP-12911 Aux Id: seq12906","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-1"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Support variables as Map keys in expressions and patterns\n\n  Erlang will accept any expression as keys in Map expressions and it will\n  accept literals or bound variables as keys in Map patterns.\n\n  Own Id: OTP-12218","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 4.0.3 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fix save state which did not work on Mac.\n\n  Own Id: OTP-12378","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.0.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Make sure to install .hrl files when needed\n\n  Own Id: OTP-12197\n\n- Invoking debugger functions `ia/1` and `iaa/1` crashed, when it tried to\n  invoke the old and removed gs based gui functions.\n\n  Own Id: OTP-12357","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.0.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fix evaluation of map updates in the debugger and erl_eval\n\n  Reported-by: José Valim\n\n  Own Id: OTP-11922","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 4.0 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-4-0"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The debugger now correctly evaluates code such as '`X = true andalso X`'.\n  (Thanks to Anthony Ramine.)\n\n  Own Id: OTP-11553\n\n- A few subtle bugs in the evaluation of code in the debugger has been\n  corrected. (Thanks to Anthony Ramine.)\n\n  Own Id: OTP-11676\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Removed gs based applications and gs based backends. The `observer`\n  application replaces the removed applications.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-10915\n\n- Support Maps syntax in debugger (Thanks to Anthony Ramine).\n\n  Own Id: OTP-11673","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.12 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-12"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Fix matching of floating point middle-endian machines. Thanks to Johannes\n  Weissl.\n\n  Own Id: OTP-11201","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.11 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-11"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- A new checkbox has been added. When it is checked, the range set by the `erl`\n  flag `+pc` is used for determining when to print lists of integers as strings.\n  When it is unchecked, integer lists are never printed as strings.\n\n  A minor incompatibility: settings saved by Erlang R16B01 or later cannot be\n  read by Erlang R16B or earlier.\n\n  Own Id: OTP-10899\n\n- Erlang source files with non-ASCII characters are now encoded in UTF-8\n  (instead of latin1).\n\n  Own Id: OTP-11041 Aux Id: OTP-10907","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.10 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-10"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- The +pc flag to erl can be used to set the range of characters considered\n  printable. This affects how the shell and io:format(\"~tp\",...) functionality\n  does heuristic string detection. More can be read in STDLIB users guide.\n\n  Own Id: OTP-10884","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.9 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fix Debugger settings dialog due to changed behavior in wxFileDialog (Thanks\n  to Håkan Mattsson)\n\n  Own Id: OTP-10621","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Support for Unicode has been implemented.\n\n  Own Id: OTP-10302\n\n- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630\n\n- Integer lists and utf-8 binaries in variables are now displayed as strings.\n\n  Own Id: OTP-10679","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.8 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fixed disappearing breakpoints bug, reported by Ricardo Catalinas Jiménez.\n\n  Own Id: OTP-9950","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 3.2.7 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Fix \"OK\" spelling in debugger messages and variables\n\n  Simple code refactor in the debugger: renames all the occurrences of \"Ok\" to\n  \"OK\" in the code, variable names and strings. This improves the consistency of\n  the code and follows the GTK UI where \"OK\" is always used.(Thanks to Ricardo\n  Catalinas Jiménez)\n\n  Own Id: OTP-9699","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Variables are now now allowed in '`fun M:F/A`' as suggested by Richard O'Keefe\n  in EEP-23.\n\n  The representation of '`fun M:F/A`' in the abstract format has been changed in\n  an incompatible way. Tools that directly read or manipulate the abstract\n  format (such as parse transforms) may need to be updated. The compiler can\n  handle both the new and the old format (i.e. extracting the abstract format\n  from a pre-R15 BEAM file and compiling it using compile:forms/1,2 will work).\n  The `syntax_tools` application can also handle both formats.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9643","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.6 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-6"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Fix issues reported by dialyzer.\n\n  Own Id: OTP-9107","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.5 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-5"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Miscellaneous updates\n\n  Own Id: OTP-8976","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.4 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-4"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Type specs have been added/cleaned up. (Thanks to Kostis Sagonas.)\n\n  Own Id: OTP-8757","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.3 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-3"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Warnings due to new autoimported BIFs removed\n\n  Own Id: OTP-8674 Aux Id: OTP-8579\n\n- The predefined builtin type tid() has been removed. Instead, ets:tid() should\n  be used.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8687","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Bugs have been fixed in the evaluation of comprehensions and short-circuit\n  expressions in guards.\n\n  Own Id: OTP-8310","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Miscellaneous corrections of the WX version of the debugger.\n\n  Own Id: OTP-8346","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2-1"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-2"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Added a new gui, start with debugger:start(gs) for old gui.\n\n  Own Id: OTP-7366\n\n- The undocumented, unsupported, and deprecated guard BIF `is_constant/1` has\n  been removed.\n\n  \\*** INCOMPATIBILITY with R12B \\***\n\n  Own Id: OTP-7673","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.1.1.4 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-1-1-4"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- There is now experimental support for loading of code from archive files. See\n  the documentation of `code`, `init`, `erl_prim_loader `and `escript` for more\n  info.\n\n  The error handling of `escripts` has been improved.\n\n  An `escript` may now set explicit arguments to the emulator, such as\n  `-smp enabled`.\n\n  An `escript` may now contain a precompiled beam file.\n\n  An `escript` may now contain an archive file containing one or more\n  applications (experimental).\n\n  The internal module `code_aux` has been removed.\n\n  Own Id: OTP-7548 Aux Id: otp-6622","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.1.1.3 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-1-1-3"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Minor changes.\n\n  Own Id: OTP-7388","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.1.1.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-1-1-2"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- The documentation has been updated so as to reflect the last updates of the\n  Erlang shell as well as the minor modifications of the control sequence `p` of\n  the `io_lib` module.\n\n  Superfluous empty lines have been removed from code examples and from Erlang\n  shell examples.\n\n  Own Id: OTP-6944 Aux Id: OTP-6554, OTP-6911","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.1.1.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-1-1-1"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689\n\n- Obsolete guard tests (such as list()) have been replaced with the modern guard\n  tests (such as is_list()).\n\n  Own Id: OTP-6725","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.1.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Removed some dead code from `dbg_ieval`.\n\n  Own Id: OTP-6552","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 3.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The interpreter could not handle the case where an expression that should\n  evaluate to a fun referred to uninterpreted code.\n\n  Own Id: OTP-6061 Aux Id: seq10295\n\n- Timeout for `gen_server` calls within Debugger is now set to `infinity`.\n\n  Own Id: OTP-6103","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Notification windows are now centered over a parent window.\n\n  Own Id: OTP-6011 Aux Id: OTP-5987\n\n- When interpreting a module, it is now checked that the module does not belong\n  to the Kernel, STDLIB, GS or Debugger application, as interpreting a module\n  used by the debugger/interpreter itself will lead to a deadlock or emulator\n  crash.\n\n  Also `int:interpretable(Mod)` has been extended to return `{error,{app,App}}`\n  if `Mod` belongs to one of the above applications.\n\n  Own Id: OTP-6020\n\n- `andalso`/`orelse` is now supported.\n\n  Own Id: OTP-6021 Aux Id: OTP-5894","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.0.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- When evaluating a guard expression for a fun function clause, the environment\n  variable bindings were not taken into account.\n\n  Own Id: OTP-5837","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- A number of smaller improvements to the GUI:\n\n  - Multiple choices now possible in Function Break Dialog Window.\n  - Right-clicking the Module entry in a Break Dialog Window will open a popup\n    menu from which the appropriate (interpreted) module can be selected.\n  - Auto Attach options can now be changed using the buttons in the left part of\n    the Monitor Window, not only by the corresponding menu buttons.\n  - Buttons for enabling and disabling all breakpoints have been added.\n  - View Module Window keyboard shortcuts corrected.\n\n  Own Id: OTP-4284","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 3.0 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-3-0"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Debugger can now handle `try-catch`. This meant large parts of the interpreter\n  had to be rewritten. Also, some small changes to the GUI have been made.\n\n  Own Id: OTP-5730","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 2.3.3 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-2-3-3"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- It is now possible to encrypt the debug information in Beam files, to help\n  keep the source code secret. See the documentation for compile on how to\n  provide the key for encrypting, and the documentation for beam_lib on how to\n  provide the key for decryption so that tools such as the Debugger, Xref, or\n  Cover can be used.\n\n  The `beam_lib:chunks/2` functions now accepts an additional chunk type\n  '`compile_info`' to retrieve the compilation information directly as a term.\n  (Thanks to Tobias Lindahl.)\n\n  Own Id: OTP-5460 Aux Id: seq9787","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Debugger 2.3.2 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-2-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- The graphic applications now search for HTML documentation in the correct\n  place.\n\n  Own Id: OTP-5381","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Debugger 2.3.1 - Debugger Release Notes","doc":"","ref":"notes.html#debugger-2-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Debugger Release Notes","doc":"- Package support has been added to the debugger. Thanks to Richard Carlsson in\n  the HiPE project.\n\n  Own Id: OTP-5255","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Debugger Release Notes","doc":"- Updated to handle the latest version of the compiler.\n\n  Own Id: OTP-5265","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Introduction","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction","ref":"introduction.html"},{"type":"extras","title":"Scope - Introduction","doc":"Debugger is a graphical user interface for the Erlang interpreter, which can be\nused for debugging and testing of Erlang programs. For example, breakpoints can\nbe set, code can be single-stepped, and variable values can be displayed and\nchanged.\n\nDebugger can also be accessed through the interface module `m:int`.","ref":"introduction.html#scope"},{"type":"extras","title":"Prerequisites - Introduction","doc":"It is assumed that the reader is familiar with the Erlang programming language.\n\nModules to be debugged must include debug information, for example,\n`erlc +debug_info MODULE.erl`.","ref":"introduction.html#prerequisites"},{"type":"extras","title":"Debugger","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Debugger","ref":"debugger_chapter.html"},{"type":"extras","title":"Getting Started - Debugger","doc":"To use Debugger, the basic steps are as follows:\n\n_Step 1._ Start Debugger by calling `debugger:start()`.\n\nThe [Monitor window](debugger_chapter.md#monitor) is displayed with information\nabout all debugged processes, interpreted modules, and selected options.\nInitially there are normally no debugged processes. First, it must be specified\nwhich modules that are to be _debugged_ (also called _interpreted_). Proceed as\nfollows:\n\n_Step 2._ Select _Module > Interpret..._ in the Monitor window.\n\nThe [Interpret Modules window](debugger_chapter.md#interpret) is displayed.\n\n_Step 3._ Select the appropriate modules from the Interpret Dialog window.\n\n> #### Note {: .info }\n>\n> Only modules compiled with option `debug_info` set can be interpreted.\n> Non-interpretable modules are displayed within parenthesis in the Interpret\n> Modules window.\n\n_Step 4._ In the Monitor window, select _Module > the module to be interpreted >\nView_.\n\nThe contents of the source file is displayed in the\n[View Module window](debugger_chapter.md#view).\n\n_Step 5._ Set the [breakpoints](debugger_chapter.md#breakpoints), if any.\n\n_Step 6._ Start the program to be debugged. This is done the normal way from the\nErlang shell.\n\nAll processes executing code in interpreted modules are displayed in the Monitor\nwindow.\n\n_Step 7._ To _attach_ to one of these processes, double-click it, or select the\nprocess and then choose _Process > Attach_. Attaching to a process opens an\n[Attach Process window](debugger_chapter.md#attach) for this process.\n\n_Step 8._ From the Attach Process window, you can control the process execution,\ninspect variable values, set breakpoints, and so on.\n\n[](){: #breakpoints }","ref":"debugger_chapter.html#getting-started"},{"type":"extras","title":"Breakpoints and Break Dialog Windows - Debugger","doc":"Once the appropriate modules are interpreted, breakpoints can be set at relevant\nlocations in the source code. Breakpoints are specified on a line basis. When a\nprocess reaches a breakpoint, it stops and waits for commands (_Step_, _Skip_,\n_Continue_ ...) from the user.\n\n> #### Note {: .info }\n>\n> When a process reaches a breakpoint, only that process is stopped. Other\n> processes are not affected.\n\nBreakpoints are created and deleted using the _Break_ menu of either the Monitor\nwindow, View Module window, or Attach Process window.","ref":"debugger_chapter.html#breakpoints-and-break-dialog-windows"},{"type":"extras","title":"Executable Lines - Debugger","doc":"To have an effect, a breakpoint must be set at an _executable line_, which is a\nline of code containing an executable expression such as a matching or a\nfunction call. A blank line or a line containing a comment, function head, or\npattern in a `case` statement or `receive` statement is not executable.\n\nIn the following example, lines 2, 4, 6, 8, and 11 are executable lines:\n\n```erlang\n1: is_loaded(Module,Compiled) ->\n2:   case get_file(Module,Compiled) of\n3:     {ok,File} ->\n4:       case code:which(Module) of\n5:         ?TAG ->\n6:           {loaded,File};\n7:         _ ->\n8:           unloaded\n9:       end;\n10:    false ->\n11:      false\n12:  end.\n```","ref":"debugger_chapter.html#executable-lines"},{"type":"extras","title":"Status and Trigger Action - Debugger","doc":"A breakpoint can be either _active_ or _inactive_. Inactive breakpoints are\nignored.\n\nEach breakpoint has a _trigger action_ that specifies what is to happen when a\nprocess has reached it (and stopped):\n\n- _Enable_ \\- Breakpoint is to remain active (default).\n- _Disable_ \\- Breakpoint is to be made inactive.\n- _Delete_ \\- Breakpoint is to be deleted.","ref":"debugger_chapter.html#status-and-trigger-action"},{"type":"extras","title":"Line Breakpoints - Debugger","doc":"A line breakpoint is created at a certain line in a module.\n\n![Line Break Dialog Window](assets/line_break_dialog.jpg \"Line Break Dialog Window\")\n\nRight-click the _Module_ entry to open a popup menu from which the appropriate\nmodule can be selected.\n\nA line breakpoint can also be created (and deleted) by double-clicking the line\nwhen the module is displayed in the View Module window or Attach Process window.","ref":"debugger_chapter.html#line-breakpoints"},{"type":"extras","title":"Conditional Breakpoints - Debugger","doc":"A conditional breakpoint is created at a certain line in the module, but a\nprocess reaching the breakpoint stops only if a specified condition is true.\n\nThe condition is specified by the user as a module name `CModule` and a function\nname `CFunction`. When a process reaches the breakpoint,\n`CModule:CFunction(Bindings)` is evaluated. If and only if this function call\nreturns `true`, the process stops. If the function call returns `false`, the\nbreakpoint is silently ignored.\n\n`Bindings` is a list of variable bindings. To retrieve the value of `Variable`\n(given as an atom), use function\n[`int:get_binding(Variable, Bindings)`](`int:get_binding/2`). The function\nreturns `unbound` or `{value,Value}`.\n\n![Conditional Break Dialog Window](assets/cond_break_dialog.jpg \"Conditional Break Dialog Window\")\n\nRight-click the _Module_ entry to open a popup menu from which the appropriate\nmodule can be selected.\n\n_Example:_\n\nA conditional breakpoint calling `c_test:c_break/1` is added at line 6 in module\n`fact`. Each time the breakpoint is reached, the function is called. When `N` is\nequal to 3, the function returns `true` and the process stops.\n\nExtract from `fact.erl`:\n\n```erlang\n5. fac(0) -> 1;\n6. fac(N) when N > 0, is_integer(N) -> N * fac(N-1).\n```\n\nDefinition of `c_test:c_break/1`:\n\n```erlang\n-module(c_test).\n-export([c_break/1]).\n\nc_break(Bindings) ->\n    case int:get_binding('N', Bindings) of\n        {value, 3} ->\n            true;\n        _ ->\n            false\n    end.\n```","ref":"debugger_chapter.html#conditional-breakpoints"},{"type":"extras","title":"Function Breakpoints - Debugger","doc":"A function breakpoint is a set of line breakpoints, one at the first line of\neach clause in the specified function.\n\n![Function Break Dialog Window](assets/function_break_dialog.jpg \"Function Break Dialog Window\")\n\nTo open a popup menu from which the appropriate module can be selected,\nright-click the _Module_ entry.\n\nTo bring up all functions of the module in the listbox, click the _OK_ button\n(or press the _Return_ or _Tab_ key) when a module name has been specified,.\n\n[](){: #stack_trace }","ref":"debugger_chapter.html#function-breakpoints"},{"type":"extras","title":"Stack Trace - Debugger","doc":"The Erlang emulator keeps track of a _stack trace_, information about recent\nfunction calls. This information is used if an error occurs, for example:\n\n```erlang\n1> catch a+1.\n{'EXIT',{badarith,[{erlang,'+',[a,1],[]},\n                   {erl_eval,do_apply,6,[{file,\"erl_eval.erl\"},{line,573}]},\n                   {erl_eval,expr,5,[{file,\"erl_eval.erl\"},{line,357}]},\n                   {shell,exprs,7,[{file,\"shell.erl\"},{line,674}]},\n                   {shell,eval_exprs,7,[{file,\"shell.erl\"},{line,629}]},\n                   {shell,eval_loop,3,[{file,\"shell.erl\"},{line,614}]}]}}\n```\n\nFor details about the stack trace, see section\n[Errors and Error Handling](`e:system:errors.md`) in the Erlang Reference\nManual.\n\nDebugger emulates the stack trace by keeping track of recently called\ninterpreted functions. (The real stack trace cannot be used, as it shows which\nfunctions of Debugger have been called, rather than which interpreted\nfunctions.)\n\nThis information can be used to traverse the chain of function calls, using the\n_Up_ and _Down_ buttons in the\n[Attach Process window](debugger_chapter.md#attach).\n\nBy default, Debugger only saves information about recursive function calls, that\nis, function calls that have not yet returned a value (option _Stack On, No\nTail_).\n\nSometimes, however, it can be useful to save all calls, even tail-recursive\ncalls. This is done with option _Stack On, Tail_. Notice that this option\nconsumes more memory and slows down execution of interpreted functions when\nthere are many tail-recursive calls.\n\nTo turn off the Debugger stack trace facility, select option _Stack Off_.\n\n> #### Note {: .info }\n>\n> If an error occurs, the stack trace becomes empty in this case.\n\nFor information about how to change the stack trace option, see section\n[Monitor Window](debugger_chapter.md#monitor).\n\n[](){: #monitor }","ref":"debugger_chapter.html#stack-trace"},{"type":"extras","title":"Monitor Window - Debugger","doc":"The Monitor window is the main window of Debugger and displays the following:\n\n- A listbox containing the names of all interpreted modules\n\n  Double-clicking a module brings up the View Module window.\n\n- Which options are selected\n- Information about all debugged processes, that is, all processes that have\n  been or are executing code in interpreted modules\n\n![Monitor Window](assets/monitor.jpg \"Monitor Window\")\n\nThe _Auto Attach_ boxes, _Stack Trace_ label, _Back Trace Size_ label, and\n_Strings_ box display some options set. For details about these options, see\nsection [Options Menu](debugger_chapter.md#options).","ref":"debugger_chapter.html#monitor-window"},{"type":"extras","title":"Process Grid - Debugger","doc":"- **_Pid_** - The process identifier.\n\n- **_Initial Call_** - The first call to an interpreted function by this\n  process. (`Module:Function/Arity`)\n\n- **_Name_** - The registered name, if any. If a registered name is not\n  displayed, it can be that Debugger received information about the process\n  before the name was registered. Try selecting _Edit > Refresh_.\n\n- **_Status_** - The current status, one of the following:\n\n  - **_idle_** - The interpreted function call has returned a value, and the\n    process is no longer executing interpreted code.\n\n  - **_running_** - The process is running.\n\n  - **_waiting_** - The process is waiting in a `receive` statement.\n\n  - **_break_** - The process is stopped at a breakpoint.\n\n  - **_exit_** - The process has terminated.\n\n  - **_no_conn_** - There is no connection to the node where the process is\n    located.\n\n- **_Information_** - More information, if any. If the process is stopped at a\n  breakpoint, the field contains information about the location `{Module,Line}`.\n  If the process has terminated, the field contains the exit reason.","ref":"debugger_chapter.html#process-grid"},{"type":"extras","title":"File Menu - Debugger","doc":"- **_Load Settings..._** - Tries to load and restore Debugger settings from a\n  file previously saved using _Save Settings..._ (see below). Any errors are\n  silently ignored.\n\n  Notice that settings saved by Erlang/OTP R16B01 or later cannot be read by\n  Erlang/OTP R16B or earlier.\n\n- **_Save Settings..._** - Saves Debugger settings to a file. The settings\n  include the set of interpreted files, breakpoints, and the selected options.\n  The settings can be restored in a later Debugger session using _Load\n  Settings..._ (see above). Any errors are silently ignored.\n\n- **_Exit_** - Stops Debugger.","ref":"debugger_chapter.html#file-menu"},{"type":"extras","title":"Edit Menu - Debugger","doc":"- **_Refresh_** - Updates information about debugged processes. Information\n  about all terminated processes are removed from the window. All Attach Process\n  windows for terminated processes are closed.\n\n- **_Kill All_** - Terminates all processes listed in the window using\n  [`exit(Pid, kill)`](`exit/2`).","ref":"debugger_chapter.html#edit-menu"},{"type":"extras","title":"Module Menu - Debugger","doc":"- **_Interpret..._** - Opens the\n  [Interpret Modules window](debugger_chapter.md#interpret), where new modules\n  to be interpreted can be specified.\n\n- **_Delete All_** - Stops interpreting all modules. Processes executing in\n  interpreted modules terminate.\n\nFor each interpreted module, a corresponding entry is added to the _Module_\nmenu, with the following submenu:\n\n- **_Delete_** - Stops interpreting the selected module. Processes executing in\n  this module terminate.\n\n- **_View_** - Opens a [View Module window](debugger_chapter.md#view),\n  displaying the contents of the selected module.","ref":"debugger_chapter.html#module-menu"},{"type":"extras","title":"Process Menu - Debugger","doc":"The following menu items apply to the currently selected process, provided it is\nstopped at a breakpoint (for details, see section\n[Attach Process window](debugger_chapter.md#attach)):\n\n- **_Step_**\n\n- **_Next_**\n\n- **_Continue_**\n\n- **_Finish_**\n\nThe following menu items apply to the currently selected process:\n\n- **_Attach_** - Attaches to the process and open an\n  [Attach Process window](debugger_chapter.md#attach).\n\n- **_Kill_** - Terminates the process using [`exit(Pid, kill)`](`exit/2`).","ref":"debugger_chapter.html#process-menu"},{"type":"extras","title":"Break Menu - Debugger","doc":"The items in this menu are used to create and delete breakpoints. For details,\nsee section [Breakpoints](debugger_chapter.md#breakpoints).\n\n- **_Line Break..._** - Sets a line breakpoint.\n\n- **_Conditional Break..._** - Sets a conditional breakpoint.\n\n- **_Function Break..._** - Sets a function breakpoint.\n\n- **_Enable All_** - Enables all breakpoints.\n\n- **_Disable All_** - Disables all breakpoints.\n\n- **_Delete All_** - Removes all breakpoints.\n\nFor each breakpoint, a corresponding entry is added to the _Break_ menu, from\nwhich it is possible to disable, enable, or delete the breakpoint, and to change\nits trigger action.\n\n[](){: #options }","ref":"debugger_chapter.html#break-menu"},{"type":"extras","title":"Options Menu - Debugger","doc":"- **_Trace Window_** - Sets the areas to be visible in an\n  [Attach Process window](debugger_chapter.md#attach). Does not affect existing\n  Attach Process windows.\n\n- **_Auto Attach_** - Sets the events a debugged process is to be attached to\n  automatically. Affects existing debugged processes.\n\n  - _First Call_ \\- The first time a process calls a function in an interpreted\n    module.\n  - _On Exit_ \\- At process termination.\n  - _On Break_ \\- When a process reaches a breakpoint.\n\n- **_Stack Trace_** - Sets the stack trace option, see section\n  [Stack Trace](debugger_chapter.md#stack_trace). Does not affect existing\n  debugged processes.\n\n  - _Stack On, Tail_ \\- Saves information about all current calls.\n  - _Stack On, No Tail_ \\- Saves information about current calls, discarding\n    previous information when a tail recursive call is made.\n  - _Stack Off_ \\- Does not save any information about current calls.\n\n- **_Strings_** - Sets the integer lists to be printed as strings. Does not\n  affect existing debugged processes.\n\n  - _Use range of +pc flag_ \\- Uses the printable character range set by the\n    [`erl(1)`](`e:erts:erl_cmd.md`) flag\n    [`+pc`](`e:erts:erl_cmd.md#printable_character_range`).\n\n- **_Back Trace Size..._** - Sets how many call frames to be fetched when\n  inspecting the call stack from the Attach Process window. Does not affect\n  existing Attach Process windows.","ref":"debugger_chapter.html#options-menu"},{"type":"extras","title":"Windows Menu - Debugger","doc":"Contains a menu item for each open Debugger window. Selecting one of the items\nraises the corresponding window.","ref":"debugger_chapter.html#windows-menu"},{"type":"extras","title":"Help Menu - Debugger","doc":"- **_Help_** - Shows the Debugger documentation. This function requires a web\n  browser.\n\n[](){: #interpret }","ref":"debugger_chapter.html#help-menu"},{"type":"extras","title":"Interpret Modules Window - Debugger","doc":"The Interpret Modules window is used for selecting which modules to interpret.\nInitially, the window displays the modules (`erl` files) and subdirectories of\nthe current working directory.\n\nInterpretable modules are modules for which a `.beam` file, compiled with option\n`debug_info` set, is located in the same directory as the source code, or in an\n`ebin` directory next to it.\n\nModules for which these requirements are not fulfilled are not interpretable and\nare therefore displayed within parentheses.\n\nOption `debug_info` causes _debug information_ or _abstract code_ to be added to\nthe `.beam` file. This increases the file size and makes it possible to\nreconstruct the source code. It is therefore recommended not to include debug\ninformation in code aimed for target systems.\n\nAn example of how to compile code with debug information using `erlc`:\n\n```erlang\n% erlc +debug_info module.erl\n```\n\nAn example of how to compile code with debug information from the Erlang shell:\n\n```text\n4> c(module, debug_info).\n```\n\n![Interpret Modules Window](assets/interpret.jpg \"Interpret Modules Window\")\n\nTo browse the file hierarchy and interpret the appropriate modules, either\nselect a module name and click _Choose_ (or press carriage return), or\ndouble-click the module name. Interpreted modules have the type `erl src`.\n\nTo interpret all displayed modules in the chosen directory, click _All_.\n\nTo close the window, click _Done_.\n\n> #### Note {: .info }\n>\n> When Debugger is started in global mode (which is the default, see\n> `debugger:start/0`), modules added (or deleted) for interpretation are added\n> (or deleted) on all known Erlang nodes.\n\n[](){: #attach }","ref":"debugger_chapter.html#interpret-modules-window"},{"type":"extras","title":"Attach Process Window - Debugger","doc":"From an Attach Process window, you can interact with a debugged process. One\nwindow is opened for each process that has been attached to. Notice that when\nattaching to a process, its execution is automatically stopped.\n\n![Attach Process Window](assets/attach.jpg \"Attach Process Window\")\n\nThe window is divided into the following five parts:\n\n- The Code area, displaying the code being executed. The code is indented and\n  each line is prefixed with its line number. If the process execution is\n  stopped, the current line is marked with `-->`. An existing break point at a\n  line is marked with a stop symbol. In the example shown in the illustration,\n  the execution stopped at line 6, before the execution of `fac/1`.\n\n  Active breakpoints are displayed in red and inactive breakpoints in blue.\n\n- The Button area, with buttons for quick access to frequently used functions in\n  the _Process_ menu.\n- The Evaluator area, where you can evaluate functions within the context of the\n  debugged process, if that process execution is stopped.\n- The Bindings area, displaying all variables bindings. If you click a variable\n  name, the value is displayed in the Evaluator area. Double-click a variable\n  name to open a window where the variable value can be edited. Notice however\n  that pid, port, reference, or fun values cannot be edited unless they can be\n  represented in the running system.\n- The Trace area, which displays a trace output for the process.\n\n  - **`++ (N)  `** - Function call, where `N` is the call level and `L` the\n    line number.\n\n  - **`-- (N)`** - Function return value\n\n    .\n\n  - **`==> Pid : Msg`** - The message `Msg` is sent to process `Pid`.\n\n  - **`<== Msg`** - The message `Msg` is received.\n\n  - **`++ (N) receive`** - Waiting in a `receive`.\n\n  - **`++ (N) receive with timeout`** - Waiting in a `receive...after`.\n\n  The Trace area also displays Back Trace, a summary of the current function\n  calls on the stack.\n\nUsing the _Options_ menu, you can set which areas to be displayed. By default,\nall areas except the Trace area are displayed.","ref":"debugger_chapter.html#attach-process-window"},{"type":"extras","title":"File Menu - Debugger","doc":"- **_Close_** - Closes this window and detach from the process.","ref":"debugger_chapter.html#file-menu"},{"type":"extras","title":"Edit Menu - Debugger","doc":"- **_Go to line..._** - Goes to a specified line number.\n\n- **_Search..._** - Searches for a specified string.","ref":"debugger_chapter.html#edit-menu"},{"type":"extras","title":"Process Menu - Debugger","doc":"- **_Step_** - Executes the current code line, stepping into any (interpreted)\n  function calls.\n\n- **_Next_** - Executes the current code line and stop at the next line.\n\n- **_Continue_** - Continues the execution.\n\n- **_Finish_** - Continues the execution until the current function returns.\n\n- **_Skip_** - Skips the current code line and stop at the next line. If used on\n  the last line in a function body, the function returns `skipped`.\n\n- **_Time Out_** - Simulates a time-out when executing a `receive...after`\n  statement.\n\n- **_Stop_** - Stops the execution of a running process, that is, make the\n  process stop at a breakpoint. The command takes effect (visibly) the next time\n  the process receives a message.\n\n- **_Where_** - Verifies that the current location of the execution is visible\n  in the code area.\n\n- **_Kill_** - Terminates the process using [`exit(Pid, kill)`](`exit/2`).\n\n- **_Messages_** - Inspects the message queue of the process. The queue is\n  displayed in the Evaluator area.\n\n- **_Back Trace_** - Displays the back trace of the process, a summary of the\n  current function calls on the stack, in the Trace area. Requires that the\n  Trace area is visible and that the Stack Trace option is _Stack On, Tail_ or\n  _Stack On, No Tail_.\n\n- **_Up_** - Inspects the previous function call on the stack, showing the\n  location and variable bindings.\n\n- **_Down_** - Inspects the next function call on the stack, showing the\n  location and variable bindings.","ref":"debugger_chapter.html#process-menu"},{"type":"extras","title":"Options Menu - Debugger","doc":"- **_Trace Window_** - Sets which areas are to be visible. Does not affect other\n  Attach Process windows.\n\n- **_Stack Trace_** - Same as in the\n  [Monitor window](debugger_chapter.md#monitor), but only affects the debugged\n  process the window is attached to.\n\n- **_Strings_** - Same as in the [Monitor window](debugger_chapter.md#monitor),\n  but only affects the debugged process the window is attached to.\n\n- **_Back Trace Size..._** - Sets how many call frames are to be fetched when\n  inspecting the call stack. Does not affect other Attach Process windows.","ref":"debugger_chapter.html#options-menu"},{"type":"extras","title":"Break, Windows, and Help Menus - Debugger","doc":"The _Break_, _Windows_, and _Help_ menus are the same as in the\n[Monitor Window](debugger_chapter.md#monitor), except that the _Breaks_ menu\napplies only to local breakpoints.\n\n[](){: #view }","ref":"debugger_chapter.html#break-windows-and-help-menus"},{"type":"extras","title":"View Module Window - Debugger","doc":"The View Module window displays the contents of an interpreted module and makes\nit possible to set breakpoints.\n\n![View Module Window](assets/view.jpg \"View Module Window\")\n\nThe source code is indented and each line is prefixed with its line number.\n\nClicking a line highlights it and selects it to be the target of the breakpoint\nfunctions available from the _Break_ menu. To set a line breakpoint on a line,\ndouble-click it. To remove the breakpoint, double-click the line with an\nexisting breakpoint.\n\nBreakpoints are marked with a stop symbol.","ref":"debugger_chapter.html#view-module-window"},{"type":"extras","title":"File and Edit Menus - Debugger","doc":"The _File_ and _Edit_ menus are the same as in the\n[Attach Process Window](debugger_chapter.md#attach).","ref":"debugger_chapter.html#file-and-edit-menus"},{"type":"extras","title":"Break, Windows, and Help Menus - Debugger","doc":"The _Break_, _Windows_, and _Help_ menus are the same as in the\n[Monitor Window](debugger_chapter.md#monitor), except that the _Break_ menu\napplies only to local breakpoints.","ref":"debugger_chapter.html#break-windows-and-help-menus"},{"type":"extras","title":"Performance - Debugger","doc":"Execution of interpreted code is naturally slower than for regularly compiled\nmodules. Using Debugger also increases the number of processes in the system, as\nfor each debugged process another process (the meta process) is created.\n\nIt is also worth to keep in mind that programs with timers can behave\ndifferently when debugged. This is especially true when stopping the execution\nof a process (for example, at a breakpoint). Time-outs can then occur in other\nprocesses that continue execution as normal.","ref":"debugger_chapter.html#performance"},{"type":"extras","title":"Code Loading Mechanism - Debugger","doc":"Code loading works almost as usual, except that interpreted modules are also\nstored in a database and debugged processes use only this stored code.\nReinterpreting an interpreted module results in the new version being stored as\nwell, but does not affect existing processes executing an older version of the\ncode. This means that the code replacement mechanism of Erlang does not work for\ndebugged processes.","ref":"debugger_chapter.html#code-loading-mechanism"},{"type":"extras","title":"Debugging Remote Nodes - Debugger","doc":"By using `debugger:start/1`, you can specify if Debugger is to be started in\nlocal or global mode:\n\n```text\ndebugger:start(local | global)\n```\n\nIf `debugger:start/0` is called, Debugger starts in global mode.\n\nIn local mode, code is interpreted only on the current node. In global mode,\ncode is interpreted on all known nodes. Processes on other nodes executing\ninterpreted code are automatically displayed in the Monitor window and can be\nattached to like any other debugged process.\n\n> #### Note {: .info }\n>\n> It not recommended to start Debugger in global mode on more than one\n> node in a network, as the nodes interfere with each other, leading to\n> inconsistent behavior.","ref":"debugger_chapter.html#debugging-remote-nodes"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.37.3"}}