---
sidebar_position: 27
---

# W0027 - Record Tuple Match

## Error

```erlang
-record(my_rec, {field1, field2}).
main(X) ->
    {my_rec, Field1, _} = X.
%%  ^^^^^^ warning: matching record 'my_rec' as a tuple.
```

## Explanation

The warning message indicates that a record is being matched as a bare tuple.

While this may be correct when the code is written, if the record is changed in future the match may fail.

To fix the problem you should convert the match to record syntax.

In case of false positives, the [standard `elp:ignore` mechanism](../erlang-error-index.md#ignoring-diagnostics) should be used. Please report this as a bug should this be the case.
