---
sidebar_position: 25
---

# W0025 - Boolean Precedence

## Warning

```erlang
foo(X) ->
  predicate(X) or X > 10.
%%             ^^ 💡 warning: Consider using the short-circuit expression 'orelse' instead of 'or'.
%%              | Or add parentheses to avoid potential ambiguity.
```

## Explanation

The `and`/`or` operands have higher precedence than comparison ops
(unlike `andalso`/`orelse`) so this could be a source of bugs.

```erlang
17> F = fun(X) -> is_integer(X) and X > 0 end.
#Fun<erl_eval.42.105768164>
18> F(-1).
** exception error: bad argument
     in operator  and/2
        called as true and -1
```

Note that changing this may affect the semantics, as `and`/`or` always
evaluate both arguments, so guarantee any side-effects in those
computations take place.  In contrast, `andalso`/`orelse` do
[short circuit evaluation](https://www.erlang.org/doc/system/expressions.html#short-circuit-expressions)
so may not execute the RHS of the expression.

If it is necessary to use `and`/`or`, you can preceed
the expression with a special comment to silence the linter:

```
% elp:ignore W0025 - An optional explanation here
```
