---
sidebar_position: 24
---

# W0024 - Slow Function

## Error

```erlang
-module(main).
foo() -> sets:new().
%%       ^^^^^^^^^^ 💡 warning: Prefer the map-based sets implementation.
%%                |The old implementation of sets was very slow. Use `[{version, 2}]` when constructing a set.
%%                |
%%                |See https://www.erlang.org/doc/man/sets.html
%%                |
```

## Explanation

Some functions are known to be slow.  Provide a warning if any of them are used.  In particular, it warns about.

* `sets:new/0`
* `sets:from_list/0`
* `dict:*`. i.e. any usage from the `dict` module.


If it is unavoidable to use one of these functions, you can preceed the function call with a special comment to silent the linter:

```
% elp:ignore W0024 - An optional explanation here
```
