---
sidebar_position: 22
---

# W0022 - Missing `no_link` option in `meck:new` invocation

## Error

```erlang
   -module(my_SUITE).

   -export([all/0, init_per_suite/1]).
   -export([a/1]).

   all() -> [a].

   init_per_suite(Config) ->
     meck:new(my_module, [passthrough]),
  %% ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ 💡 warning: Missing no_link option.
     Config.

   a(_Config) ->
     ok.
```

## Explanation

In [Common Test](https://www.erlang.org/doc/apps/common_test/introduction), every test case is executed by a dedicated Erlang process. The `init_per_suite/1` and `init_per_group/2` configuration functions are executed in separate processes. Every _linked_ process spawned in those functions will be killed once the function stops executing.

Unless the `no_link` option is passed to the `meck:new/1,2` invocations, the spawned process is linked, so the mock would stop working before (or while) a testcase is executing, often leading to flakyness.

To fix this issue, pass the `no_link` option to the `meck:new/1,2` invocation or activate the mock outside of the `init_per_suite/1` and `init_per_group/2` functions.

For more information, please refer to the [official documentation](https://www.erlang.org/doc/apps/common_test/write_test_chapter#execution-environment).
