---
sidebar_position: 17
---

# W0017 - Undefined Function

## Error

```erlang
  main() ->
    dep:exists(),
    dep:not_exists().
%%  ^^^^^^^^^^^^^^^^ 💡 warning: Function 'dep:not_exists/0' is undefined.
```

## Explanation

The warning message indicates that the invoked function cannot be found.

The problem could be due to misspelling, to the wrong number of arguments passed to the function, to a recent removal of the target function, to a dependency change or to a misconfiguration of the language server.

To fix the problem you should verify whether the invoked function actually exists and has the correct _arity_. Remember that in Erlang a function is identified by its name **and** the number of arguments it takes.

In case of false positives, the [standard `elp:ignore` mechanism](../erlang-error-index.md#ignoring-diagnostics) should be used. Please report this as a bug should this be the case.

This diagnostic is limited to fully qualified function calls (i.e. function calls which specify the module name), since local calls to undefined functions are already reported by the Erlang linter (see [L1227](../l/L1227.md)).
