---
sidebar_position: 16
---

# W0016 - Deprecated Function

## Error

```erlang
  main() ->
    b:not_ok_to_use().
%%  ^^^^^^^^^^^^^^^^^ 💡 warning: Function 'not_ok_to_use/0' is deprecated.
```

## Explanation

The warning message indicates that the invoked function is *deprecated*, which means it is no longer recommended for use.

To fix the problem you should investigate why the function is deprecated and whether there is an alternative function that can be used instead. You may need to refer to documentation to determine the best course of action.

A function is usually deprecated via [the `-deprecated` attribute](https://www.erlang.org/doc/man/xref#deprecated_function). This analysis is very similar to the
`deprecated_function_calls` analysis performed by the [XRef](https://www.erlang.org/doc/man/xref.html) cross-reference tool.

There is currently no support for the `-ignore_xref` attribute used by `rebar3` to silent specific instances of this diagnostic. Instead, the [standard `elp:ignore` mechanism](../erlang-error-index.md#ignoring-diagnostics) should be used.
