---
sidebar_position: 15
---

# W0015 - Dependent Header

## Error

```erlang title="/my_app/include/my_header.hrl"
-define(MY_MACRO, #my_record.my_field).
%%                ^^^^^^^^^^ warning: Record 'my_record' not defined in this context
```

## Explanation

The message is indicating that the given header file is not "independent", meaning that it contains a reference to an entity (the `my_record` record in this case) which is neither defined in the same file or included.
Since header files are processed lazily, the Erlang compiler cannot detect this situation but ELP can.

To fix the error, include the header file where the `my_record` record is defined.
