---
sidebar_position: 10
---

# W0010 - Unused Function Argument

## Error

```erlang
length([]) -> 0;
length([Head|Tail]) -> 1 + length(Tail).
     %% ^^^^ warning: this variable is unused
```

## Explanation

The message is indicating that the given variable is unused within the function clause body. To fix the warning you should either:

* remove the unused parameter
* replace it with an underscore (`_`)
* prepend it with an underscore (`_`)

In the above snippet, we don't need to look at the actual value of the `Head` to calculate the length of the input list. Therefore, we can replace the variable name with an underscore:

```erlang
length([]) -> 0;
length([_|Tail]) -> 1 + length(Tail).
```

Even better, we could keep the variable name and prepend it with an underscore. This way we'll get the best of both worlds: we will silent the warning, while keeping the code readable:

```erlang
length([]) -> 0;
length([_Head|Tail]) -> 1 + length(Tail).
```

Let's look at a different scenario:

```erlang
handle_message(hi, State) ->
                %% ^^^^^ warning: this variable is unused
    hi();
handle_message(bye, State) ->
                 %% ^^^^^ warning: this variable is unused
    bye().
```

In this case the `State` variable is not needed by any of the function clauses of the `handle_message/2` function. Therefore, we could consider simplifying the function signature getting rid of the un-necessary second argument:

```erlang
handle_message(hi) ->
    hi();
handle_message(bye) ->
    bye().
```

Keep in mind that in this case we may need to update callers of the `handle_message/1` function!
