---
sidebar_position: 6
---

# W0006 - Statement Has No Effect

## Error

```erlang
-module(main).
    test_foo(_Config) ->
        do_something(),
        ok,
    %%% ^^ warning: this statement has no effect
        do_something_else(),
        bar,
    %%% ^^^ warning: this statement has no effect
        ok.

    do_something() -> ok.

    do_something_else() -> ok.
```

## Explanation

The error message is indicating that the statements `ok` and `bar` (atoms in this case) have no effect in the code.

The atoms in the above snippet are used as a standalone statement and they have no effect on the program.

To fix these warnings, you should either remove the unused statements or change the code so that they are used.
