---
sidebar_position: 2
---

# W0002 - Unused Macro

## Error

```erlang
-module(main).
-define(MEANING_OF_LIFE, 42).
    %%  ^^^^^^^^^^^^^^^ warning: Unused macro (MEANING_OF_LIFE)
```

## Explanation

The error message is indicating that the macro `MEANING_OF_LIFE` is defined but not used anywhere in the code.

To fix this warning, you should either use the macro somewhere in the code or remove the definition of the macro if it is no longer needed.
