---
sidebar_position: 7
---

# O0007 - `` ``` `` Quote ended unexpectedly

## Error

```erlang
    %% @doc To execute the program, call `main`
    %% Here is some code:
    %% ```
    %% erlang:display()
%%  ^^^^^^^^^^^^^^^^^^^ warning: ```-quote ended unexpectedly
    %% ```
    main() ->
      ok.
```

## Explanation

The character sequence ` ```...'''` is used in EDoc for multi-line code examples.

You are most likely using _markdown-style_ monospace quoting instead of _EDoc's_ monospace quotes. To fix the error, replace the last occurrence of `` ``` `` with `` ''' ``:

```erlang
    %% @doc To execute the program, call `main`
    %% Here is some code:
    %% ```
    %% erlang:display()
    %% '''
    main() ->
      ok.
```

You can read more about verbatim quoting in EDoc [here](https://www.erlang.org/doc/apps/edoc/chapter.html#verbatim-quoting).
