---
sidebar_position: 20
---

# W0020 - Unused Include

## Error

```erlang
//- /include/foo.hrl
  -define(FOO,3).

//- /src/foo.erl
  -module(foo).
  -include("foo.hrl").
%%^^^^^^^^^^^^^^^^^^^^ 💡 warning: Unused file: foo.hrl
```

## Explanation

The warning message indicates that no definitions or attributes contained in the `foo.hrl` header are used in the `foo` module and therefore the `include` statement can be safely removed from `foo.erl`.

In case of a false positive, please use the [standard `elp:ignore` mechanism](../erlang-error-index.md#ignoring-diagnostics) to temporarily silence the warning and report this as a bug.
