---
sidebar_position: 14
---

# W0014 - Cross Node Evaluation Not Allowed

## Error

```erlang
  do(Node) ->
    erlang:spawn_link(Node, fun() -> ok end).
%%  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ error: Production code must not use cross node eval (e.g. `rpc:call()`)
```

## Explanation

The error is indicating that remote execution is happening between two nodes, in an environment where this is not allowed.

To fix the error either remove the invocation or ignore the problem via [the standard `elp:ignore` mechanism](../erlang-error-index.md#ignoring-diagnostics).
