---
sidebar_position: 9
---

# W0009 - Redundant Assignment

## Error

```erlang
do() ->
    X = 42,
    Y = X,
 %% ^^^^^ assignment is redundant
    foo(Y).
```

## Explanation

The error message is indicating that the assignment `Y = X` is un-necessary. The variable `Y` is unbound during the assignment and the value resulting from the assignment is then passed to the function `foo/1`.

A more concise way to express the above would be:

```erlang
do() ->
    X = 42,
    foo(X).
```
