---
sidebar_position: 7
---

# W0007 - Trivial Match

## Error

```erlang
-module(main).

do_foo() ->
    X = 42,
    Y = 42,
    X = X,
%%% ^^^^^ warning: match is redundant
    X = Y.
```

## Explanation

The error message is indicating that the statement `X = X` is redundant.

Since the _pattern_ (the part on the left of the `=` and the _expression_ (the part on the right of the `=`) are the same and given that in Erlang variables are immutable (once a value is assigned to a variable it cannot be changed), the operation will always succeed.

To fix this warning, you should remove the redundant assignment.
