---
sidebar_position: 5
---

# O0005 - ` Quote ended unexpectedly

## Error

```erlang
    %% @doc To execute the program, call `main`
%%  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ warning: `-quote ended unexpectedly
    main() ->
      ok.
```

## Explanation

In EDoc, the `` ` `` character (known as _back-quote_) can be used for verbatim quoting.

A character sequence such as `` `...' `` is expanded to `<code>...</code>`, where all occurrences of the special XML characters `<` and `&` (and for completeness, also `>`) in the quoted text have been escaped to `&lt;`, `&amp;`, and `&gt;`, respectively. All whitespace is stripped from the beginning and end of the quoted text.

Notice how thes syntax differs from the more traditional Markdown-style one (`` `...` ``).

The most likely cause for the above error is that you are using Markdown-style back-quoting. To fix it, just replace the last `` ` `` into ` ' `:

```erlang
    %% @doc To execute the program, call `main'
    main() ->
      ok.
```

You can read more about verbatim quoting in EDoc [here](https://www.erlang.org/doc/apps/edoc/chapter.html#verbatim-quoting).
