# Qt dynamic link libraries for ElmerGUI
IF(CPACK_BUNDLE_EXTRA_WINDOWS_DLLS)
  IF(WITH_QT5) 
    FIND_FILE(QTCORE_DLL Qt5Core.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTGUI_DLL Qt5Gui.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTOPENGL_DLL Qt5OpenGL.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTSCRIPT_DLL Qt5Script.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTXML_DLL Qt5Xml.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTSVG_DLL Qt5Svg.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTWID_DLL Qt5Widgets.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTPRI_DLL Qt5PrintSupport.dll PATH_SUFFIXES "bin")
    INSTALL(FILES ${QTCORE_DLL} ${QTGUI_DLL} ${QTOPENGL_DLL} ${QTSCRIPT_DLL} ${QTXML_DLL} ${QTSVG_DLL} ${QTWID_DLL} ${QTPRI_DLL} DESTINATION "bin" COMPONENT "elmergui")
  ELSE()
    FIND_FILE(QTCORE_DLL QtCore4.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTGUI_DLL QtGui4.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTOPENGL_DLL QtOpenGL4.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTSCRIPT_DLL QtScript4.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTXML_DLL QtXml4.dll PATH_SUFFIXES "bin")
    FIND_FILE(QTSVG_DLL QtSvg4.dll PATH_SUFFIXES "bin")
    INSTALL(FILES ${QTCORE_DLL} ${QTGUI_DLL} ${QTOPENGL_DLL} ${QTSCRIPT_DLL} ${QTXML_DLL} ${QTSVG_DLL} DESTINATION "bin" COMPONENT "elmergui")
  ENDIF(WITH_QT5)


  IF(WITH_OCC)
    FIND_PACKAGE(OCE REQUIRED)
    FOREACH(OCC_LIB ${ELMER_OCC_LIBS})
      MESSAGE(STATUS "Installing ${OCC_LIB}")
      FIND_LIBRARY(${OCC_LIB}_LIB ${OCC_LIB} ${OCE_INCLUDE_DIRS}/../../Win64/bin)
      INSTALL(FILES ${${OCC_LIB}_LIB} DESTINATION "bin" COMPONENT "elmergui")
    ENDFOREACH(OCC_LIB)
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/FTL.TXT DESTINATION "share/ElmerGUI/license_texts")
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/OCE.txt DESTINATION "share/ElmerGUI/license_texts")
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/OCCT_LGPL_EXCEPTION.txt DESTINATION "share/ElmerGUI/license_texts")
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/LICENSE_LGPL_21.txt DESTINATION "share/ElmerGUI/license_texts")
  ENDIF(WITH_OCC)

  IF(WITH_QWT)
    FIND_PACKAGE(Qwt REQUIRED)
    FILE(GLOB QWT_INSTALL_LIB "${QWT_LIBRARY}")
    INSTALL(FILES "${QWT_LIBRARY}" DESTINATION "bin" COMPONENT "elmergui")
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/Qwt.txt DESTINATION "share/ElmerGUI/license_texts")
  ENDIF(WITH_QWT)

  IF(WITH_VTK)
    FIND_PACKAGE(VTK REQUIRED)
    SET(VTK_BIN_DIR "${VTK_DIR}/../../../bin")
    FOREACH(VTK_LIB ${VTK_LIBRARIES})
      FILE(GLOB ${VTK_LIB}_FILEPATH "${VTK_BIN_DIR}/lib${VTK_LIB}*.dll")
      INSTALL(FILES ${${VTK_LIB}_FILEPATH} DESTINATION "bin" COMPONENT "elmergui")
    ENDFOREACH()
    INSTALL(FILES ${CMAKE_CURRENT_SOURCE_DIR}/license_texts/vtk-copyright.txt DESTINATION "share/ElmerGUI/license_texts")
  ENDIF(WITH_VTK)

ENDIF(CPACK_BUNDLE_EXTRA_WINDOWS_DLLS)
