/*****************************************************************************
 *                                                                           *
 *  Elmer, A Finite Element Software for Multiphysical Problems              *
 *                                                                           *
 *  Copyright 1st April 1995 - , CSC - IT Center for Science Ltd., Finland    *
 *                                                                           *
 *  This program is free software; you can redistribute it and/or            *
 *  modify it under the terms of the GNU General Public License              *
 *  as published by the Free Software Foundation; either version 2           *
 *  of the License, or (at your option) any later version.                   *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 *  GNU General Public License for more details.                             *
 *                                                                           *
 *  You should have received a copy of the GNU General Public License        *
 *  along with this program (in file fem/GPL-2); if not, write to the        *
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,         *
 *  Boston, MA 02110-1301, USA.                                              *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                                                                           *
 *  ElmerGUI featureedge                                                     *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 *  Authors: Mikko Lyly, Juha Ruokolainen and Peter Råback                   *
 *  Email:   Juha.Ruokolainen@csc.fi                                         *
 *  Web:     http://www.csc.fi/elmer                                         *
 *  Address: CSC - IT Center for Science Ltd.                                 *
 *           Keilaranta 14                                                   *
 *           02101 Espoo, Finland                                            *
 *                                                                           *
 *  Original Date: 15 Mar 2008                                               *
 *                                                                           *
 *****************************************************************************/

#ifndef FEATUREEDGE_H
#define FEATUREEDGE_H

#include <QWidget>
#include <vtkUnstructuredGrid.h>
#include <vtkRenderer.h>
#include <vtkActor.h>
#include "ui_featureedge.h"

class VtkPost;
class Preferences;

class FeatureEdge : public QDialog
{
  Q_OBJECT

public:
  FeatureEdge(QWidget *parent = 0);
  ~FeatureEdge();

  Ui::featureEdgeDialog ui;

  //void draw(VtkPost*, Preferences*);
  void removeActorFrom(vtkRenderer*);
  void addActorTo(vtkRenderer*);
  void draw(VtkPost*, Preferences*, vtkUnstructuredGrid*);

signals:

private slots:

private:
  vtkActor* actor;
};

#endif // FEATUREEDGE_H
