/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.FileBasedSeedHostsProvider;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.discovery.SettingsBasedSeedHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class DiscoveryModule {
    private static final Logger logger = LogManager.getLogger(DiscoveryModule.class);
    public static final String ZEN_DISCOVERY_TYPE = "legacy-zen";
    public static final String ZEN2_DISCOVERY_TYPE = "zen";
    public static final String SINGLE_NODE_DISCOVERY_TYPE = "single-node";
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "zen", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> LEGACY_DISCOVERY_HOSTS_PROVIDER_SETTING = Setting.listSetting("discovery.zen.hosts_provider", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<List<String>> DISCOVERY_SEED_PROVIDERS_SETTING = Setting.listSetting("discovery.seed_providers", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final String DEFAULT_ELECTION_STRATEGY = "default";
    public static final Setting<String> ELECTION_STRATEGY_SETTING = new Setting("cluster.election.strategy", "default", Function.identity(), Setting.Property.NodeScope);
    private final Discovery discovery;

    public DiscoveryModule(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, List<DiscoveryPlugin> plugins, AllocationService allocationService, Path configFile, GatewayMetaState gatewayMetaState, RerouteService rerouteService) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> joinValidators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        HashMap<String, Supplier<SeedHostsProvider>> hostProviders = new HashMap<String, Supplier<SeedHostsProvider>>();
        hostProviders.put("settings", () -> new SettingsBasedSeedHostsProvider(settings, transportService));
        hostProviders.put("file", () -> new FileBasedSeedHostsProvider(configFile));
        HashMap<String, ElectionStrategy> electionStrategies = new HashMap<String, ElectionStrategy>();
        electionStrategies.put(DEFAULT_ELECTION_STRATEGY, ElectionStrategy.DEFAULT_INSTANCE);
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getSeedHostProviders(transportService, networkService).forEach((key, value) -> {
                if (hostProviders.put((String)key, (Supplier<SeedHostsProvider>)value) != null) {
                    throw new IllegalArgumentException("Cannot register seed provider [" + key + "] twice");
                }
            });
            BiConsumer<DiscoveryNode, ClusterState> joinValidator = plugin.getJoinValidator();
            if (joinValidator != null) {
                joinValidators.add(joinValidator);
            }
            plugin.getElectionStrategies().forEach((key, value) -> {
                if (electionStrategies.put((String)key, (ElectionStrategy)value) != null) {
                    throw new IllegalArgumentException("Cannot register election strategy [" + key + "] twice");
                }
            });
        }
        List<String> seedProviderNames = this.getSeedProviderNames(settings);
        if (!seedProviderNames.contains("settings")) {
            ArrayList<String> extendedSeedProviderNames = new ArrayList<String>();
            extendedSeedProviderNames.add("settings");
            extendedSeedProviderNames.addAll(seedProviderNames);
            seedProviderNames = extendedSeedProviderNames;
        }
        HashSet<String> missingProviderNames = new HashSet<String>(seedProviderNames);
        missingProviderNames.removeAll(hostProviders.keySet());
        if (!missingProviderNames.isEmpty()) {
            throw new IllegalArgumentException("Unknown seed providers " + missingProviderNames);
        }
        List filteredSeedProviders = seedProviderNames.stream().map(hostProviders::get).map(Supplier::get).collect(Collectors.toList());
        String discoveryType = DISCOVERY_TYPE_SETTING.get(settings);
        SeedHostsProvider seedHostsProvider = hostsResolver -> {
            ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>();
            for (SeedHostsProvider provider : filteredSeedProviders) {
                addresses.addAll(provider.getSeedAddresses(hostsResolver));
            }
            return Collections.unmodifiableList(addresses);
        };
        ElectionStrategy electionStrategy = (ElectionStrategy)electionStrategies.get(ELECTION_STRATEGY_SETTING.get(settings));
        if (electionStrategy == null) {
            throw new IllegalArgumentException("Unknown election strategy " + ELECTION_STRATEGY_SETTING.get(settings));
        }
        if (ZEN2_DISCOVERY_TYPE.equals(discoveryType) || SINGLE_NODE_DISCOVERY_TYPE.equals(discoveryType)) {
            this.discovery = new Coordinator(Node.NODE_NAME_SETTING.get(settings), settings, clusterSettings, transportService, namedWriteableRegistry, allocationService, masterService, () -> gatewayMetaState.getPersistedState(settings, (ClusterApplierService)clusterApplier), seedHostsProvider, clusterApplier, joinValidators, new Random(Randomness.get().nextLong()), rerouteService, electionStrategy);
        } else if (ZEN_DISCOVERY_TYPE.equals(discoveryType)) {
            this.discovery = new ZenDiscovery(settings, threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, seedHostsProvider, allocationService, joinValidators, gatewayMetaState, rerouteService);
        } else {
            throw new IllegalArgumentException("Unknown discovery type [" + discoveryType + "]");
        }
        logger.info("using discovery type [{}] and seed hosts providers {}", (Object)discoveryType, (Object)seedProviderNames);
    }

    private List<String> getSeedProviderNames(Settings settings) {
        if (LEGACY_DISCOVERY_HOSTS_PROVIDER_SETTING.exists(settings)) {
            if (DISCOVERY_SEED_PROVIDERS_SETTING.exists(settings)) {
                throw new IllegalArgumentException("it is forbidden to set both [" + DISCOVERY_SEED_PROVIDERS_SETTING.getKey() + "] and [" + LEGACY_DISCOVERY_HOSTS_PROVIDER_SETTING.getKey() + "]");
            }
            return LEGACY_DISCOVERY_HOSTS_PROVIDER_SETTING.get(settings);
        }
        return DISCOVERY_SEED_PROVIDERS_SETTING.get(settings);
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }
}

