/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.LockObtainFailedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;

public abstract class ElasticsearchNodeCommand
extends EnvironmentAwareCommand {
    private static final Logger logger = LogManager.getLogger(ElasticsearchNodeCommand.class);
    protected final NamedXContentRegistry namedXContentRegistry;
    protected static final String DELIMITER = "------------------------------------------------------------------------\n";
    static final String STOP_WARNING_MSG = "------------------------------------------------------------------------\n\n    WARNING: Elasticsearch MUST be stopped before running this tool.\n";
    protected static final String FAILED_TO_OBTAIN_NODE_LOCK_MSG = "failed to lock node's directory, is Elasticsearch still running?";
    static final String NO_NODE_FOLDER_FOUND_MSG = "no node folder is found in data folder(s), node has not been started yet?";
    static final String NO_MANIFEST_FILE_FOUND_MSG = "no manifest file is found, do you run pre 7.0 Elasticsearch?";
    protected static final String GLOBAL_GENERATION_MISSING_MSG = "no metadata is referenced from the manifest file, cluster has never been bootstrapped?";
    static final String NO_GLOBAL_METADATA_MSG = "failed to find global metadata, metadata corrupted?";
    static final String WRITE_METADATA_EXCEPTION_MSG = "exception occurred when writing new metadata to disk";
    protected static final String ABORTED_BY_USER_MSG = "aborted by user";
    final OptionSpec<Integer> nodeOrdinalOption;

    public ElasticsearchNodeCommand(String description) {
        super(description);
        this.nodeOrdinalOption = this.parser.accepts("ordinal", "Optional node ordinal, 0 if not specified").withRequiredArg().ofType(Integer.class);
        this.namedXContentRegistry = new NamedXContentRegistry(ClusterModule.getNamedXWriteables());
    }

    protected void processNodePathsWithLock(Terminal terminal, OptionSet options, Environment env) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Obtaining lock for node");
        Integer nodeOrdinal = this.nodeOrdinalOption.value(options);
        if (nodeOrdinal == null) {
            nodeOrdinal = 0;
        }
        try (NodeEnvironment.NodeLock lock = new NodeEnvironment.NodeLock(nodeOrdinal, logger, env, x$0 -> Files.exists(x$0, new LinkOption[0]));){
            Path[] dataPaths = (Path[])Arrays.stream(lock.getNodePaths()).filter(Objects::nonNull).map(p -> p.path).toArray(Path[]::new);
            if (dataPaths.length == 0) {
                throw new ElasticsearchException(NO_NODE_FOLDER_FOUND_MSG, new Object[0]);
            }
            this.processNodePaths(terminal, dataPaths, env);
        }
        catch (LockObtainFailedException e) {
            throw new ElasticsearchException(FAILED_TO_OBTAIN_NODE_LOCK_MSG, (Throwable)e, new Object[0]);
        }
    }

    protected Tuple<Manifest, MetaData> loadMetaData(Terminal terminal, Path[] dataPaths) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading manifest file");
        Manifest manifest = Manifest.FORMAT.loadLatestState(logger, this.namedXContentRegistry, dataPaths);
        if (manifest == null) {
            throw new ElasticsearchException(NO_MANIFEST_FILE_FOUND_MSG, new Object[0]);
        }
        if (manifest.isGlobalGenerationMissing()) {
            throw new ElasticsearchException(GLOBAL_GENERATION_MISSING_MSG, new Object[0]);
        }
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading global metadata file");
        MetaData metaData = MetaData.FORMAT.loadGeneration(logger, this.namedXContentRegistry, manifest.getGlobalGeneration(), dataPaths);
        if (metaData == null) {
            throw new ElasticsearchException("failed to find global metadata, metadata corrupted? [generation = " + manifest.getGlobalGeneration() + "]", new Object[0]);
        }
        return Tuple.tuple(manifest, metaData);
    }

    protected void confirm(Terminal terminal, String msg) {
        terminal.println(msg);
        String text = terminal.readText("Confirm [y/N] ");
        if (!text.equalsIgnoreCase("y")) {
            throw new ElasticsearchException(ABORTED_BY_USER_MSG, new Object[0]);
        }
    }

    @Override
    protected final void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        terminal.println(STOP_WARNING_MSG);
        if (this.validateBeforeLock(terminal, env)) {
            this.processNodePathsWithLock(terminal, options, env);
        }
    }

    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        return true;
    }

    protected abstract void processNodePaths(Terminal var1, Path[] var2, Environment var3) throws IOException;

    protected void writeNewMetaData(Terminal terminal, Manifest oldManifest, long newCurrentTerm, MetaData oldMetaData, MetaData newMetaData, Path[] dataPaths) {
        try {
            terminal.println(Terminal.Verbosity.VERBOSE, "[clusterUUID = " + oldMetaData.clusterUUID() + ", committed = " + oldMetaData.clusterUUIDCommitted() + "] => [clusterUUID = " + newMetaData.clusterUUID() + ", committed = " + newMetaData.clusterUUIDCommitted() + "]");
            terminal.println(Terminal.Verbosity.VERBOSE, "New coordination metadata is " + newMetaData.coordinationMetaData());
            terminal.println(Terminal.Verbosity.VERBOSE, "Writing new global metadata to disk");
            long newGeneration = MetaData.FORMAT.write(newMetaData, dataPaths);
            Manifest newManifest = new Manifest(newCurrentTerm, oldManifest.getClusterStateVersion(), newGeneration, oldManifest.getIndexGenerations());
            terminal.println(Terminal.Verbosity.VERBOSE, "New manifest is " + newManifest);
            terminal.println(Terminal.Verbosity.VERBOSE, "Writing new manifest file to disk");
            Manifest.FORMAT.writeAndCleanup(newManifest, dataPaths);
            terminal.println(Terminal.Verbosity.VERBOSE, "Cleaning up old metadata");
            MetaData.FORMAT.cleanupOldFiles(newGeneration, dataPaths);
        }
        catch (Exception e) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Cleaning up new metadata");
            MetaData.FORMAT.cleanupOldFiles(oldManifest.getGlobalGeneration(), dataPaths);
            throw new ElasticsearchException(WRITE_METADATA_EXCEPTION_MSG, (Throwable)e, new Object[0]);
        }
    }

    protected NodeEnvironment.NodePath[] toNodePaths(Path[] dataPaths) {
        return (NodeEnvironment.NodePath[])Arrays.stream(dataPaths).map(ElasticsearchNodeCommand::createNodePath).toArray(NodeEnvironment.NodePath[]::new);
    }

    private static NodeEnvironment.NodePath createNodePath(Path path) {
        try {
            return new NodeEnvironment.NodePath(path);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Unable to investigate path [" + path + "]", (Throwable)e, new Object[0]);
        }
    }

    OptionParser getParser() {
        return this.parser;
    }
}

