/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.util.Locale;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.CannotParseTimestampException;
import org.elasticsearch.xpack.ml.job.process.autodetect.writer.DateTransformer;

public class DoubleDateTransformer
implements DateTransformer {
    private static final long MS_IN_SECOND = 1000L;
    private final boolean isMillisecond;

    public DoubleDateTransformer(boolean isMillisecond) {
        this.isMillisecond = isMillisecond;
    }

    @Override
    public long transform(String timestamp) throws CannotParseTimestampException {
        try {
            long longValue = Double.valueOf(timestamp).longValue();
            return this.isMillisecond ? longValue : longValue * 1000L;
        }
        catch (NumberFormatException e) {
            String message = String.format(Locale.ROOT, "Cannot parse timestamp '%s' as epoch value", timestamp);
            throw new CannotParseTimestampException(message, e);
        }
    }
}

