/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentElasticsearchExtension;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobRenormalizedResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.persistence.ScheduledEventsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.StateStreamer;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectCommunicator;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectWorkerExecutorService;
import org.elasticsearch.xpack.ml.job.process.autodetect.ProcessContext;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateProcessMessage;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.AutodetectResultProcessor;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.ForecastParams;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.ScoresUpdater;
import org.elasticsearch.xpack.ml.job.process.normalizer.ShortCircuitingRenormalizer;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.NativeStorageProvider;

public class AutodetectProcessManager
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(AutodetectProcessManager.class);
    private final Client client;
    private final Environment environment;
    private final ThreadPool threadPool;
    private final JobManager jobManager;
    private final JobResultsProvider jobResultsProvider;
    private final AutodetectProcessFactory autodetectProcessFactory;
    private final NormalizerFactory normalizerFactory;
    private final JobResultsPersister jobResultsPersister;
    private final JobDataCountsPersister jobDataCountsPersister;
    private NativeStorageProvider nativeStorageProvider;
    private final ConcurrentMap<Long, ProcessContext> processByAllocation = new ConcurrentHashMap<Long, ProcessContext>();
    private volatile int maxAllowedRunningJobs;
    private final NamedXContentRegistry xContentRegistry;
    private final AnomalyDetectionAuditor auditor;
    private volatile boolean upgradeInProgress;

    public AutodetectProcessManager(Environment environment, Settings settings, Client client, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, AnomalyDetectionAuditor auditor, ClusterService clusterService, JobManager jobManager, JobResultsProvider jobResultsProvider, JobResultsPersister jobResultsPersister, JobDataCountsPersister jobDataCountsPersister, AutodetectProcessFactory autodetectProcessFactory, NormalizerFactory normalizerFactory, NativeStorageProvider nativeStorageProvider) {
        this.environment = environment;
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.maxAllowedRunningJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
        this.autodetectProcessFactory = autodetectProcessFactory;
        this.normalizerFactory = normalizerFactory;
        this.jobManager = jobManager;
        this.jobResultsProvider = jobResultsProvider;
        this.jobResultsPersister = jobResultsPersister;
        this.jobDataCountsPersister = jobDataCountsPersister;
        this.auditor = auditor;
        this.nativeStorageProvider = Objects.requireNonNull(nativeStorageProvider);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxAllowedRunningJobs);
    }

    void setMaxAllowedRunningJobs(int maxAllowedRunningJobs) {
        this.maxAllowedRunningJobs = maxAllowedRunningJobs;
    }

    public synchronized void closeAllJobsOnThisNode(String reason) {
        int numJobs = this.processByAllocation.size();
        if (numJobs != 0) {
            logger.info("Closing [{}] jobs, because [{}]", (Object)numJobs, (Object)reason);
            for (ProcessContext process : this.processByAllocation.values()) {
                this.closeJob(process.getJobTask(), false, reason);
            }
        }
    }

    public void killProcess(TransportOpenJobAction.JobTask jobTask, boolean awaitCompletion, String reason) {
        logger.trace("[{}] Killing process: awaitCompletion = [{}]; reason = [{}]", (Object)jobTask.getJobId(), (Object)awaitCompletion, (Object)reason);
        ProcessContext processContext = (ProcessContext)this.processByAllocation.remove(jobTask.getAllocationId());
        if (processContext != null) {
            processContext.newKillBuilder().setAwaitCompletion(awaitCompletion).setFinish(true).setReason(reason).setShouldFinalizeJob(!this.upgradeInProgress).kill();
        } else {
            logger.trace("[{}] Marking job task as completed", (Object)jobTask.getJobId());
            jobTask.markAsCompleted();
        }
    }

    public void killAllProcessesOnThisNode() {
        Iterator iterator = this.processByAllocation.values().iterator();
        while (iterator.hasNext()) {
            ProcessContext processContext = (ProcessContext)iterator.next();
            processContext.newKillBuilder().setAwaitCompletion(false).setFinish(false).setSilent(true).kill();
            iterator.remove();
        }
    }

    public void persistJob(TransportOpenJobAction.JobTask jobTask, Consumer<Exception> handler) {
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = String.format(Locale.ROOT, "Cannot persist because job [%s] does not have a corresponding autodetect process", jobTask.getJobId());
            logger.debug(message);
            handler.accept((Exception)((Object)ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
            return;
        }
        communicator.persistJob((aVoid, e) -> handler.accept((Exception)e));
    }

    public void processData(TransportOpenJobAction.JobTask jobTask, AnalysisRegistry analysisRegistry, InputStream input, XContentType xContentType, DataLoadParams params, BiConsumer<DataCounts, Exception> handler) {
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            throw ExceptionsHelper.conflictStatusException((String)("Cannot process data because job [" + jobTask.getJobId() + "] does not have a corresponding autodetect process"), (Object[])new Object[0]);
        }
        communicator.writeToJob(input, analysisRegistry, xContentType, params, handler);
    }

    public void flushJob(TransportOpenJobAction.JobTask jobTask, FlushJobParams params, ActionListener<FlushAcknowledgement> handler) {
        logger.debug("Flushing job {}", (Object)jobTask.getJobId());
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = String.format(Locale.ROOT, "Cannot flush because job [%s] does not have a corresponding autodetect process", jobTask.getJobId());
            logger.debug(message);
            handler.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
            return;
        }
        communicator.flushJob(params, (flushAcknowledgement, e) -> {
            if (e != null) {
                String msg = String.format(Locale.ROOT, "[%s] exception while flushing job", jobTask.getJobId());
                logger.error(msg);
                handler.onFailure((Exception)ExceptionsHelper.serverError((String)msg, (Throwable)e));
            } else {
                handler.onResponse(flushAcknowledgement);
            }
        });
    }

    public void forecastJob(TransportOpenJobAction.JobTask jobTask, ForecastParams params, Consumer<Exception> handler) {
        String jobId = jobTask.getJobId();
        logger.debug("Forecasting job {}", (Object)jobId);
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = String.format(Locale.ROOT, "Cannot forecast because job [%s] does not have a corresponding autodetect process", jobId);
            logger.debug(message);
            handler.accept((Exception)((Object)ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
            return;
        }
        communicator.forecastJob(params, (aVoid, e) -> {
            if (e == null) {
                handler.accept(null);
            } else {
                String msg = String.format(Locale.ROOT, "[%s] exception while forecasting job", jobId);
                logger.error(msg, (Throwable)e);
                handler.accept((Exception)ExceptionsHelper.serverError((String)msg, (Throwable)e));
            }
        });
    }

    public void writeUpdateProcessMessage(final TransportOpenJobAction.JobTask jobTask, UpdateParams updateParams, final Consumer<Exception> handler) {
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = "Cannot update the job config because job [" + jobTask.getJobId() + "] does not have a corresponding autodetect process";
            logger.debug(message);
            handler.accept((Exception)((Object)ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
            return;
        }
        UpdateProcessMessage.Builder updateProcessMessage = new UpdateProcessMessage.Builder();
        updateProcessMessage.setModelPlotConfig(updateParams.getModelPlotConfig());
        updateProcessMessage.setDetectorUpdates(updateParams.getDetectorUpdates());
        final ActionListener eventsListener = ActionListener.wrap(events -> {
            updateProcessMessage.setScheduledEvents(events == null ? null : events.results());
            communicator.writeUpdateProcessMessage(updateProcessMessage.build(), (aVoid, e) -> {
                if (e == null) {
                    handler.accept(null);
                } else {
                    handler.accept((Exception)e);
                }
            });
        }, handler);
        final ActionListener filterListener = ActionListener.wrap(filter -> {
            updateProcessMessage.setFilter((MlFilter)filter);
            if (updateParams.isUpdateScheduledEvents()) {
                this.jobManager.getJob(jobTask.getJobId(), new ActionListener<Job>(){

                    public void onResponse(Job job) {
                        DataCounts dataCounts = (DataCounts)AutodetectProcessManager.this.getStatistics(jobTask).get().v1();
                        ScheduledEventsQueryBuilder query = new ScheduledEventsQueryBuilder().start(job.earliestValidTimestamp(dataCounts));
                        AutodetectProcessManager.this.jobResultsProvider.scheduledEventsForJob(jobTask.getJobId(), job.getGroups(), query, (ActionListener<QueryPage<ScheduledEvent>>)eventsListener);
                    }

                    public void onFailure(Exception e) {
                        handler.accept(e);
                    }
                });
            } else {
                eventsListener.onResponse(null);
            }
        }, handler);
        if (updateParams.getFilter() == null) {
            filterListener.onResponse(null);
        } else {
            GetFiltersAction.Request getFilterRequest = new GetFiltersAction.Request();
            getFilterRequest.setFilterId(updateParams.getFilter().getId());
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetFiltersAction.INSTANCE, (ActionRequest)getFilterRequest, (ActionListener)new ActionListener<GetFiltersAction.Response>(){

                public void onResponse(GetFiltersAction.Response response) {
                    filterListener.onResponse((Object)((MlFilter)response.getFilters().results().get(0)));
                }

                public void onFailure(Exception e) {
                    handler.accept(e);
                }
            });
        }
    }

    public void openJob(final TransportOpenJobAction.JobTask jobTask, ClusterState clusterState, final BiConsumer<Exception, Boolean> closeHandler) {
        final String jobId = jobTask.getJobId();
        logger.info("Opening job [{}]", (Object)jobId);
        ActionListener stateAliasHandler = ActionListener.wrap(r -> this.jobManager.getJob(jobId, (ActionListener<Job>)ActionListener.wrap(job -> {
            if (job.getJobVersion() == null) {
                closeHandler.accept((Exception)((Object)ExceptionsHelper.badRequestException((String)("Cannot open job [" + jobId + "] because jobs created prior to version 5.5 are not supported"), (Object[])new Object[0])), true);
                return;
            }
            this.processByAllocation.putIfAbsent(jobTask.getAllocationId(), new ProcessContext(jobTask));
            this.jobResultsProvider.getAutodetectParams((Job)job, params -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable((Job)job, (AutodetectParams)params){
                final /* synthetic */ Job val$job;
                final /* synthetic */ AutodetectParams val$params;
                {
                    this.val$job = job;
                    this.val$params = autodetectParams;
                }

                public void onFailure(Exception e) {
                    closeHandler.accept(e, true);
                }

                protected void doRun() {
                    ProcessContext processContext = (ProcessContext)AutodetectProcessManager.this.processByAllocation.get(jobTask.getAllocationId());
                    if (processContext == null) {
                        logger.debug("Aborted opening job [{}] as it has been closed", (Object)jobId);
                        return;
                    }
                    try {
                        if (AutodetectProcessManager.this.createProcessAndSetRunning(processContext, this.val$job, this.val$params, closeHandler)) {
                            processContext.getAutodetectCommunicator().restoreState(this.val$params.modelSnapshot());
                            AutodetectProcessManager.this.setJobState(jobTask, JobState.OPENED);
                        }
                    }
                    catch (Exception e1) {
                        try {
                            processContext.newKillBuilder().setAwaitCompletion(false).setFinish(false).kill();
                            AutodetectProcessManager.this.processByAllocation.remove(jobTask.getAllocationId());
                        }
                        finally {
                            AutodetectProcessManager.this.setJobState(jobTask, JobState.FAILED, e1.getMessage(), (CheckedConsumer<Exception, IOException>)((CheckedConsumer)e2 -> closeHandler.accept(e1, true)));
                        }
                    }
                }
            }), e1 -> {
                logger.warn("Failed to gather information required to open job [" + jobId + "]", (Throwable)e1);
                this.setJobState(jobTask, JobState.FAILED, e1.getMessage(), (CheckedConsumer<Exception, IOException>)((CheckedConsumer)e2 -> closeHandler.accept((Exception)e1, true)));
            });
        }, e -> closeHandler.accept((Exception)e, true))), e -> closeHandler.accept((Exception)e, true));
        ActionListener resultsMappingUpdateHandler = ActionListener.wrap(ack -> AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessary((Client)this.client, (ClusterState)clusterState, (ActionListener)stateAliasHandler), e -> closeHandler.accept((Exception)e, true));
        ElasticsearchMappings.addDocMappingIfMissing((String)AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId), ElasticsearchMappings::resultsMapping, (Client)this.client, (ClusterState)clusterState, (ActionListener)resultsMappingUpdateHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createProcessAndSetRunning(ProcessContext processContext, Job job, AutodetectParams params, BiConsumer<Exception, Boolean> handler) throws IOException {
        processContext.tryLock();
        try {
            if (processContext.getState() != ProcessContext.ProcessStateName.NOT_RUNNING) {
                logger.debug("Cannot open job [{}] when its state is [{}]", (Object)job.getId(), (Object)((Object)((Object)processContext.getState())).getClass().getName());
                boolean bl = false;
                return bl;
            }
            AutodetectCommunicator communicator = this.create(processContext.getJobTask(), job, params, handler);
            communicator.writeHeader();
            processContext.setRunning(communicator);
            boolean bl = true;
            return bl;
        }
        finally {
            processContext.unlock();
        }
    }

    AutodetectCommunicator create(TransportOpenJobAction.JobTask jobTask, Job job, AutodetectParams autodetectParams, BiConsumer<Exception, Boolean> handler) {
        ExecutorService autodetectWorkerExecutor;
        int localMaxAllowedRunningJobs = this.maxAllowedRunningJobs;
        int currentRunningJobs = this.processByAllocation.size();
        if (currentRunningJobs > localMaxAllowedRunningJobs) {
            throw new ElasticsearchStatusException("max running job capacity [" + localMaxAllowedRunningJobs + "] reached", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
        }
        String jobId = jobTask.getJobId();
        this.notifyLoadingSnapshot(jobId, autodetectParams);
        if (autodetectParams.dataCounts().getProcessedRecordCount() > 0L) {
            String msg;
            if (autodetectParams.modelSnapshot() == null) {
                msg = "No model snapshot could be found for a job with processed records";
                logger.warn("[{}] {}", (Object)jobId, (Object)msg);
                this.auditor.warning(jobId, "No model snapshot could be found for a job with processed records");
            }
            if (autodetectParams.quantiles() == null) {
                msg = "No quantiles could be found for a job with processed records";
                logger.warn("[{}] {}", (Object)jobId, (Object)msg);
                this.auditor.warning(jobId, msg);
            }
        }
        ExecutorService autodetectExecutorService = this.threadPool.executor("ml_job_comms");
        DataCountsReporter dataCountsReporter = new DataCountsReporter(job, autodetectParams.dataCounts(), this.jobDataCountsPersister);
        ScoresUpdater scoresUpdater = new ScoresUpdater(job, this.jobResultsProvider, new JobRenormalizedResultsPersister(job.getId(), this.client), this.normalizerFactory);
        ExecutorService renormalizerExecutorService = this.threadPool.executor("ml_utility");
        ShortCircuitingRenormalizer renormalizer = new ShortCircuitingRenormalizer(jobId, scoresUpdater, renormalizerExecutorService);
        AutodetectProcess process = this.autodetectProcessFactory.createAutodetectProcess(job, autodetectParams, autodetectExecutorService, this.onProcessCrash(jobTask));
        AutodetectResultProcessor processor = new AutodetectResultProcessor(this.client, this.auditor, jobId, renormalizer, this.jobResultsPersister, process, autodetectParams.modelSizeStats(), autodetectParams.timingStats());
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            autodetectWorkerExecutor = this.createAutodetectExecutorService(autodetectExecutorService);
            autodetectExecutorService.submit(processor::process);
        }
        catch (EsRejectedExecutionException e) {
            try {
                IOUtils.close((Closeable[])new Closeable[]{process});
            }
            catch (IOException ioe) {
                logger.error("Can't close autodetect", (Throwable)ioe);
            }
            throw e;
        }
        return new AutodetectCommunicator(job, this.environment, process, new StateStreamer(this.client), dataCountsReporter, processor, handler, this.xContentRegistry, autodetectWorkerExecutor);
    }

    private void notifyLoadingSnapshot(String jobId, AutodetectParams autodetectParams) {
        ModelSnapshot modelSnapshot = autodetectParams.modelSnapshot();
        StringBuilder msgBuilder = new StringBuilder("Loading model snapshot [");
        if (modelSnapshot == null) {
            msgBuilder.append("N/A");
        } else {
            msgBuilder.append(modelSnapshot.getSnapshotId());
            msgBuilder.append("] with latest_record_timestamp [");
            Date snapshotLatestRecordTimestamp = modelSnapshot.getLatestRecordTimeStamp();
            msgBuilder.append(snapshotLatestRecordTimestamp == null ? "N/A" : XContentElasticsearchExtension.DEFAULT_DATE_PRINTER.print(snapshotLatestRecordTimestamp.getTime()));
        }
        msgBuilder.append("], job latest_record_timestamp [");
        Date jobLatestRecordTimestamp = autodetectParams.dataCounts().getLatestRecordTimeStamp();
        msgBuilder.append(jobLatestRecordTimestamp == null ? "N/A" : XContentElasticsearchExtension.DEFAULT_DATE_PRINTER.print(jobLatestRecordTimestamp.getTime()));
        msgBuilder.append("]");
        String msg = msgBuilder.toString();
        logger.info("[{}] {}", (Object)jobId, (Object)msg);
        this.auditor.info(jobId, msg);
    }

    private Consumer<String> onProcessCrash(TransportOpenJobAction.JobTask jobTask) {
        return reason -> {
            AutodetectCommunicator communicator;
            ProcessContext processContext = (ProcessContext)this.processByAllocation.remove(jobTask.getAllocationId());
            if (processContext != null && (communicator = processContext.getAutodetectCommunicator()) != null) {
                communicator.destroyCategorizationAnalyzer();
            }
            this.setJobState(jobTask, JobState.FAILED, (String)reason);
            try {
                this.nativeStorageProvider.cleanupLocalTmpStorage(jobTask.getDescription());
            }
            catch (IOException e) {
                logger.error((Message)new ParameterizedMessage("[{}] Failed to delete temporary files", (Object)jobTask.getJobId()), (Throwable)e);
            }
        };
    }

    public void closeJob(TransportOpenJobAction.JobTask jobTask, boolean restart, String reason) {
        String jobId = jobTask.getJobId();
        long allocationId = jobTask.getAllocationId();
        logger.debug("Attempting to close job [{}], because [{}]", (Object)jobId, (Object)reason);
        ProcessContext processContext = (ProcessContext)this.processByAllocation.get(allocationId);
        if (processContext == null) {
            logger.debug("Cannot close job [{}] as it has already been closed", (Object)jobId);
            return;
        }
        processContext.tryLock();
        try {
            if (!processContext.setDying()) {
                logger.debug("Cannot close job [{}] as it has been marked as dying", (Object)jobId);
                return;
            }
            if (reason == null) {
                logger.info("Closing job [{}]", (Object)jobId);
            } else {
                logger.info("Closing job [{}], because [{}]", (Object)jobId, (Object)reason);
            }
            AutodetectCommunicator communicator = processContext.getAutodetectCommunicator();
            if (communicator == null) {
                logger.debug("Job [{}] is being closed before its process is started", (Object)jobId);
                jobTask.markAsCompleted();
            } else {
                communicator.close(restart, reason);
            }
            this.processByAllocation.remove(allocationId);
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchStatusException && ((ElasticsearchStatusException)((Object)e)).status() == RestStatus.CONFLICT) {
                throw e;
            }
            logger.warn("[" + jobId + "] Exception closing autodetect process", (Throwable)e);
            this.setJobState(jobTask, JobState.FAILED, e.getMessage());
            throw ExceptionsHelper.serverError((String)"Exception closing autodetect process", (Throwable)e);
        }
        finally {
            processContext.unlock();
        }
        try {
            this.nativeStorageProvider.cleanupLocalTmpStorage(jobTask.getDescription());
        }
        catch (IOException e) {
            logger.error((Message)new ParameterizedMessage("[{}] Failed to delete temporary files", (Object)jobId), (Throwable)e);
        }
    }

    int numberOfOpenJobs() {
        return (int)this.processByAllocation.values().stream().filter(p -> p.getState() != ProcessContext.ProcessStateName.DYING).count();
    }

    boolean jobHasActiveAutodetectProcess(TransportOpenJobAction.JobTask jobTask) {
        return this.getAutodetectCommunicator(jobTask) != null;
    }

    private AutodetectCommunicator getAutodetectCommunicator(TransportOpenJobAction.JobTask jobTask) {
        return this.processByAllocation.getOrDefault(jobTask.getAllocationId(), new ProcessContext(jobTask)).getAutodetectCommunicator();
    }

    private AutodetectCommunicator getOpenAutodetectCommunicator(TransportOpenJobAction.JobTask jobTask) {
        ProcessContext processContext = (ProcessContext)this.processByAllocation.get(jobTask.getAllocationId());
        if (processContext != null && processContext.getState() == ProcessContext.ProcessStateName.RUNNING) {
            return processContext.getAutodetectCommunicator();
        }
        return null;
    }

    public boolean hasOpenAutodetectCommunicator(long jobAllocationId) {
        ProcessContext processContext = (ProcessContext)this.processByAllocation.get(jobAllocationId);
        if (processContext != null && processContext.getState() == ProcessContext.ProcessStateName.RUNNING) {
            return processContext.getAutodetectCommunicator() != null;
        }
        return false;
    }

    public Optional<Duration> jobOpenTime(TransportOpenJobAction.JobTask jobTask) {
        AutodetectCommunicator communicator = this.getAutodetectCommunicator(jobTask);
        if (communicator == null) {
            return Optional.empty();
        }
        return Optional.of(Duration.between(communicator.getProcessStartTime(), ZonedDateTime.now()));
    }

    void setJobState(final TransportOpenJobAction.JobTask jobTask, final JobState state, String reason) {
        JobTaskState jobTaskState = new JobTaskState(state, jobTask.getAllocationId(), reason);
        jobTask.updatePersistentTaskState((PersistentTaskState)jobTaskState, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                logger.info("Successfully set job state to [{}] for job [{}]", (Object)state, (Object)jobTask.getJobId());
            }

            public void onFailure(Exception e) {
                logger.error("Could not set job state to [" + state + "] for job [" + jobTask.getJobId() + "]", (Throwable)e);
            }
        });
    }

    void setJobState(TransportOpenJobAction.JobTask jobTask, JobState state) {
        this.setJobState(jobTask, state, null);
    }

    void setJobState(TransportOpenJobAction.JobTask jobTask, JobState state, String reason, final CheckedConsumer<Exception, IOException> handler) {
        JobTaskState jobTaskState = new JobTaskState(state, jobTask.getAllocationId(), reason);
        jobTask.updatePersistentTaskState((PersistentTaskState)jobTaskState, new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                try {
                    handler.accept(null);
                }
                catch (IOException e1) {
                    logger.warn("Error while delegating response", (Throwable)e1);
                }
            }

            public void onFailure(Exception e) {
                try {
                    handler.accept((Object)e);
                }
                catch (IOException e1) {
                    logger.warn("Error while delegating exception [" + e.getMessage() + "]", (Throwable)e1);
                }
            }
        });
    }

    public Optional<Tuple<DataCounts, Tuple<ModelSizeStats, TimingStats>>> getStatistics(TransportOpenJobAction.JobTask jobTask) {
        AutodetectCommunicator communicator = this.getAutodetectCommunicator(jobTask);
        if (communicator == null) {
            return Optional.empty();
        }
        return Optional.of(new Tuple((Object)communicator.getDataCounts(), (Object)new Tuple((Object)communicator.getModelSizeStats(), (Object)communicator.getTimingStats())));
    }

    ExecutorService createAutodetectExecutorService(ExecutorService executorService) {
        AutodetectWorkerExecutorService autodetectWorkerExecutor = new AutodetectWorkerExecutorService(this.threadPool.getThreadContext());
        executorService.submit(autodetectWorkerExecutor::start);
        return autodetectWorkerExecutor;
    }

    public ByteSizeValue getMinLocalStorageAvailable() {
        return this.nativeStorageProvider.getMinLocalStorageAvailable();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        this.upgradeInProgress = MlMetadata.getMlMetadata((ClusterState)event.state()).isUpgradeMode();
    }
}

