/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FieldStats;
import org.elasticsearch.xpack.ml.filestructurefinder.FieldStatsCalculator;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;
import org.elasticsearch.xpack.ml.filestructurefinder.TimestampFormatFinder;

public final class FileStructureUtils {
    public static final String DEFAULT_TIMESTAMP_FIELD = "@timestamp";
    public static final String MAPPING_TYPE_SETTING = "type";
    public static final String MAPPING_FORMAT_SETTING = "format";
    public static final String MAPPING_PROPERTIES_SETTING = "properties";
    public static final Map<String, String> DATE_MAPPING_WITHOUT_FORMAT = Collections.singletonMap("type", "date");
    private static final int NUM_TOP_HITS = 10;
    private static final Grok NUMBER_GROK = new Grok(Grok.getBuiltinPatterns(), "^%{NUMBER}(?:[eE][+-]?[0-3]?[0-9]{1,2})?$", TimeoutChecker.watchdog);
    private static final Grok IP_GROK = new Grok(Grok.getBuiltinPatterns(), "^%{IP}$", TimeoutChecker.watchdog);
    private static final int KEYWORD_MAX_LEN = 256;
    private static final int KEYWORD_MAX_SPACES = 5;
    private static final String BEAT_TIMEZONE_FIELD = "beat.timezone";

    private FileStructureUtils() {
    }

    static Tuple<String, TimestampFormatFinder> guessTimestampField(List<String> explanation, List<Map<String, ?>> sampleRecords, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        if (sampleRecords.isEmpty()) {
            return null;
        }
        StringBuilder exceptionMsg = null;
        for (Tuple<String, TimestampFormatFinder> candidate : FileStructureUtils.findCandidates(explanation, sampleRecords, overrides, timeoutChecker)) {
            String fieldName = (String)candidate.v1();
            TimestampFormatFinder timestampFormatFinder = (TimestampFormatFinder)candidate.v2();
            boolean allGood = true;
            for (Map<String, ?> sampleRecord : sampleRecords.subList(1, sampleRecords.size())) {
                Object fieldValue = sampleRecord.get(fieldName);
                if (fieldValue == null) {
                    if (overrides.getTimestampField() != null) {
                        throw new IllegalArgumentException("Specified timestamp field [" + overrides.getTimestampField() + "] is not present in record [" + sampleRecord + "]");
                    }
                    explanation.add("First sample match [" + fieldName + "] ruled out because record [" + sampleRecord + "] doesn't have field");
                    allGood = false;
                    break;
                }
                timeoutChecker.check("timestamp field determination");
                try {
                    timestampFormatFinder.addSample(fieldValue.toString());
                }
                catch (IllegalArgumentException e) {
                    if (overrides.getTimestampFormat() != null) {
                        if (exceptionMsg == null) {
                            exceptionMsg = new StringBuilder("Specified timestamp format [" + overrides.getTimestampFormat() + "] does not match");
                        } else {
                            exceptionMsg.append(", nor");
                        }
                        exceptionMsg.append(" for record [").append(sampleRecord).append("] in field [").append(fieldName).append("]");
                    }
                    explanation.add("First sample match " + timestampFormatFinder.getRawJavaTimestampFormats() + " ruled out because record [" + sampleRecord + "] does not match");
                    allGood = false;
                    break;
                }
            }
            if (!allGood) continue;
            explanation.add((overrides.getTimestampField() == null ? "Guessing timestamp" : "Timestamp") + " field is [" + fieldName + "] with format " + timestampFormatFinder.getJavaTimestampFormats());
            return candidate;
        }
        if (exceptionMsg != null) {
            throw new IllegalArgumentException(exceptionMsg.toString());
        }
        return null;
    }

    private static List<Tuple<String, TimestampFormatFinder>> findCandidates(List<String> explanation, List<Map<String, ?>> sampleRecords, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        assert (!sampleRecords.isEmpty());
        Map<String, ?> firstRecord = sampleRecords.get(0);
        String onlyConsiderField = overrides.getTimestampField();
        if (onlyConsiderField != null && firstRecord.get(onlyConsiderField) == null) {
            throw new IllegalArgumentException("Specified timestamp field [" + overrides.getTimestampField() + "] is not present in record [" + firstRecord + "]");
        }
        ArrayList<Tuple<String, TimestampFormatFinder>> candidates = new ArrayList<Tuple<String, TimestampFormatFinder>>();
        for (Map.Entry<String, ?> field : firstRecord.entrySet()) {
            Object value;
            String fieldName = field.getKey();
            if (onlyConsiderField != null && !onlyConsiderField.equals(fieldName) || (value = field.getValue()) == null) continue;
            TimestampFormatFinder timestampFormatFinder = new TimestampFormatFinder(explanation, overrides.getTimestampFormat(), true, true, true, timeoutChecker);
            try {
                timestampFormatFinder.addSample(value.toString());
                candidates.add((Tuple<String, TimestampFormatFinder>)new Tuple((Object)fieldName, (Object)timestampFormatFinder));
                explanation.add("First sample timestamp match " + timestampFormatFinder.getRawJavaTimestampFormats() + " for field [" + fieldName + "]");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (candidates.isEmpty() && overrides.getTimestampFormat() != null) {
            throw new IllegalArgumentException("Specified timestamp format [" + overrides.getTimestampFormat() + "] does not match for record [" + firstRecord + "]");
        }
        return candidates;
    }

    static Tuple<SortedMap<String, Object>, SortedMap<String, FieldStats>> guessMappingsAndCalculateFieldStats(List<String> explanation, List<Map<String, ?>> sampleRecords, TimeoutChecker timeoutChecker) {
        TreeMap<String, Object> mappings = new TreeMap<String, Object>();
        TreeMap<String, FieldStats> fieldStats = new TreeMap<String, FieldStats>();
        Set uniqueFieldNames = sampleRecords.stream().flatMap(record -> record.keySet().stream()).collect(Collectors.toSet());
        for (String fieldName : uniqueFieldNames) {
            List<Object> fieldValues;
            Tuple<Map<String, String>, FieldStats> mappingAndFieldStats = FileStructureUtils.guessMappingAndCalculateFieldStats(explanation, fieldName, fieldValues = sampleRecords.stream().map(record -> record.get(fieldName)).filter(fieldValue -> fieldValue != null).collect(Collectors.toList()), timeoutChecker);
            if (mappingAndFieldStats == null) continue;
            if (mappingAndFieldStats.v1() != null) {
                mappings.put(fieldName, mappingAndFieldStats.v1());
            }
            if (mappingAndFieldStats.v2() == null) continue;
            fieldStats.put(fieldName, (FieldStats)mappingAndFieldStats.v2());
        }
        return new Tuple(mappings, fieldStats);
    }

    static Tuple<Map<String, String>, FieldStats> guessMappingAndCalculateFieldStats(List<String> explanation, String fieldName, List<Object> fieldValues, TimeoutChecker timeoutChecker) {
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.stream().anyMatch(value -> value instanceof Map)) {
            if (fieldValues.stream().allMatch(value -> value instanceof Map)) {
                return new Tuple(Collections.singletonMap(MAPPING_TYPE_SETTING, "object"), null);
            }
            throw new IllegalArgumentException("Field [" + fieldName + "] has both object and non-object values - this is not supported by Elasticsearch");
        }
        if (fieldValues.stream().anyMatch(value -> value instanceof List || value instanceof Object[])) {
            return FileStructureUtils.guessMappingAndCalculateFieldStats(explanation, fieldName, fieldValues.stream().flatMap(FileStructureUtils::flatten).collect(Collectors.toList()), timeoutChecker);
        }
        Collection fieldValuesAsStrings = fieldValues.stream().map(Object::toString).collect(Collectors.toList());
        Map<String, String> mapping = FileStructureUtils.guessScalarMapping(explanation, fieldName, fieldValuesAsStrings, timeoutChecker);
        timeoutChecker.check("mapping determination");
        return new Tuple(mapping, (Object)FileStructureUtils.calculateFieldStats(mapping, fieldValuesAsStrings, timeoutChecker));
    }

    private static Stream<Object> flatten(Object value) {
        if (value instanceof List) {
            List objectList = (List)value;
            return objectList.stream();
        }
        if (value instanceof Object[]) {
            return Arrays.stream((Object[])value);
        }
        return Stream.of(value);
    }

    static Map<String, String> findTimestampMapping(List<String> explanation, Collection<String> fieldValues, TimeoutChecker timeoutChecker) {
        assert (!fieldValues.isEmpty());
        TimestampFormatFinder timestampFormatFinder = new TimestampFormatFinder(explanation, true, true, true, timeoutChecker);
        fieldValues.forEach(timestampFormatFinder::addSample);
        return timestampFormatFinder.getEsDateMappingTypeWithFormat();
    }

    static Map<String, String> guessScalarMapping(List<String> explanation, String fieldName, Collection<String> fieldValues, TimeoutChecker timeoutChecker) {
        assert (!fieldValues.isEmpty());
        if (fieldValues.stream().allMatch(value -> "true".equals(value) || "false".equals(value))) {
            return Collections.singletonMap(MAPPING_TYPE_SETTING, "boolean");
        }
        try {
            return FileStructureUtils.findTimestampMapping(explanation, fieldValues, timeoutChecker);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (fieldValues.stream().allMatch(arg_0 -> ((Grok)NUMBER_GROK).match(arg_0))) {
                try {
                    fieldValues.forEach(Long::parseLong);
                    return Collections.singletonMap(MAPPING_TYPE_SETTING, "long");
                }
                catch (NumberFormatException e) {
                    explanation.add("Rejecting type 'long' for field [" + fieldName + "] due to parse failure: [" + e.getMessage() + "]");
                    try {
                        fieldValues.forEach(Double::parseDouble);
                        return Collections.singletonMap(MAPPING_TYPE_SETTING, "double");
                    }
                    catch (NumberFormatException e2) {
                        explanation.add("Rejecting type 'double' for field [" + fieldName + "] due to parse failure: [" + e2.getMessage() + "]");
                    }
                }
            } else if (fieldValues.stream().allMatch(arg_0 -> ((Grok)IP_GROK).match(arg_0))) {
                return Collections.singletonMap(MAPPING_TYPE_SETTING, "ip");
            }
            if (fieldValues.stream().anyMatch(FileStructureUtils::isMoreLikelyTextThanKeyword)) {
                return Collections.singletonMap(MAPPING_TYPE_SETTING, "text");
            }
            return Collections.singletonMap(MAPPING_TYPE_SETTING, "keyword");
        }
    }

    static FieldStats calculateFieldStats(Map<String, String> mapping, Collection<String> fieldValues, TimeoutChecker timeoutChecker) {
        FieldStatsCalculator calculator = new FieldStatsCalculator(mapping);
        calculator.accept(fieldValues);
        timeoutChecker.check("field stats calculation");
        return calculator.calculate(10);
    }

    static boolean isMoreLikelyTextThanKeyword(String str) {
        int length = str.length();
        return length > 256 || length - str.replaceAll("\\s", "").length() > 5;
    }

    public static Map<String, Object> makeIngestPipelineDefinition(String grokPattern, Map<String, String> customGrokPatternDefinitions, String timestampField, List<String> timestampFormats, boolean needClientTimezone) {
        if (grokPattern == null && timestampField == null) {
            return null;
        }
        LinkedHashMap<String, Object> pipeline = new LinkedHashMap<String, Object>();
        pipeline.put("description", "Ingest pipeline created by file structure finder");
        ArrayList<Map<String, Map<Object, Object>>> processors = new ArrayList<Map<String, Map<Object, Object>>>();
        if (grokPattern != null) {
            LinkedHashMap<String, Object> grokProcessorSettings = new LinkedHashMap<String, Object>();
            grokProcessorSettings.put("field", "message");
            grokProcessorSettings.put("patterns", Collections.singletonList(grokPattern));
            if (!customGrokPatternDefinitions.isEmpty()) {
                grokProcessorSettings.put("pattern_definitions", customGrokPatternDefinitions);
            }
            processors.add(Collections.singletonMap("grok", grokProcessorSettings));
        } else assert (customGrokPatternDefinitions.isEmpty());
        if (timestampField != null) {
            LinkedHashMap<String, Object> dateProcessorSettings = new LinkedHashMap<String, Object>();
            dateProcessorSettings.put("field", timestampField);
            if (needClientTimezone) {
                dateProcessorSettings.put("timezone", "{{ beat.timezone }}");
            }
            dateProcessorSettings.put("formats", timestampFormats);
            processors.add(Collections.singletonMap("date", dateProcessorSettings));
        }
        if (grokPattern != null && timestampField != null) {
            processors.add(Collections.singletonMap("remove", Collections.singletonMap("field", timestampField)));
        }
        pipeline.put("processors", processors);
        return pipeline;
    }
}

