/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process.customprocessing;

import java.util.List;
import java.util.Random;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Regression;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.process.customprocessing.CustomProcessor;

class RegressionCustomProcessor
implements CustomProcessor {
    private static final String EMPTY = "";
    private final int dependentVariableIndex;
    private final double trainingPercent;
    private final Random random = Randomness.get();
    private boolean isFirstRow = true;

    RegressionCustomProcessor(List<String> fieldNames, Regression regression) {
        this.dependentVariableIndex = RegressionCustomProcessor.findDependentVariableIndex(fieldNames, regression.getDependentVariable());
        this.trainingPercent = regression.getTrainingPercent();
    }

    private static int findDependentVariableIndex(List<String> fieldNames, String dependentVariable) {
        for (int i = 0; i < fieldNames.size(); ++i) {
            if (!fieldNames.get(i).equals(dependentVariable)) continue;
            return i;
        }
        throw ExceptionsHelper.serverError((String)("Could not find dependent variable [" + dependentVariable + "] in fields " + fieldNames));
    }

    @Override
    public void process(String[] row) {
        if (this.canBeUsedForTraining(row)) {
            if (this.isFirstRow) {
                this.isFirstRow = false;
            } else if (this.isRandomlyExcludedFromTraining()) {
                row[this.dependentVariableIndex] = EMPTY;
            }
        }
    }

    private boolean canBeUsedForTraining(String[] row) {
        return row[this.dependentVariableIndex].length() > 0;
    }

    private boolean isRandomlyExcludedFromTraining() {
        return this.random.nextDouble() * 100.0 > this.trainingPercent;
    }
}

