/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.xpack.ml.dataframe.process.AbstractNativeAnalyticsProcess;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsControlMessageWriter;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessConfig;
import org.elasticsearch.xpack.ml.dataframe.process.results.AnalyticsResult;
import org.elasticsearch.xpack.ml.process.ProcessResultsParser;

public class NativeAnalyticsProcess
extends AbstractNativeAnalyticsProcess<AnalyticsResult> {
    private static final String NAME = "analytics";
    private final ProcessResultsParser<AnalyticsResult> resultsParser = new ProcessResultsParser<AnalyticsResult>(AnalyticsResult.PARSER);
    private final AnalyticsProcessConfig config;

    protected NativeAnalyticsProcess(String jobId, InputStream logStream, OutputStream processInStream, InputStream processOutStream, OutputStream processRestoreStream, int numberOfFields, List<Path> filesToDelete, Consumer<String> onProcessCrash, AnalyticsProcessConfig config) {
        super(NAME, AnalyticsResult.PARSER, jobId, logStream, processInStream, processOutStream, processRestoreStream, numberOfFields, filesToDelete, onProcessCrash);
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void persistState() {
    }

    @Override
    public void writeEndOfDataMessage() throws IOException {
        new AnalyticsControlMessageWriter(this.recordWriter(), this.numberOfFields()).writeEndOfData();
    }

    @Override
    public Iterator<AnalyticsResult> readAnalyticsResults() {
        return this.resultsParser.parseResults(this.processOutStream());
    }

    @Override
    public AnalyticsProcessConfig getConfig() {
        return this.config;
    }
}

