/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DataFrameAnalyticsConfigProvider {
    private static final Logger logger = LogManager.getLogger(DataFrameAnalyticsConfigProvider.class);
    private static final int MAX_CONFIGS_SIZE = 10000;
    private static final Map<String, String> TO_XCONTENT_PARAMS;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    public DataFrameAnalyticsConfigProvider(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = Objects.requireNonNull(client);
        this.xContentRegistry = xContentRegistry;
    }

    public void put(DataFrameAnalyticsConfig config, Map<String, String> headers, ActionListener<IndexResponse> listener) {
        XContentBuilder builder;
        String id = config.getId();
        if (!headers.isEmpty()) {
            builder = new DataFrameAnalyticsConfig.Builder(config);
            Map<String, String> securityHeaders = headers.entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            builder.setHeaders(securityHeaders);
            config = builder.build();
        }
        try {
            builder = XContentFactory.jsonBuilder();
            try {
                config.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(TO_XCONTENT_PARAMS));
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest(AnomalyDetectorsIndex.configIndexName()).id(DataFrameAnalyticsConfig.documentId((String)config.getId())).opType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(builder);
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                    if (e instanceof VersionConflictEngineException) {
                        listener.onFailure((Exception)ExceptionsHelper.dataFrameAnalyticsAlreadyExists((String)id));
                    } else {
                        listener.onFailure(e);
                    }
                }));
            }
            finally {
                if (builder != null) {
                    builder.close();
                }
            }
        }
        catch (IOException e2) {
            listener.onFailure((Exception)new ElasticsearchParseException("Failed to serialise data frame analytics with id [" + config.getId() + "]", new Object[0]));
        }
    }

    public void get(String id, ActionListener<DataFrameAnalyticsConfig> listener) {
        GetDataFrameAnalyticsAction.Request request = new GetDataFrameAnalyticsAction.Request();
        request.setResourceId(id);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> {
            List analytics = response.getResources().results();
            if (analytics.size() != 1) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Expected a single match for data frame analytics [{}] but got [{}]", (Object[])new Object[]{id, analytics.size()})));
            } else {
                listener.onResponse((Object)((DataFrameAnalyticsConfig)analytics.get(0)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getMultiple(String ids, boolean allowNoMatch, ActionListener<List<DataFrameAnalyticsConfig>> listener) {
        GetDataFrameAnalyticsAction.Request request = new GetDataFrameAnalyticsAction.Request();
        request.setPageParams(new PageParams(0, 10000));
        request.setResourceId(ids);
        request.setAllowNoResources(allowNoMatch);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(response -> listener.onResponse((Object)response.getResources().results()), arg_0 -> listener.onFailure(arg_0)));
    }

    public void getConfigsForJobsWithTasksLeniently(final Set<String> jobsWithTask, final ActionListener<List<DataFrameAnalyticsConfig>> listener) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        query.filter((QueryBuilder)QueryBuilders.termQuery((String)DataFrameAnalyticsConfig.CONFIG_TYPE.getPreferredName(), (String)"data_frame_analytics_config"));
        query.filter((QueryBuilder)QueryBuilders.termsQuery((String)DataFrameAnalyticsConfig.ID.getPreferredName(), jobsWithTask));
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.configIndexName()});
        searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        searchRequest.source().size(10000);
        searchRequest.source().query((QueryBuilder)query);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                SearchHit[] hits = searchResponse.getHits().getHits();
                ArrayList<DataFrameAnalyticsConfig> configs = new ArrayList<DataFrameAnalyticsConfig>(hits.length);
                for (SearchHit hit : hits) {
                    BytesReference sourceBytes = hit.getSourceRef();
                    try (StreamInput stream = sourceBytes.streamInput();
                         XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(DataFrameAnalyticsConfigProvider.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                        configs.add(((DataFrameAnalyticsConfig.Builder)DataFrameAnalyticsConfig.LENIENT_PARSER.apply(parser, null)).build());
                    }
                    catch (IOException e) {
                        listener.onFailure((Exception)e);
                    }
                }
                HashSet tasksWithoutConfigs = new HashSet(jobsWithTask);
                tasksWithoutConfigs.removeAll(configs.stream().map(DataFrameAnalyticsConfig::getId).collect(Collectors.toList()));
                if (!tasksWithoutConfigs.isEmpty()) {
                    logger.warn("Data frame analytics tasks {} have no configs", tasksWithoutConfigs);
                }
                listener.onResponse(configs);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    static {
        HashMap<String, String> modifiable = new HashMap<String, String>();
        modifiable.put("include_type", "true");
        modifiable.put("for_internal_storage", "true");
        TO_XCONTENT_PARAMS = Collections.unmodifiableMap(modifiable);
    }
}

