/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public final class MappingsMerger {
    private MappingsMerger() {
    }

    public static void mergeMappings(Client client, Map<String, String> headers, String[] index, ActionListener<ImmutableOpenMap<String, MappingMetaData>> listener) {
        ActionListener mappingsListener = ActionListener.wrap(getMappingsResponse -> listener.onResponse(MappingsMerger.mergeMappings(getMappingsResponse)), arg_0 -> listener.onFailure(arg_0));
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(index);
        ClientHelper.executeWithHeadersAsync(headers, (String)"ml", (Client)client, (ActionType)GetMappingsAction.INSTANCE, (ActionRequest)getMappingsRequest, (ActionListener)mappingsListener);
    }

    static ImmutableOpenMap<String, MappingMetaData> mergeMappings(GetMappingsResponse getMappingsResponse) {
        ImmutableOpenMap indexToMappings = getMappingsResponse.getMappings();
        String type = null;
        HashMap<String, Object> mergedMappings = new HashMap<String, Object>();
        for (ObjectObjectCursor indexMappings : indexToMappings) {
            for (ObjectObjectCursor typeMapping : (ImmutableOpenMap)indexMappings.value) {
                Map currentMappings;
                if (type == null) {
                    type = (String)typeMapping.key;
                } else if (!type.equals(typeMapping.key)) {
                    throw ExceptionsHelper.badRequestException((String)"source indices contain mappings for different types: [{}, {}]", (Object[])new Object[]{type, typeMapping.key});
                }
                if (!(currentMappings = ((MappingMetaData)typeMapping.value).getSourceAsMap()).containsKey("properties")) continue;
                Map fieldMappings = (Map)currentMappings.get("properties");
                for (Map.Entry fieldMapping : fieldMappings.entrySet()) {
                    if (mergedMappings.containsKey(fieldMapping.getKey())) {
                        if (mergedMappings.get(fieldMapping.getKey()).equals(fieldMapping.getValue())) continue;
                        throw ExceptionsHelper.badRequestException((String)"cannot merge mappings because of differences for field [{}]", (Object[])new Object[]{fieldMapping.getKey()});
                    }
                    mergedMappings.put((String)fieldMapping.getKey(), fieldMapping.getValue());
                }
            }
        }
        MappingMetaData mappingMetaData = MappingsMerger.createMappingMetaData(type, mergedMappings);
        ImmutableOpenMap.Builder result = ImmutableOpenMap.builder();
        result.put(type, (Object)mappingMetaData);
        return result.build();
    }

    private static MappingMetaData createMappingMetaData(String type, Map<String, Object> mappings) {
        try {
            return new MappingMetaData(type, Collections.singletonMap("properties", mappings));
        }
        catch (IOException e) {
            throw ExceptionsHelper.serverError((String)("Failed to parse mappings: " + mappings));
        }
    }
}

