/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedUpdate;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class DatafeedConfigProvider {
    private static final Logger logger = LogManager.getLogger(DatafeedConfigProvider.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    public static final Map<String, String> TO_XCONTENT_PARAMS;

    public DatafeedConfigProvider(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public void putDatafeedConfig(DatafeedConfig config, Map<String, String> headers, ActionListener<IndexResponse> listener) {
        if (!headers.isEmpty()) {
            DatafeedConfig.Builder builder = new DatafeedConfig.Builder(config);
            Map<String, String> securityHeaders = headers.entrySet().stream().filter(e -> ClientHelper.SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            builder.setHeaders(securityHeaders);
            config = builder.build();
        }
        String datafeedId = config.getId();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            XContentBuilder source = config.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(TO_XCONTENT_PARAMS));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(AnomalyDetectorsIndex.configIndexName()).id(DatafeedConfig.documentId((String)datafeedId)).source(source).opType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
                if (e instanceof VersionConflictEngineException) {
                    listener.onFailure((Exception)ExceptionsHelper.datafeedAlreadyExists((String)datafeedId));
                } else {
                    listener.onFailure(e);
                }
            }));
        }
        catch (IOException e2) {
            listener.onFailure((Exception)new ElasticsearchParseException("Failed to serialise datafeed config with id [" + config.getId() + "]", (Throwable)e2, new Object[0]));
        }
    }

    public void getDatafeedConfig(final String datafeedId, final ActionListener<DatafeedConfig.Builder> datafeedConfigListener) {
        GetRequest getRequest = new GetRequest(AnomalyDetectorsIndex.configIndexName(), DatafeedConfig.documentId((String)datafeedId));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                if (!getResponse.isExists()) {
                    datafeedConfigListener.onFailure((Exception)ExceptionsHelper.missingDatafeedException((String)datafeedId));
                    return;
                }
                BytesReference source = getResponse.getSourceAsBytesRef();
                DatafeedConfigProvider.this.parseLenientlyFromSource(source, (ActionListener<DatafeedConfig.Builder>)datafeedConfigListener);
            }

            public void onFailure(Exception e) {
                if (e.getClass() == IndexNotFoundException.class) {
                    datafeedConfigListener.onFailure((Exception)ExceptionsHelper.missingDatafeedException((String)datafeedId));
                } else {
                    datafeedConfigListener.onFailure(e);
                }
            }
        });
    }

    public void findDatafeedsForJobIds(Collection<String> jobIds, ActionListener<Set<String>> listener) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(this.buildDatafeedJobIdsQuery(jobIds));
        sourceBuilder.fetchSource(false);
        sourceBuilder.docValueField(DatafeedConfig.ID.getPreferredName(), null);
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.configIndexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSize(jobIds.size()).setSource(sourceBuilder).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            HashSet<String> datafeedIds = new HashSet<String>();
            assert (response.getHits().getTotalHits().value <= (long)jobIds.size());
            for (SearchHit hit : hits = response.getHits().getHits()) {
                datafeedIds.add((String)hit.field(DatafeedConfig.ID.getPreferredName()).getValue());
            }
            listener.onResponse(datafeedIds);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void deleteDatafeedConfig(final String datafeedId, final ActionListener<DeleteResponse> actionListener) {
        DeleteRequest request = new DeleteRequest(AnomalyDetectorsIndex.configIndexName(), DatafeedConfig.documentId((String)datafeedId));
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    actionListener.onFailure((Exception)ExceptionsHelper.missingDatafeedException((String)datafeedId));
                    return;
                }
                assert (deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
                actionListener.onResponse((Object)deleteResponse);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    public void updateDatefeedConfig(final String datafeedId, final DatafeedUpdate update, final Map<String, String> headers, final BiConsumer<DatafeedConfig, ActionListener<Boolean>> validator, final ActionListener<DatafeedConfig> updatedConfigListener) {
        GetRequest getRequest = new GetRequest(AnomalyDetectorsIndex.configIndexName(), DatafeedConfig.documentId((String)datafeedId));
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                DatafeedConfig updatedConfig;
                DatafeedConfig.Builder configBuilder;
                if (!getResponse.isExists()) {
                    updatedConfigListener.onFailure((Exception)ExceptionsHelper.missingDatafeedException((String)datafeedId));
                    return;
                }
                long version = getResponse.getVersion();
                long seqNo = getResponse.getSeqNo();
                long primaryTerm = getResponse.getPrimaryTerm();
                BytesReference source = getResponse.getSourceAsBytesRef();
                try {
                    configBuilder = DatafeedConfigProvider.this.parseLenientlyFromSource(source);
                }
                catch (IOException e) {
                    updatedConfigListener.onFailure((Exception)new ElasticsearchParseException("Failed to parse datafeed config [" + datafeedId + "]", (Throwable)e, new Object[0]));
                    return;
                }
                try {
                    updatedConfig = update.apply(configBuilder.build(), headers);
                }
                catch (Exception e) {
                    updatedConfigListener.onFailure(e);
                    return;
                }
                ActionListener validatedListener = ActionListener.wrap(ok -> DatafeedConfigProvider.this.indexUpdatedConfig(updatedConfig, seqNo, primaryTerm, (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> {
                    assert (indexResponse.getResult() == DocWriteResponse.Result.UPDATED);
                    updatedConfigListener.onResponse((Object)updatedConfig);
                }, arg_0 -> ((ActionListener)updatedConfigListener).onFailure(arg_0))), arg_0 -> ((ActionListener)updatedConfigListener).onFailure(arg_0));
                validator.accept(updatedConfig, validatedListener);
            }

            public void onFailure(Exception e) {
                updatedConfigListener.onFailure(e);
            }
        });
    }

    private void indexUpdatedConfig(DatafeedConfig updatedConfig, long seqNo, long primaryTerm, ActionListener<IndexResponse> listener) {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            XContentBuilder updatedSource = updatedConfig.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(TO_XCONTENT_PARAMS));
            IndexRequest indexRequest = (IndexRequest)new IndexRequest(AnomalyDetectorsIndex.configIndexName()).id(DatafeedConfig.documentId((String)updatedConfig.getId())).source(updatedSource).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            indexRequest.setIfSeqNo(seqNo);
            indexRequest.setIfPrimaryTerm(primaryTerm);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, listener);
        }
        catch (IOException e) {
            listener.onFailure((Exception)new ElasticsearchParseException("Failed to serialise datafeed config with id [" + updatedConfig.getId() + "]", (Throwable)e, new Object[0]));
        }
    }

    public void expandDatafeedIds(String expression, boolean allowNoDatafeeds, ActionListener<SortedSet<String>> listener) {
        String[] tokens = ExpandedIdsMatcher.tokenizeExpression((String)expression);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(this.buildDatafeedIdQuery(tokens));
        sourceBuilder.sort(DatafeedConfig.ID.getPreferredName());
        sourceBuilder.fetchSource(false);
        sourceBuilder.docValueField(DatafeedConfig.ID.getPreferredName(), null);
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.configIndexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(sourceBuilder).setSize(10000).request();
        ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(tokens, allowNoDatafeeds);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            TreeSet<String> datafeedIds = new TreeSet<String>();
            for (SearchHit hit : hits = response.getHits().getHits()) {
                datafeedIds.add((String)hit.field(DatafeedConfig.ID.getPreferredName()).getValue());
            }
            requiredMatches.filterMatchedIds(datafeedIds);
            if (requiredMatches.hasUnmatchedIds()) {
                listener.onFailure((Exception)ExceptionsHelper.missingDatafeedException((String)requiredMatches.unmatchedIdsString()));
                return;
            }
            listener.onResponse(datafeedIds);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    public void expandDatafeedConfigs(String expression, boolean allowNoDatafeeds, ActionListener<List<DatafeedConfig.Builder>> listener) {
        String[] tokens = ExpandedIdsMatcher.tokenizeExpression((String)expression);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(this.buildDatafeedIdQuery(tokens));
        sourceBuilder.sort(DatafeedConfig.ID.getPreferredName());
        SearchRequest searchRequest = (SearchRequest)this.client.prepareSearch(new String[]{AnomalyDetectorsIndex.configIndexName()}).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setSource(sourceBuilder).setSize(10000).request();
        ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(tokens, allowNoDatafeeds);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            SearchHit[] hits;
            ArrayList<DatafeedConfig.Builder> datafeeds = new ArrayList<DatafeedConfig.Builder>();
            HashSet<String> datafeedIds = new HashSet<String>();
            for (SearchHit hit : hits = response.getHits().getHits()) {
                try {
                    BytesReference source = hit.getSourceRef();
                    DatafeedConfig.Builder datafeed = this.parseLenientlyFromSource(source);
                    datafeeds.add(datafeed);
                    datafeedIds.add(datafeed.getId());
                }
                catch (IOException e) {
                    logger.error("Error parsing datafeed configuration [" + hit.getId() + "]", (Throwable)e);
                }
            }
            requiredMatches.filterMatchedIds(datafeedIds);
            if (requiredMatches.hasUnmatchedIds()) {
                listener.onFailure((Exception)ExceptionsHelper.missingDatafeedException((String)requiredMatches.unmatchedIdsString()));
                return;
            }
            listener.onResponse(datafeeds);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private QueryBuilder buildDatafeedIdQuery(String[] tokens) {
        TermQueryBuilder datafeedQuery = new TermQueryBuilder(DatafeedConfig.CONFIG_TYPE.getPreferredName(), DatafeedConfig.TYPE);
        if (Strings.isAllOrWildcard((String[])tokens)) {
            return datafeedQuery;
        }
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)datafeedQuery);
        BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
        ArrayList<String> terms = new ArrayList<String>();
        for (String token : tokens) {
            if (Regex.isSimpleMatchPattern((String)token)) {
                shouldQueries.should((QueryBuilder)new WildcardQueryBuilder(DatafeedConfig.ID.getPreferredName(), token));
                continue;
            }
            terms.add(token);
        }
        if (!terms.isEmpty()) {
            shouldQueries.should((QueryBuilder)new TermsQueryBuilder(DatafeedConfig.ID.getPreferredName(), terms));
        }
        if (!shouldQueries.should().isEmpty()) {
            boolQueryBuilder.filter((QueryBuilder)shouldQueries);
        }
        return boolQueryBuilder;
    }

    private QueryBuilder buildDatafeedJobIdsQuery(Collection<String> jobIds) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.filter((QueryBuilder)new TermQueryBuilder(DatafeedConfig.CONFIG_TYPE.getPreferredName(), DatafeedConfig.TYPE));
        boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder(Job.ID.getPreferredName(), jobIds));
        return boolQueryBuilder;
    }

    private void parseLenientlyFromSource(BytesReference source, ActionListener<DatafeedConfig.Builder> datafeedConfigListener) {
        try (StreamInput stream = source.streamInput();
             XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
            datafeedConfigListener.onResponse((Object)((DatafeedConfig.Builder)DatafeedConfig.LENIENT_PARSER.apply(parser, null)));
        }
        catch (Exception e) {
            datafeedConfigListener.onFailure(e);
        }
    }

    private DatafeedConfig.Builder parseLenientlyFromSource(BytesReference source) throws IOException {
        try (StreamInput stream = source.streamInput();){
            DatafeedConfig.Builder builder;
            block12: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    builder = (DatafeedConfig.Builder)DatafeedConfig.LENIENT_PARSER.apply(parser, null);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return builder;
        }
    }

    static {
        HashMap<String, String> modifiable = new HashMap<String, String>();
        modifiable.put("for_internal_storage", "true");
        modifiable.put("include_type", "true");
        TO_XCONTENT_PARAMS = Collections.unmodifiableMap(modifiable);
    }
}

