/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.chunked;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.rollup.action.RollupSearchAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.RollupDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorContext;

public class ChunkedDataExtractor
implements DataExtractor {
    private static final Logger LOGGER = LogManager.getLogger(ChunkedDataExtractor.class);
    private static final String EARLIEST_TIME = "earliest_time";
    private static final String LATEST_TIME = "latest_time";
    private static final long MIN_CHUNK_SPAN = 60000L;
    private final Client client;
    private final DataExtractorFactory dataExtractorFactory;
    private final ChunkedDataExtractorContext context;
    private final DataSummaryFactory dataSummaryFactory;
    private final DatafeedTimingStatsReporter timingStatsReporter;
    private long currentStart;
    private long currentEnd;
    private long chunkSpan;
    private boolean isCancelled;
    private DataExtractor currentExtractor;

    public ChunkedDataExtractor(Client client, DataExtractorFactory dataExtractorFactory, ChunkedDataExtractorContext context, DatafeedTimingStatsReporter timingStatsReporter) {
        this.client = Objects.requireNonNull(client);
        this.dataExtractorFactory = Objects.requireNonNull(dataExtractorFactory);
        this.context = Objects.requireNonNull(context);
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
        this.currentStart = context.start;
        this.currentEnd = context.start;
        this.isCancelled = false;
        this.dataSummaryFactory = new DataSummaryFactory();
    }

    public boolean hasNext() {
        boolean currentHasNext;
        boolean bl = currentHasNext = this.currentExtractor != null && this.currentExtractor.hasNext();
        if (this.isCancelled()) {
            return currentHasNext;
        }
        return currentHasNext || this.currentEnd < this.context.end;
    }

    public Optional<InputStream> next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentExtractor == null) {
            this.setUpChunkedSearch();
        }
        return this.getNextStream();
    }

    private void setUpChunkedSearch() throws IOException {
        DataSummary dataSummary = this.dataSummaryFactory.buildDataSummary();
        if (dataSummary.hasData()) {
            this.currentEnd = this.currentStart = this.context.timeAligner.alignToFloor(dataSummary.earliestTime());
            this.chunkSpan = this.context.chunkSpan == null ? dataSummary.estimateChunk() : this.context.chunkSpan.getMillis();
            this.chunkSpan = this.context.timeAligner.alignToCeil(this.chunkSpan);
            LOGGER.debug("[{}] Chunked search configured: kind = {}, dataTimeSpread = {} ms, chunk span = {} ms", (Object)this.context.jobId, (Object)dataSummary.getClass().getSimpleName(), (Object)dataSummary.getDataTimeSpread(), (Object)this.chunkSpan);
        } else {
            this.currentEnd = this.context.end;
        }
    }

    protected SearchResponse executeSearchRequest(ActionRequestBuilder<SearchRequest, SearchResponse> searchRequestBuilder) {
        return (SearchResponse)ClientHelper.executeWithHeaders(this.context.headers, (String)"ml", (Client)this.client, () -> searchRequestBuilder.get());
    }

    private Optional<InputStream> getNextStream() throws IOException {
        while (this.hasNext()) {
            Optional nextStream;
            boolean isNewSearch = false;
            if (this.currentExtractor == null || !this.currentExtractor.hasNext()) {
                this.advanceTime();
                isNewSearch = true;
            }
            if ((nextStream = this.currentExtractor.next()).isPresent()) {
                return nextStream;
            }
            if (!isNewSearch || !this.hasNext()) continue;
            this.setUpChunkedSearch();
        }
        return Optional.empty();
    }

    private void advanceTime() {
        this.currentStart = this.currentEnd;
        this.currentEnd = Math.min(this.currentStart + this.chunkSpan, this.context.end);
        this.currentExtractor = this.dataExtractorFactory.newExtractor(this.currentStart, this.currentEnd);
        LOGGER.trace("[{}] advances time to [{}, {})", (Object)this.context.jobId, (Object)this.currentStart, (Object)this.currentEnd);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void cancel() {
        if (this.currentExtractor != null) {
            this.currentExtractor.cancel();
        }
        this.isCancelled = true;
    }

    public long getEndTime() {
        return this.context.end;
    }

    ChunkedDataExtractorContext getContext() {
        return this.context;
    }

    private class AggregatedDataSummary
    implements DataSummary {
        private final double earliestTime;
        private final double latestTime;
        private final long histogramIntervalMillis;

        private AggregatedDataSummary(double earliestTime, double latestTime, long histogramInterval) {
            this.earliestTime = earliestTime;
            this.latestTime = latestTime;
            this.histogramIntervalMillis = histogramInterval;
        }

        @Override
        public long estimateChunk() {
            return 1000L * this.histogramIntervalMillis;
        }

        @Override
        public boolean hasData() {
            return !(Double.isInfinite(this.earliestTime) || Double.isInfinite(this.latestTime));
        }

        @Override
        public long earliestTime() {
            return (long)this.earliestTime;
        }

        @Override
        public long getDataTimeSpread() {
            return (long)this.latestTime - (long)this.earliestTime;
        }
    }

    private class ScrolledDataSummary
    implements DataSummary {
        private long earliestTime;
        private long latestTime;
        private long totalHits;

        private ScrolledDataSummary(long earliestTime, long latestTime, long totalHits) {
            this.earliestTime = earliestTime;
            this.latestTime = latestTime;
            this.totalHits = totalHits;
        }

        @Override
        public long earliestTime() {
            return this.earliestTime;
        }

        @Override
        public long getDataTimeSpread() {
            return this.latestTime - this.earliestTime;
        }

        @Override
        public long estimateChunk() {
            long dataTimeSpread = this.getDataTimeSpread();
            if (this.totalHits <= 0L || dataTimeSpread <= 0L) {
                return ((ChunkedDataExtractor)ChunkedDataExtractor.this).context.end - ChunkedDataExtractor.this.currentEnd;
            }
            long estimatedChunk = 10L * ((long)((ChunkedDataExtractor)ChunkedDataExtractor.this).context.scrollSize * this.getDataTimeSpread()) / this.totalHits;
            return Math.max(estimatedChunk, 60000L);
        }

        @Override
        public boolean hasData() {
            return this.totalHits > 0L;
        }
    }

    private class DataSummaryFactory {
        private DataSummaryFactory() {
        }

        private DataSummary buildDataSummary() throws IOException {
            return ((ChunkedDataExtractor)ChunkedDataExtractor.this).context.hasAggregations ? this.newAggregatedDataSummary() : this.newScrolledDataSummary();
        }

        private DataSummary newScrolledDataSummary() throws IOException {
            SearchRequestBuilder searchRequestBuilder = this.rangeSearchRequest();
            SearchResponse searchResponse = ChunkedDataExtractor.this.executeSearchRequest((ActionRequestBuilder<SearchRequest, SearchResponse>)searchRequestBuilder);
            LOGGER.debug("[{}] Scrolling Data summary response was obtained", (Object)((ChunkedDataExtractor)ChunkedDataExtractor.this).context.jobId);
            ChunkedDataExtractor.this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
            ExtractorUtils.checkSearchWasSuccessful((String)((ChunkedDataExtractor)ChunkedDataExtractor.this).context.jobId, (SearchResponse)searchResponse);
            Aggregations aggregations = searchResponse.getAggregations();
            long earliestTime = 0L;
            long latestTime = 0L;
            long totalHits = searchResponse.getHits().getTotalHits().value;
            if (totalHits > 0L) {
                Min min = (Min)aggregations.get(ChunkedDataExtractor.EARLIEST_TIME);
                earliestTime = (long)min.getValue();
                Max max = (Max)aggregations.get(ChunkedDataExtractor.LATEST_TIME);
                latestTime = (long)max.getValue();
            }
            return new ScrolledDataSummary(earliestTime, latestTime, totalHits);
        }

        private DataSummary newAggregatedDataSummary() throws IOException {
            RollupSearchAction.RequestBuilder searchRequestBuilder = ChunkedDataExtractor.this.dataExtractorFactory instanceof RollupDataExtractorFactory ? this.rollupRangeSearchRequest() : this.rangeSearchRequest();
            SearchResponse searchResponse = ChunkedDataExtractor.this.executeSearchRequest((ActionRequestBuilder<SearchRequest, SearchResponse>)searchRequestBuilder);
            LOGGER.debug("[{}] Aggregating Data summary response was obtained", (Object)((ChunkedDataExtractor)ChunkedDataExtractor.this).context.jobId);
            ChunkedDataExtractor.this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
            ExtractorUtils.checkSearchWasSuccessful((String)((ChunkedDataExtractor)ChunkedDataExtractor.this).context.jobId, (SearchResponse)searchResponse);
            Aggregations aggregations = searchResponse.getAggregations();
            Min min = (Min)aggregations.get(ChunkedDataExtractor.EARLIEST_TIME);
            Max max = (Max)aggregations.get(ChunkedDataExtractor.LATEST_TIME);
            return new AggregatedDataSummary(min.getValue(), max.getValue(), ((ChunkedDataExtractor)ChunkedDataExtractor.this).context.histogramInterval);
        }

        private SearchSourceBuilder rangeSearchBuilder() {
            return new SearchSourceBuilder().size(0).query(ExtractorUtils.wrapInTimeRangeQuery((QueryBuilder)((ChunkedDataExtractor)ChunkedDataExtractor.this).context.query, (String)((ChunkedDataExtractor)ChunkedDataExtractor.this).context.timeField, (long)ChunkedDataExtractor.this.currentStart, (long)((ChunkedDataExtractor)ChunkedDataExtractor.this).context.end)).aggregation((AggregationBuilder)AggregationBuilders.min((String)ChunkedDataExtractor.EARLIEST_TIME).field(((ChunkedDataExtractor)ChunkedDataExtractor.this).context.timeField)).aggregation((AggregationBuilder)AggregationBuilders.max((String)ChunkedDataExtractor.LATEST_TIME).field(((ChunkedDataExtractor)ChunkedDataExtractor.this).context.timeField));
        }

        private SearchRequestBuilder rangeSearchRequest() {
            return new SearchRequestBuilder((ElasticsearchClient)ChunkedDataExtractor.this.client, SearchAction.INSTANCE).setIndices(((ChunkedDataExtractor)ChunkedDataExtractor.this).context.indices).setSource(this.rangeSearchBuilder()).setTrackTotalHits(true);
        }

        private RollupSearchAction.RequestBuilder rollupRangeSearchRequest() {
            SearchRequest searchRequest = new SearchRequest().indices(((ChunkedDataExtractor)ChunkedDataExtractor.this).context.indices).source(this.rangeSearchBuilder());
            return new RollupSearchAction.RequestBuilder((ElasticsearchClient)ChunkedDataExtractor.this.client, searchRequest);
        }
    }

    private static interface DataSummary {
        public long estimateChunk();

        public boolean hasData();

        public long earliestTime();

        public long getDataTimeSpread();
    }
}

