/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataDeleter;

public class TransportUpdateDatafeedAction
extends TransportMasterNodeAction<UpdateDatafeedAction.Request, PutDatafeedAction.Response> {
    private final Client client;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final JobConfigProvider jobConfigProvider;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;

    @Inject
    public TransportUpdateDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/datafeeds/update", transportService, clusterService, threadPool, actionFilters, UpdateDatafeedAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
        this.jobConfigProvider = new JobConfigProvider(client, xContentRegistry);
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
    }

    protected String executor() {
        return "same";
    }

    protected PutDatafeedAction.Response read(StreamInput in) throws IOException {
        return new PutDatafeedAction.Response(in);
    }

    protected void masterOperation(UpdateDatafeedAction.Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) throws Exception {
        if (this.migrationEligibilityCheck.datafeedIsEligibleForMigration(request.getUpdate().getId(), state)) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.configHasNotBeenMigrated((String)"update datafeed", (String)request.getUpdate().getId())));
            return;
        }
        Map headers = this.threadPool.getThreadContext().getHeaders();
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        if (MlTasks.getDatafeedTask((String)request.getUpdate().getId(), (PersistentTasksCustomMetaData)tasks) != null) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Cannot update datafeed [{0}] while its status is {1}", (Object[])new Object[]{request.getUpdate().getId(), DatafeedState.STARTED}), (Object[])new Object[0])));
            return;
        }
        String datafeedId = request.getUpdate().getId();
        CheckedConsumer updateConsumer = unused -> this.datafeedConfigProvider.updateDatefeedConfig(datafeedId, request.getUpdate(), headers, this.jobConfigProvider::validateDatafeedJob, (ActionListener<DatafeedConfig>)ActionListener.wrap(updatedConfig -> listener.onResponse((Object)new PutDatafeedAction.Response(updatedConfig)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        CheckedConsumer deleteTimingStatsAndUpdateConsumer = unused -> this.datafeedConfigProvider.getDatafeedConfig(datafeedId, (ActionListener<DatafeedConfig.Builder>)ActionListener.wrap(datafeedConfigBuilder -> {
            String jobId = datafeedConfigBuilder.build().getJobId();
            if (jobId.equals(request.getUpdate().getJobId())) {
                updateConsumer.accept(null);
            } else {
                JobDataDeleter jobDataDeleter = new JobDataDeleter(this.client, jobId);
                jobDataDeleter.deleteDatafeedTimingStats((ActionListener<BulkByScrollResponse>)ActionListener.wrap((CheckedConsumer)updateConsumer, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        if (request.getUpdate().getJobId() != null) {
            this.checkJobDoesNotHaveADifferentDatafeed(request.getUpdate().getJobId(), datafeedId, (ActionListener<Boolean>)ActionListener.wrap((CheckedConsumer)deleteTimingStatsAndUpdateConsumer, arg_0 -> listener.onFailure(arg_0)));
        } else {
            updateConsumer.accept(null);
        }
    }

    private void checkJobDoesNotHaveADifferentDatafeed(String jobId, String datafeedId, ActionListener<Boolean> listener) {
        this.datafeedConfigProvider.findDatafeedsForJobIds(Collections.singletonList(jobId), (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            if (datafeedIds.isEmpty()) {
                listener.onResponse((Object)Boolean.TRUE);
            } else if (datafeedIds.size() == 1 && datafeedIds.contains(datafeedId)) {
                listener.onResponse((Object)Boolean.TRUE);
            } else {
                listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)("A datafeed [" + (String)datafeedIds.iterator().next() + "] already exists for job [" + jobId + "]"), (Object[])new Object[0])));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(UpdateDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

