/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.ml.action.TransportStartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;

public class TransportStopDataFrameAnalyticsAction
extends TransportTasksAction<TransportStartDataFrameAnalyticsAction.DataFrameAnalyticsTask, StopDataFrameAnalyticsAction.Request, StopDataFrameAnalyticsAction.Response, StopDataFrameAnalyticsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStopDataFrameAnalyticsAction.class);
    private final ThreadPool threadPool;
    private final PersistentTasksService persistentTasksService;
    private final DataFrameAnalyticsConfigProvider configProvider;

    @Inject
    public TransportStopDataFrameAnalyticsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, PersistentTasksService persistentTasksService, DataFrameAnalyticsConfigProvider configProvider) {
        super("cluster:admin/xpack/ml/data_frame/analytics/stop", clusterService, transportService, actionFilters, StopDataFrameAnalyticsAction.Request::new, StopDataFrameAnalyticsAction.Response::new, StopDataFrameAnalyticsAction.Response::new, "same");
        this.threadPool = threadPool;
        this.persistentTasksService = persistentTasksService;
        this.configProvider = configProvider;
    }

    protected void doExecute(Task task, StopDataFrameAnalyticsAction.Request request, ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            this.redirectToMasterNode(nodes.getMasterNode(), request, listener);
            return;
        }
        logger.debug("Received request to stop data frame analytics [{}]", (Object)request.getId());
        ActionListener expandedIdsListener = ActionListener.wrap(expandedIds -> {
            logger.debug("Resolved data frame analytics to stop: {}", expandedIds);
            if (expandedIds.isEmpty()) {
                listener.onResponse((Object)new StopDataFrameAnalyticsAction.Response(true));
                return;
            }
            PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
            Set<String> analyticsToStop = TransportStopDataFrameAnalyticsAction.findAnalyticsToStop(tasks, expandedIds, request.isForce());
            request.setExpandedIds(analyticsToStop);
            request.setNodes(this.findAllocatedNodesAndRemoveUnassignedTasks(analyticsToStop, tasks));
            ActionListener finalListener = ActionListener.wrap(r -> this.waitForTaskRemoved((Set<String>)expandedIds, request, (StopDataFrameAnalyticsAction.Response)r, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            super.doExecute(task, (BaseTasksRequest)request, finalListener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.expandIds(state, request, (ActionListener<Set<String>>)expandedIdsListener);
    }

    static Set<String> findAnalyticsToStop(PersistentTasksCustomMetaData tasks, Set<String> ids, boolean force) {
        HashSet<String> startedAnalytics = new HashSet<String>();
        HashSet<String> stoppingAnalytics = new HashSet<String>();
        HashSet<String> failedAnalytics = new HashSet<String>();
        TransportStopDataFrameAnalyticsAction.sortAnalyticsByTaskState(ids, tasks, startedAnalytics, stoppingAnalytics, failedAnalytics);
        if (!force && !failedAnalytics.isEmpty()) {
            ElasticsearchStatusException e = failedAnalytics.size() == 1 ? org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"cannot close data frame analytics [{}] because it failed, use force stop instead", (Object[])new Object[]{failedAnalytics.iterator().next()}) : org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)"one or more data frame analytics are in failed state, use force stop instead", (Object[])new Object[0]);
            throw e;
        }
        startedAnalytics.addAll(failedAnalytics);
        return startedAnalytics;
    }

    private static void sortAnalyticsByTaskState(Set<String> analyticsIds, PersistentTasksCustomMetaData tasks, Set<String> startedAnalytics, Set<String> stoppingAnalytics, Set<String> failedAnalytics) {
        for (String analyticsId : analyticsIds) {
            switch (MlTasks.getDataFrameAnalyticsState((String)analyticsId, (PersistentTasksCustomMetaData)tasks)) {
                case STARTED: 
                case REINDEXING: 
                case ANALYZING: {
                    startedAnalytics.add(analyticsId);
                    break;
                }
                case STOPPING: {
                    stoppingAnalytics.add(analyticsId);
                    break;
                }
                case STOPPED: {
                    break;
                }
                case FAILED: {
                    failedAnalytics.add(analyticsId);
                    break;
                }
            }
        }
    }

    private void expandIds(ClusterState clusterState, StopDataFrameAnalyticsAction.Request request, ActionListener<Set<String>> expandedIdsListener) {
        ActionListener configsListener = ActionListener.wrap(configs -> {
            Set matchingIds = configs.stream().map(DataFrameAnalyticsConfig::getId).collect(Collectors.toSet());
            PersistentTasksCustomMetaData tasksMetaData = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
            Set startedIds = tasksMetaData == null ? Collections.emptySet() : tasksMetaData.tasks().stream().filter(t -> t.getId().startsWith("data_frame_analytics-")).map(t -> t.getId().replaceFirst("data_frame_analytics-", "")).collect(Collectors.toSet());
            startedIds.retainAll(matchingIds);
            expandedIdsListener.onResponse(startedIds);
        }, arg_0 -> expandedIdsListener.onFailure(arg_0));
        this.configProvider.getMultiple(request.getId(), request.allowNoMatch(), (ActionListener<List<DataFrameAnalyticsConfig>>)configsListener);
    }

    private String[] findAllocatedNodesAndRemoveUnassignedTasks(Set<String> analyticsIds, PersistentTasksCustomMetaData tasks) {
        ArrayList<String> nodes = new ArrayList<String>();
        for (String analyticsId : analyticsIds) {
            PersistentTasksCustomMetaData.PersistentTask task = MlTasks.getDataFrameAnalyticsTask((String)analyticsId, (PersistentTasksCustomMetaData)tasks);
            if (task == null) {
                String msg = "Requested data frame analytics [" + analyticsId + "] be stopped but the task could not be found";
                assert (task != null) : msg;
                continue;
            }
            if (task.isAssigned()) {
                nodes.add(task.getExecutorNode());
                continue;
            }
            this.persistentTasksService.sendRemoveRequest(task.getId(), ActionListener.wrap(r -> {}, e -> {}));
        }
        return nodes.toArray(new String[0]);
    }

    private void redirectToMasterNode(DiscoveryNode masterNode, StopDataFrameAnalyticsAction.Request request, ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        if (masterNode == null) {
            listener.onFailure((Exception)new MasterNotDiscoveredException("no known master node"));
        } else {
            this.transportService.sendRequest(masterNode, this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopDataFrameAnalyticsAction.Response::new));
        }
    }

    protected StopDataFrameAnalyticsAction.Response newResponse(StopDataFrameAnalyticsAction.Request request, List<StopDataFrameAnalyticsAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (request.getExpandedIds().size() != tasks.size()) {
            if (!taskOperationFailures.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
            }
            if (!failedNodeExceptions.isEmpty()) {
                throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
            }
            return new StopDataFrameAnalyticsAction.Response(true);
        }
        return new StopDataFrameAnalyticsAction.Response(tasks.stream().allMatch(StopDataFrameAnalyticsAction.Response::isStopped));
    }

    protected void taskOperation(final StopDataFrameAnalyticsAction.Request request, final TransportStartDataFrameAnalyticsAction.DataFrameAnalyticsTask task, final ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        DataFrameAnalyticsTaskState stoppingState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.STOPPING, task.getAllocationId(), null);
        task.updatePersistentTaskState((PersistentTaskState)stoppingState, ActionListener.wrap(pTask -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            protected void doRun() {
                logger.info("[{}] Stopping task with force [{}]", (Object)task.getParams().getId(), (Object)request.isForce());
                task.stop("stop_data_frame_analytics (api)", request.getTimeout());
                listener.onResponse((Object)new StopDataFrameAnalyticsAction.Response(true));
            }
        }), e -> {
            if (e instanceof ResourceNotFoundException) {
                listener.onResponse((Object)new StopDataFrameAnalyticsAction.Response(true));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    void waitForTaskRemoved(Set<String> analyticsIds, StopDataFrameAnalyticsAction.Request request, StopDataFrameAnalyticsAction.Response response, ActionListener<StopDataFrameAnalyticsAction.Response> listener) {
        this.persistentTasksService.waitForPersistentTasksCondition(persistentTasks -> TransportStopDataFrameAnalyticsAction.filterPersistentTasks(persistentTasks, analyticsIds).isEmpty(), request.getTimeout(), ActionListener.wrap(booleanResponse -> listener.onResponse((Object)response), arg_0 -> listener.onFailure(arg_0)));
    }

    private static Collection<PersistentTasksCustomMetaData.PersistentTask<?>> filterPersistentTasks(PersistentTasksCustomMetaData persistentTasks, Set<String> analyticsIds) {
        return persistentTasks.findTasks("xpack/ml/data_frame/analytics", t -> analyticsIds.contains(MlTasks.dataFrameAnalyticsIdFromTaskId((String)t.getId())));
    }
}

