/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.get.GetTaskRequest;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskResult;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.EstimateMemoryUsageAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.dataframe.MappingsMerger;
import org.elasticsearch.xpack.ml.dataframe.SourceDestValidator;
import org.elasticsearch.xpack.ml.dataframe.StoredProgress;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractor;
import org.elasticsearch.xpack.ml.dataframe.extractor.DataFrameDataExtractorFactory;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.job.JobNodeSelector;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportStartDataFrameAnalyticsAction
extends TransportMasterNodeAction<StartDataFrameAnalyticsAction.Request, AcknowledgedResponse> {
    private static final Logger LOGGER = LogManager.getLogger(TransportStartDataFrameAnalyticsAction.class);
    private final XPackLicenseState licenseState;
    private final Client client;
    private final PersistentTasksService persistentTasksService;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final MlMemoryTracker memoryTracker;

    @Inject
    public TransportStartDataFrameAnalyticsAction(TransportService transportService, Client client, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, XPackLicenseState licenseState, IndexNameExpressionResolver indexNameExpressionResolver, PersistentTasksService persistentTasksService, DataFrameAnalyticsConfigProvider configProvider, MlMemoryTracker memoryTracker) {
        super("cluster:admin/xpack/ml/data_frame/analytics/start", transportService, clusterService, threadPool, actionFilters, StartDataFrameAnalyticsAction.Request::new, indexNameExpressionResolver);
        this.licenseState = licenseState;
        this.client = client;
        this.persistentTasksService = persistentTasksService;
        this.configProvider = configProvider;
        this.memoryTracker = memoryTracker;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(StartDataFrameAnalyticsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(final StartDataFrameAnalyticsAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        if (!this.licenseState.isMachineLearningAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>> waitForAnalyticsToStart = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> task) {
                TransportStartDataFrameAnalyticsAction.this.waitForAnalyticsStarted((PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>)task, request.getTimeout(), (ActionListener<AcknowledgedResponse>)listener);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    e = new ElasticsearchStatusException("Cannot open data frame analytics [" + request.getId() + "] because it has already been opened", RestStatus.CONFLICT, e, new Object[0]);
                }
                listener.onFailure((Exception)e);
            }
        };
        AtomicReference configHolder = new AtomicReference();
        ActionListener memoryRequirementRefreshListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$0(request, configHolder, (ActionListener)waitForAnalyticsToStart, arg_0), arg_0 -> listener.onFailure(arg_0));
        ActionListener estimateMemoryUsageListener = ActionListener.wrap(estimateMemoryUsageResponse -> {
            if (((DataFrameAnalyticsConfig)configHolder.get()).getModelMemoryLimit().compareTo(estimateMemoryUsageResponse.getExpectedMemoryWithoutDisk()) < 0) {
                ElasticsearchStatusException e = ExceptionsHelper.badRequestException((String)"Cannot start because the configured model memory limit [{}] is lower than the expected memory usage [{}]", (Object[])new Object[]{((DataFrameAnalyticsConfig)configHolder.get()).getModelMemoryLimit(), estimateMemoryUsageResponse.getExpectedMemoryWithoutDisk()});
                listener.onFailure((Exception)((Object)e));
                return;
            }
            this.memoryTracker.addDataFrameAnalyticsJobMemoryAndRefreshAllOthers(request.getId(), ((DataFrameAnalyticsConfig)configHolder.get()).getModelMemoryLimit().getBytes(), (ActionListener<Void>)memoryRequirementRefreshListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener configListener = ActionListener.wrap(config -> {
            configHolder.set(config);
            PutDataFrameAnalyticsAction.Request estimateMemoryUsageRequest = new PutDataFrameAnalyticsAction.Request(config);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)EstimateMemoryUsageAction.INSTANCE, (ActionRequest)estimateMemoryUsageRequest, (ActionListener)estimateMemoryUsageListener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.getConfigAndValidate(request.getId(), (ActionListener<DataFrameAnalyticsConfig>)configListener);
    }

    private void getConfigAndValidate(String id, ActionListener<DataFrameAnalyticsConfig> finalListener) {
        ActionListener validateMappingsMergeListener = ActionListener.wrap(config -> DataFrameDataExtractorFactory.createForSourceIndices(this.client, "validate_source_index_has_rows-" + id, config, (ActionListener<DataFrameDataExtractorFactory>)ActionListener.wrap(dataFrameDataExtractorFactory -> dataFrameDataExtractorFactory.newExtractor(false).collectDataSummaryAsync((ActionListener<DataFrameDataExtractor.DataSummary>)ActionListener.wrap(dataSummary -> {
            if (dataSummary.rows == 0L) {
                finalListener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to start {} as there are no analyzable data in source indices [{}].", RestStatus.BAD_REQUEST, new Object[]{id, Strings.arrayToCommaDelimitedString((Object[])config.getSource().getIndex())})));
            } else {
                finalListener.onResponse(config);
            }
        }, arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener toValidateMappingsListener = ActionListener.wrap(config -> MappingsMerger.mergeMappings(this.client, config.getHeaders(), config.getSource().getIndex(), (ActionListener<ImmutableOpenMap<String, MappingMetaData>>)ActionListener.wrap(mappings -> validateMappingsMergeListener.onResponse(config), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0))), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener toValidateDestEmptyListener = ActionListener.wrap(config -> this.checkDestIndexIsEmptyIfExists((DataFrameAnalyticsConfig)config, (ActionListener<DataFrameAnalyticsConfig>)toValidateMappingsListener), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener getConfigListener = ActionListener.wrap(config -> {
            new SourceDestValidator(this.clusterService.state(), this.indexNameExpressionResolver).check((DataFrameAnalyticsConfig)config);
            DataFrameDataExtractorFactory.validateConfigAndSourceIndex(this.client, config, (ActionListener<DataFrameAnalyticsConfig>)toValidateDestEmptyListener);
        }, arg_0 -> finalListener.onFailure(arg_0));
        this.configProvider.get(id, (ActionListener<DataFrameAnalyticsConfig>)getConfigListener);
    }

    private void checkDestIndexIsEmptyIfExists(DataFrameAnalyticsConfig config, ActionListener<DataFrameAnalyticsConfig> listener) {
        String destIndex = config.getDest().getIndex();
        SearchRequest destEmptySearch = new SearchRequest(new String[]{destIndex});
        destEmptySearch.source().size(0);
        destEmptySearch.allowPartialSearchResults(false);
        ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"ml", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)destEmptySearch, (ActionListener)ActionListener.wrap(searchResponse -> {
            if (searchResponse.getHits().getTotalHits().value > 0L) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"dest index [{}] must be empty", (Object[])new Object[]{destIndex})));
            } else {
                listener.onResponse((Object)config);
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)config);
            } else {
                listener.onFailure(e);
            }
        }));
    }

    private void waitForAnalyticsStarted(final PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> task, TimeValue timeout, final ActionListener<AcknowledgedResponse> listener) {
        final AnalyticsPredicate predicate = new AnalyticsPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(task.getId(), (Predicate)predicate, timeout, (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<PersistentTaskParams>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<PersistentTaskParams> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartDataFrameAnalyticsAction.this.cancelAnalyticsStart((PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams>)task, predicate.exception, (ActionListener<AcknowledgedResponse>)listener);
                } else {
                    listener.onResponse((Object)new AcknowledgedResponse(true));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Starting data frame analytics [" + ((StartDataFrameAnalyticsAction.TaskParams)task.getParams()).getId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    private void cancelAnalyticsStart(final PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> persistentTask, final Exception exception, final ActionListener<AcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                LOGGER.error("[" + ((StartDataFrameAnalyticsAction.TaskParams)persistentTask.getParams()).getId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(ClusterState clusterState, String ... indexNames) {
        IndexNameExpressionResolver resolver = new IndexNameExpressionResolver();
        String[] concreteIndices = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), indexNames);
        ArrayList<String> unavailableIndices = new ArrayList<String>(concreteIndices.length);
        for (String index : concreteIndices) {
            IndexRoutingTable routingTable = clusterState.getRoutingTable().index(index);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    private /* synthetic */ void lambda$masterOperation$0(StartDataFrameAnalyticsAction.Request request, AtomicReference configHolder, ActionListener waitForAnalyticsToStart, Void aVoid) throws Exception {
        StartDataFrameAnalyticsAction.TaskParams taskParams = new StartDataFrameAnalyticsAction.TaskParams(request.getId(), ((DataFrameAnalyticsConfig)configHolder.get()).getVersion());
        this.persistentTasksService.sendStartRequest(MlTasks.dataFrameAnalyticsTaskId((String)request.getId()), "xpack/ml/data_frame/analytics", (PersistentTaskParams)taskParams, waitForAnalyticsToStart);
    }

    public static class TaskExecutor
    extends PersistentTasksExecutor<StartDataFrameAnalyticsAction.TaskParams> {
        private final Client client;
        private final ClusterService clusterService;
        private final DataFrameAnalyticsManager manager;
        private final MlMemoryTracker memoryTracker;
        private volatile int maxMachineMemoryPercent;
        private volatile int maxLazyMLNodes;
        private volatile int maxOpenJobs;
        private volatile ClusterState clusterState;

        public TaskExecutor(Settings settings, Client client, ClusterService clusterService, DataFrameAnalyticsManager manager, MlMemoryTracker memoryTracker) {
            super("xpack/ml/data_frame/analytics", "ml_utility");
            this.client = Objects.requireNonNull(client);
            this.clusterService = Objects.requireNonNull(clusterService);
            this.manager = Objects.requireNonNull(manager);
            this.memoryTracker = Objects.requireNonNull(memoryTracker);
            this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
            this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
            this.maxOpenJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxOpenJobs);
            clusterService.addListener(event -> {
                this.clusterState = event.state();
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<StartDataFrameAnalyticsAction.TaskParams> persistentTask, Map<String, String> headers) {
            return new DataFrameAnalyticsTask(id, type, action, parentTaskId, headers, this.client, this.clusterService, this.manager, (StartDataFrameAnalyticsAction.TaskParams)persistentTask.getParams());
        }

        public PersistentTasksCustomMetaData.Assignment getAssignment(StartDataFrameAnalyticsAction.TaskParams params, ClusterState clusterState) {
            boolean scheduledRefresh;
            if (MlMetadata.getMlMetadata((ClusterState)clusterState).isUpgradeMode()) {
                return MlTasks.AWAITING_UPGRADE;
            }
            String id = params.getId();
            List<String> unavailableIndices = TransportStartDataFrameAnalyticsAction.verifyIndicesPrimaryShardsAreActive(clusterState, AnomalyDetectorsIndex.configIndexName());
            if (unavailableIndices.size() != 0) {
                String reason = "Not opening data frame analytics job [" + id + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
                LOGGER.debug(reason);
                return new PersistentTasksCustomMetaData.Assignment(null, reason);
            }
            boolean isMemoryTrackerRecentlyRefreshed = this.memoryTracker.isRecentlyRefreshed();
            if (!isMemoryTrackerRecentlyRefreshed && (scheduledRefresh = this.memoryTracker.asyncRefresh())) {
                String reason = "Not opening data frame analytics job [" + id + "] because job memory requirements are stale - refresh requested";
                LOGGER.debug(reason);
                return new PersistentTasksCustomMetaData.Assignment(null, reason);
            }
            JobNodeSelector jobNodeSelector = new JobNodeSelector(clusterState, id, "xpack/ml/data_frame/analytics", this.memoryTracker, this.maxLazyMLNodes, node -> TaskExecutor.nodeFilter(node, id));
            return jobNodeSelector.selectNode(this.maxOpenJobs, Integer.MAX_VALUE, this.maxMachineMemoryPercent, isMemoryTrackerRecentlyRefreshed);
        }

        protected void nodeOperation(AllocatedPersistentTask task, StartDataFrameAnalyticsAction.TaskParams params, PersistentTaskState state) {
            LOGGER.info("[{}] Starting data frame analytics", (Object)params.getId());
            DataFrameAnalyticsTaskState analyticsTaskState = (DataFrameAnalyticsTaskState)state;
            if (analyticsTaskState != null && analyticsTaskState.getState().isAnyOf(new DataFrameAnalyticsState[]{DataFrameAnalyticsState.STOPPING, DataFrameAnalyticsState.FAILED})) {
                return;
            }
            if (analyticsTaskState == null) {
                DataFrameAnalyticsTaskState startedState = new DataFrameAnalyticsTaskState(DataFrameAnalyticsState.STARTED, task.getAllocationId(), null);
                task.updatePersistentTaskState((PersistentTaskState)startedState, ActionListener.wrap(response -> this.manager.execute((DataFrameAnalyticsTask)task, DataFrameAnalyticsState.STARTED, this.clusterState), arg_0 -> ((AllocatedPersistentTask)task).markAsFailed(arg_0)));
            } else {
                this.manager.execute((DataFrameAnalyticsTask)task, analyticsTaskState.getState(), this.clusterState);
            }
        }

        public static String nodeFilter(DiscoveryNode node, String id) {
            if (node.getVersion().before(StartDataFrameAnalyticsAction.TaskParams.VERSION_INTRODUCED)) {
                return "Not opening job [" + id + "] on node [" + JobNodeSelector.nodeNameAndVersion(node) + "], because the data frame analytics requires a node of version [" + StartDataFrameAnalyticsAction.TaskParams.VERSION_INTRODUCED + "] or higher";
            }
            return null;
        }

        void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
            this.maxMachineMemoryPercent = maxMachineMemoryPercent;
        }

        void setMaxLazyMLNodes(int maxLazyMLNodes) {
            this.maxLazyMLNodes = maxLazyMLNodes;
        }

        void setMaxOpenJobs(int maxOpenJobs) {
            this.maxOpenJobs = maxOpenJobs;
        }
    }

    public static class DataFrameAnalyticsTask
    extends AllocatedPersistentTask
    implements StartDataFrameAnalyticsAction.TaskMatcher {
        private final Client client;
        private final ClusterService clusterService;
        private final DataFrameAnalyticsManager analyticsManager;
        private final StartDataFrameAnalyticsAction.TaskParams taskParams;
        @Nullable
        private volatile Long reindexingTaskId;
        private volatile boolean isReindexingFinished;
        private volatile boolean isStopping;
        private volatile boolean isMarkAsCompletedCalled;
        private final ProgressTracker progressTracker = new ProgressTracker();

        public DataFrameAnalyticsTask(long id, String type, String action, TaskId parentTask, Map<String, String> headers, Client client, ClusterService clusterService, DataFrameAnalyticsManager analyticsManager, StartDataFrameAnalyticsAction.TaskParams taskParams) {
            super(id, type, action, "data_frame_analytics-" + taskParams.getId(), parentTask, headers);
            this.client = Objects.requireNonNull(client);
            this.clusterService = Objects.requireNonNull(clusterService);
            this.analyticsManager = Objects.requireNonNull(analyticsManager);
            this.taskParams = Objects.requireNonNull(taskParams);
        }

        public StartDataFrameAnalyticsAction.TaskParams getParams() {
            return this.taskParams;
        }

        public void setReindexingTaskId(Long reindexingTaskId) {
            this.reindexingTaskId = reindexingTaskId;
        }

        public void setReindexingFinished() {
            this.isReindexingFinished = true;
        }

        public boolean isStopping() {
            return this.isStopping;
        }

        public ProgressTracker getProgressTracker() {
            return this.progressTracker;
        }

        protected void onCancelled() {
            this.stop(this.getReasonCancelled(), TimeValue.ZERO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markAsCompleted() {
            DataFrameAnalyticsTask dataFrameAnalyticsTask = this;
            synchronized (dataFrameAnalyticsTask) {
                if (this.isMarkAsCompletedCalled) {
                    return;
                }
                this.isMarkAsCompletedCalled = true;
            }
            this.persistProgress(() -> super.markAsCompleted());
        }

        public void markAsFailed(Exception e) {
            this.persistProgress(() -> super.markAsFailed(e));
        }

        public void stop(String reason, TimeValue timeout) {
            this.isStopping = true;
            ActionListener reindexProgressListener = ActionListener.wrap(aVoid -> this.doStop(reason, timeout), e -> {
                LOGGER.error((Message)new ParameterizedMessage("[{}] Error updating reindexing progress", (Object)this.taskParams.getId()), (Throwable)e);
                this.doStop(reason, timeout);
            });
            this.updateReindexTaskProgress((ActionListener<Void>)reindexProgressListener);
        }

        private void doStop(String reason, TimeValue timeout) {
            if (this.reindexingTaskId != null) {
                this.cancelReindexingTask(reason, timeout);
            }
            this.analyticsManager.stop(this);
        }

        private void cancelReindexingTask(String reason, TimeValue timeout) {
            TaskId reindexTaskId = new TaskId(this.clusterService.localNode().getId(), this.reindexingTaskId.longValue());
            LOGGER.debug("[{}] Cancelling reindex task [{}]", (Object)this.taskParams.getId(), (Object)reindexTaskId);
            CancelTasksRequest cancelReindex = new CancelTasksRequest();
            cancelReindex.setTaskId(reindexTaskId);
            cancelReindex.setReason(reason);
            cancelReindex.setTimeout(timeout);
            CancelTasksResponse cancelReindexResponse = (CancelTasksResponse)this.client.admin().cluster().cancelTasks(cancelReindex).actionGet();
            Throwable firstError = null;
            if (!cancelReindexResponse.getNodeFailures().isEmpty()) {
                firstError = ((ElasticsearchException)cancelReindexResponse.getNodeFailures().get(0)).getRootCause();
            }
            if (!cancelReindexResponse.getTaskFailures().isEmpty()) {
                firstError = ((TaskOperationFailure)cancelReindexResponse.getTaskFailures().get(0)).getCause();
            }
            if (firstError != null && !(firstError instanceof ResourceNotFoundException)) {
                throw ExceptionsHelper.serverError((String)("[" + this.taskParams.getId() + "] Error cancelling reindex task"), (Throwable)firstError);
            }
            LOGGER.debug("[{}] Reindex task was successfully cancelled", (Object)this.taskParams.getId());
        }

        public void updateState(DataFrameAnalyticsState state, @Nullable String reason) {
            DataFrameAnalyticsTaskState newTaskState = new DataFrameAnalyticsTaskState(state, this.getAllocationId(), reason);
            this.updatePersistentTaskState((PersistentTaskState)newTaskState, ActionListener.wrap(updatedTask -> LOGGER.info("[{}] Successfully update task state to [{}]", (Object)this.getParams().getId(), (Object)state), e -> LOGGER.error((Message)new ParameterizedMessage("[{}] Could not update task state to [{}] with reason [{}]", new Object[]{this.getParams().getId(), state, reason}), (Throwable)e)));
        }

        public void updateReindexTaskProgress(ActionListener<Void> listener) {
            TaskId reindexTaskId = this.getReindexTaskId();
            if (reindexTaskId == null) {
                if (this.isReindexingFinished) {
                    this.progressTracker.reindexingPercent.set(100);
                }
                listener.onResponse(null);
                return;
            }
            GetTaskRequest getTaskRequest = new GetTaskRequest();
            getTaskRequest.setTaskId(reindexTaskId);
            this.client.admin().cluster().getTask(getTaskRequest, ActionListener.wrap(taskResponse -> {
                TaskResult taskResult = taskResponse.getTask();
                BulkByScrollTask.Status taskStatus = (BulkByScrollTask.Status)taskResult.getTask().getStatus();
                int progress = taskStatus.getTotal() == 0L ? 0 : (int)((double)taskStatus.getCreated() * 100.0 / (double)taskStatus.getTotal());
                this.progressTracker.reindexingPercent.set(progress);
                listener.onResponse(null);
            }, error -> {
                if (error instanceof ResourceNotFoundException) {
                    if (this.isReindexingFinished) {
                        this.progressTracker.reindexingPercent.set(100);
                    }
                    listener.onResponse(null);
                } else {
                    listener.onFailure(error);
                }
            }));
        }

        @Nullable
        private TaskId getReindexTaskId() {
            try {
                return new TaskId(this.clusterService.localNode().getId(), this.reindexingTaskId.longValue());
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        private void persistProgress(Runnable runnable) {
            GetDataFrameAnalyticsStatsAction.Request getStatsRequest = new GetDataFrameAnalyticsStatsAction.Request(this.taskParams.getId());
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, (ActionRequest)getStatsRequest, (ActionListener)ActionListener.wrap(statsResponse -> {
                GetDataFrameAnalyticsStatsAction.Response.Stats stats = (GetDataFrameAnalyticsStatsAction.Response.Stats)statsResponse.getResponse().results().get(0);
                IndexRequest indexRequest = new IndexRequest(AnomalyDetectorsIndex.jobStateIndexWriteAlias());
                indexRequest.id(DataFrameAnalyticsTask.progressDocId(this.taskParams.getId()));
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                try (XContentBuilder jsonBuilder = JsonXContent.contentBuilder();){
                    new StoredProgress(stats.getProgress()).toXContent(jsonBuilder, Payload.XContent.EMPTY_PARAMS);
                    indexRequest.source(jsonBuilder);
                }
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, (ActionListener)ActionListener.wrap(indexResponse -> {
                    LOGGER.debug("[{}] Successfully indexed progress document", (Object)this.taskParams.getId());
                    runnable.run();
                }, indexError -> {
                    LOGGER.error((Message)new ParameterizedMessage("[{}] cannot persist progress as an error occurred while indexing", (Object)this.taskParams.getId()), (Throwable)indexError);
                    runnable.run();
                }));
            }, e -> {
                LOGGER.error((Message)new ParameterizedMessage("[{}] cannot persist progress as an error occurred while retrieving stats", (Object)this.taskParams.getId()), (Throwable)e);
                runnable.run();
            }));
        }

        public static String progressDocId(String id) {
            return "data_frame_analytics-" + id + "-progress";
        }

        public static class ProgressTracker {
            public static final String REINDEXING = "reindexing";
            public static final String LOADING_DATA = "loading_data";
            public static final String ANALYZING = "analyzing";
            public static final String WRITING_RESULTS = "writing_results";
            public final AtomicInteger reindexingPercent = new AtomicInteger(0);
            public final AtomicInteger loadingDataPercent = new AtomicInteger(0);
            public final AtomicInteger analyzingPercent = new AtomicInteger(0);
            public final AtomicInteger writingResultsPercent = new AtomicInteger(0);

            public List<PhaseProgress> report() {
                return Arrays.asList(new PhaseProgress(REINDEXING, this.reindexingPercent.get()), new PhaseProgress(LOADING_DATA, this.loadingDataPercent.get()), new PhaseProgress(ANALYZING, this.analyzingPercent.get()), new PhaseProgress(WRITING_RESULTS, this.writingResultsPercent.get()));
            }
        }
    }

    private class AnalyticsPredicate
    implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
        private volatile Exception exception;

        private AnalyticsPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetaData.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null && assignment.equals((Object)JobNodeSelector.AWAITING_LAZY_ASSIGNMENT)) {
                return true;
            }
            if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetaData.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                this.exception = new ElasticsearchStatusException("Could not start data frame analytics task, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                return true;
            }
            DataFrameAnalyticsTaskState taskState = (DataFrameAnalyticsTaskState)persistentTask.getState();
            DataFrameAnalyticsState analyticsState = taskState == null ? DataFrameAnalyticsState.STOPPED : taskState.getState();
            switch (analyticsState) {
                case STARTED: 
                case REINDEXING: 
                case ANALYZING: {
                    return true;
                }
                case STOPPING: {
                    this.exception = ExceptionsHelper.conflictStatusException((String)"the task has been stopped while waiting to be started", (Object[])new Object[0]);
                    return true;
                }
                case STOPPED: {
                    return false;
                }
            }
            this.exception = ExceptionsHelper.serverError((String)("Unexpected task state [" + analyticsState + "] while waiting to be started"));
            return true;
        }
    }
}

