/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.SetUpgradeModeAction;
import org.elasticsearch.xpack.ml.utils.TypedChainTaskExecutor;

public class TransportSetUpgradeModeAction
extends TransportMasterNodeAction<SetUpgradeModeAction.Request, AcknowledgedResponse> {
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final PersistentTasksClusterService persistentTasksClusterService;
    private final PersistentTasksService persistentTasksService;
    private final ClusterService clusterService;
    private final Client client;

    @Inject
    public TransportSetUpgradeModeAction(TransportService transportService, ThreadPool threadPool, ClusterService clusterService, PersistentTasksClusterService persistentTasksClusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, PersistentTasksService persistentTasksService) {
        super("cluster:admin/xpack/ml/upgrade_mode", transportService, clusterService, threadPool, actionFilters, SetUpgradeModeAction.Request::new, indexNameExpressionResolver);
        this.persistentTasksClusterService = persistentTasksClusterService;
        this.clusterService = clusterService;
        this.client = client;
        this.persistentTasksService = persistentTasksService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(final SetUpgradeModeAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (!this.isRunning.compareAndSet(false, true)) {
            String msg = "Attempted to set [upgrade_mode] to [" + request.isEnabled() + "] from [" + MlMetadata.getMlMetadata((ClusterState)state).isUpgradeMode() + "] while previous request was processing.";
            IllegalStateException detail = new IllegalStateException(msg);
            listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Cannot change [upgrade_mode]. Previous request is still being processed.", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0])));
            return;
        }
        if (request.isEnabled() == MlMetadata.getMlMetadata((ClusterState)state).isUpgradeMode()) {
            this.isRunning.set(false);
            listener.onResponse((Object)new AcknowledgedResponse(true));
            return;
        }
        ActionListener wrappedListener = ActionListener.wrap(r -> {
            this.isRunning.set(false);
            listener.onResponse(r);
        }, e -> {
            this.isRunning.set(false);
            listener.onFailure(e);
        });
        PersistentTasksCustomMetaData tasksCustomMetaData = (PersistentTasksCustomMetaData)state.metaData().custom("persistent_tasks");
        ActionListener unassignPersistentTasksListener = ActionListener.wrap(unassigndPersistentTasks -> ((ListTasksRequestBuilder)((ListTasksRequestBuilder)this.client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"xpack/ml/datafeed[c]", "xpack/ml/job[c]"})).setWaitForCompletion(true).setTimeout(request.timeout())).execute(ActionListener.wrap(r -> {
            try {
                ExceptionsHelper.rethrowAndSuppress((List)r.getNodeFailures());
                wrappedListener.onResponse((Object)new AcknowledgedResponse(true));
            }
            catch (ElasticsearchException ex) {
                wrappedListener.onFailure((Exception)((Object)ex));
            }
        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0))), arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0));
        ActionListener isolateDatafeedListener = ActionListener.wrap(isolatedDatafeeds -> this.unassignPersistentTasks(tasksCustomMetaData, unassignPersistentTasksListener), arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0));
        ActionListener clusterStateUpdateListener = ActionListener.wrap(acknowledgedResponse -> {
            if (!acknowledgedResponse.isAcknowledged()) {
                wrappedListener.onFailure((Exception)new ElasticsearchTimeoutException("Unknown error occurred while updating cluster state", new Object[0]));
                return;
            }
            if (tasksCustomMetaData == null || tasksCustomMetaData.tasks().isEmpty()) {
                wrappedListener.onResponse((Object)new AcknowledgedResponse(true));
                return;
            }
            if (request.isEnabled()) {
                this.isolateDatafeeds(tasksCustomMetaData, (ActionListener<List<IsolateDatafeedAction.Response>>)isolateDatafeedListener);
            } else {
                this.persistentTasksService.waitForPersistentTasksCondition(persistentTasksCustomMetaData -> persistentTasksCustomMetaData.findTasks("xpack/ml/job", t -> t.getAssignment().equals((Object)MlTasks.AWAITING_UPGRADE)).isEmpty() && persistentTasksCustomMetaData.findTasks("xpack/ml/datafeed", t -> t.getAssignment().equals((Object)MlTasks.AWAITING_UPGRADE)).isEmpty(), request.timeout(), ActionListener.wrap(r -> wrappedListener.onResponse((Object)new AcknowledgedResponse(true)), arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0)));
            }
        }, arg_0 -> ((ActionListener)wrappedListener).onFailure(arg_0));
        this.clusterService.submitStateUpdateTask("ml-set-upgrade-mode", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>((AckedRequest)request, clusterStateUpdateListener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                MlMetadata.Builder builder = new MlMetadata.Builder((MlMetadata)currentState.metaData().custom("ml"));
                builder.isUpgradeMode(request.isEnabled());
                ClusterState.Builder newState = ClusterState.builder((ClusterState)currentState);
                newState.metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)builder.build()).build());
                return newState.build();
            }
        });
    }

    protected ClusterBlockException checkBlock(SetUpgradeModeAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void unassignPersistentTasks(PersistentTasksCustomMetaData tasksCustomMetaData, ActionListener<List<PersistentTasksCustomMetaData.PersistentTask<?>>> listener) {
        List datafeedAndJobTasks = tasksCustomMetaData.tasks().stream().filter(persistentTask -> persistentTask.getTaskName().equals("xpack/ml/job") || persistentTask.getTaskName().equals("xpack/ml/datafeed")).sorted(Comparator.comparing(PersistentTasksCustomMetaData.PersistentTask::getTaskName)).collect(Collectors.toList());
        this.logger.info("Un-assigning persistent tasks : " + datafeedAndJobTasks.stream().map(PersistentTasksCustomMetaData.PersistentTask::getId).collect(Collectors.joining(", ", "[ ", " ]")));
        TypedChainTaskExecutor<PersistentTasksCustomMetaData.PersistentTask> chainTaskExecutor = new TypedChainTaskExecutor<PersistentTasksCustomMetaData.PersistentTask>(this.client.threadPool().executor(this.executor()), r -> true, ex -> !(ex instanceof ResourceNotFoundException));
        for (PersistentTasksCustomMetaData.PersistentTask task : datafeedAndJobTasks) {
            chainTaskExecutor.add(chainedTask -> this.persistentTasksClusterService.unassignPersistentTask(task.getId(), task.getAllocationId(), MlTasks.AWAITING_UPGRADE.getExplanation(), chainedTask));
        }
        chainTaskExecutor.execute(listener);
    }

    private void isolateDatafeeds(PersistentTasksCustomMetaData tasksCustomMetaData, ActionListener<List<IsolateDatafeedAction.Response>> listener) {
        Set datafeedsToIsolate = MlTasks.startedDatafeedIds((PersistentTasksCustomMetaData)tasksCustomMetaData);
        this.logger.info("Isolating datafeeds: " + datafeedsToIsolate.toString());
        TypedChainTaskExecutor<IsolateDatafeedAction.Response> isolateDatafeedsExecutor = new TypedChainTaskExecutor<IsolateDatafeedAction.Response>(this.client.threadPool().executor(this.executor()), r -> true, ex -> true);
        datafeedsToIsolate.forEach(datafeedId -> {
            IsolateDatafeedAction.Request isolationRequest = new IsolateDatafeedAction.Request(datafeedId);
            isolateDatafeedsExecutor.add(isolateListener -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)IsolateDatafeedAction.INSTANCE, (ActionRequest)isolationRequest, (ActionListener)isolateListener));
        });
        isolateDatafeedsExecutor.execute(listener);
    }
}

